;
; *** Listing 9-13 ***
;
; Adds together two 64-bit memory variables, taking
; advantage of the fact that neither INC nor LOOP affects
; the Carry flag.
;
; Note: This is a sample code fragment, and is not intended
; to either be run under the Zen timer or assembled as a
; standalone program.
;
	jmp	Skip
;
MemVar1		db	2, 0, 0, 0, 0, 0, 0, 0
MEM_VAR_LEN	equ	($-MemVar1)
MemVar2		db	0feh, 0ffh, 0ffh, 0ffh, 0, 0, 0, 0
;
Skip:
	mov	si,offset MemVar1 ;set up memory variable
	mov	di,offset MemVar2 ; pointers
	mov	ax,[si]		;add the first words
	add	[di],ax		; together
	mov	cx,(MEM_VAR_LEN/2)-1
				;we'll add together the
				; remaining 3 words in
				; each variable
AdditionLoop:
	inc	si
	inc	si		;point to next word
	inc	di		; (doesn't affect Carry
	inc	di		; flag)
	mov	ax,[si]		;add the next words
	adc	[di],ax		; together-C flag still set
				; from last addition
	loop	AdditionLoop	;add the next word of each
				; variable together
