;
; *** Listing 7-11 ***
;
; Adds up the elements of a byte-sized array using
; base-only addressing inside the loop.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
TestArray	db	ARRAY_LENGTH dup (1)
TEST_START_OFFSET equ	200	;we'll add elements 200-299
TEST_LENGTH	equ	100	; of TestArray
;
Skip:
	call	ZTimerOn
	mov	bx,offset TestArray+TEST_START_OFFSET
				;build the array start
				; offset right into the
				; base so we can use
				; base addressing, with no
				; displacement
	sub	ax,ax		;initialize sum
	sub	dl,dl		;store 0 in DL so we can use
				; it for faster register-
				; register adds in the loop
	mov	cx,TEST_LENGTH	;# of bytes to add
SumArrayLoop:
	add	al,[bx]		;add in the next byte
	adc	ah,dl		; to the 16-bit sum
	inc	bx		;point to next byte 
	loop	SumArrayLoop
	call	ZTimerOff
