include	asm.inc

public	syssoft
extrn	isems:proc, ismouse:proc, isherc:proc
extrn	floppies:proc, floppytype:proc, isansi:proc
extrn	getkey:proc, getcrt:proc, path:proc
extrn	getcpu:proc, mathchip:proc, exename:proc
extrn	wclear:proc, wframe:proc, tprint:proc
extrn	hfree:proc, strndup:proc

.data
extrn	pspseg:word
notinstalled	db 'Not installed',0

i8086		db '8086 or 8088',0
i186		db '80186 or 80188',0
i286		db 'i286',0
i386		db '386',0
i486		db '486',0

cpu_table	dw i8086
		dw i186
		dw i286
		dw i386
		dw i486

no87		db 'none',0
mc8087		db '8087',0
mc287		db '287',0
mc387		db '387',0
mc487		db '487',0

mathchip_table	dw no87
		dw mc8087
		dw mc287
		dw mc387
		dw mc487

; window corner data
r0	dw 3
c0	dw 5
r1	dw 23
c1	dw 74
window_color	db 0Ch		; bright red, black background
text_color	db 07h

; labels
labels	db 'CPU:          ',0
size_of_label	equ $-labels
	db '80x87:        ',0
	db 'EMS:          ',0
	db 'Program name: ',0
	db 'ANSI:         ',0
	db 'Path:         ',0
number_of_labels	equ ($-labels)/size_of_label

isinstalled	db 'installed and active',0

.code
syssoft	proc
; count the number of PATHs to determine size of window
	xor	ax,ax
count_path:
	mov	es,pspseg
	call	path
	jcxz	done_counting
	inc	ax
	jmp	count_path
done_counting:
	add	ax,number_of_labels
	add	ax,r0
	mov	r1,ax

; clear a window for the system info
	lea	bx,r0
	mov	ah,window_color
	call	wclear
	mov	al,-1		; double-lined window frame
	call	wframe

; print labels at left side of window
	mov	cx,number_of_labels
	mov	dh,byte ptr r0
	mov	dl,byte ptr c0
	inc	dl
	lea	si,labels
	mov	ah,text_color
label_loop:
	inc	dh
	call	tprint
	add	si,size_of_label
	loop	label_loop

; determine CPU type
	call	getcpu
	mov	bx,ax
	shl	bx,1
	mov	si,cpu_table[bx]
	mov	dh,byte ptr r0
	inc	dh
	mov	dl,byte ptr c0
	add	dl,size_of_label
	mov	ah,text_color
	call	tprint

; math coprocessor
	call	mathchip
	mov	bx,ax
	shl	bx,1
	mov	si,mathchip_table[bx]
	inc	dh
	mov	ah,text_color
	call	tprint

; EMS memory
	inc	dh
	call	isems
	lea	si,notinstalled
	jc	print_ems
	lea	si,isinstalled
print_ems:
	mov	ah,text_color
	call	tprint

; program name
	inc	dh
	mov	es,pspseg
	call	exename		; returns ES:[BX] pointing to .EXE name
	mov	si,bx
	mov	ah,text_color
	push	ds
	push	es
	pop	ds		; DS:[SI] points to .EXE name
	call	tprint
	pop	ds

; ANSI
	inc	dh
	call	isansi
	lea	si,isinstalled
	jnc	print_ansi
	lea	si,notinstalled
print_ansi:
	mov	ah,text_color
	call	tprint

; path
	xor	ax,ax
next_path:
	mov	es,pspseg
	call	path
	jcxz	no_more_paths
	call	strndup
	mov	si,bx
	inc	dh
	push	ax
	mov	ah,text_color
	call	tprint
	call	hfree
	pop	ax
	inc	ax
	jmp	next_path

no_more_paths:
	call	getkey
	ret
syssoft	endp
	end
