
013/031 18 Jul 90 00:48:00
From:   garth kidd
To:     Ken Manton
Subj:   TSR s
Attr:   
------------------------------------------------
 > I need a little assembler program that will
 > capture ALT / off the keyboard and send FEh to
 > LPT2 (I use this to turn on power to LPT1)
 >
 > I have the program using LDRES.COM but that does
 > much more than I need and anyway I am learning
 > assembler and I want to find out a simpler way of
 > doing things. I understand how to direct INT 9 to
 > my own handler  but I don't know how to intercept
 > the keyboard after that...or how to return control
 > to the original vector. I am forever rebooting
 > because of loss of keyboard input. A few hints
 > would be most welcome...I already have popped a
 > similar question on this spot before and have
 > several replies, however I guess I need a little
 > more information. Thanks in anticipation

Try this:

===========================================================

getvec          equ 35h
setvec          equ 25h
key_int         equ 9

old_key_add     equ $
old_key_off     dw 0
old_key_seg     dw 0

;
; swap keyb vector to our routine
;
        ; push trashed segment variable

        push es                     ; getvec returns value
                                    ; in es.

        ; get old vector and save it somewhere

        mov al, key_int
        mov ah, getvec
        int 21h
        mov [old_key_off], bx
        mov bx, es
        mov [old_key_seg], bx

        ; set the vector to cs:newkey_entry
        ;
        ; assumes that DS=CS, i.e. you're using the TINY
        ; model. if this isn't true, make sure that DS
        ; points to the segment of your new key routine on
        ; entry.

        mov dx, offset newkey_entry
        mov ah, setvec
        int 21h

        ; recover

        pop es


;
; swap keyboard vector back
;

        push ds

        mov dx, [old_key_off]
        mov bx, [old_key_seg]
        mov ds, bx
        int 21h

        pop ds

;
; custom keyboard interrupt -- this is straight out of my
; code for ROTSR.
;

;-----------------------------------------------------------
; keyboard interrupt
;-----------------------------------------------------------
;
; Entry point for the keyboard interrupt.

key_entry proc near

        sti
        pushf
        push ax
        push ds
        push dx

        cmp byte ptr cs:[inhibit], 0    ; are we inhibited?
        jne @@1                         ;  yes -- exit

        in al, 60h                      ; get scancode

        cmp al, scancode                ; is it hotkey down?
        je @@2                          ;  yes -- jmp

        cmp al, scanrelease             ; is it hotkey up?
        je @@3                          ;  yes -- jmp

@@1:    pop dx
        pop ds
        pop ax
        popf
        pushf
        call dword ptr cs:[old_key_add]
        iret

@@2:    ; check for correct shift mask

        mov ax, 0
        mov ds, ax
        mov ax, ds:[417h]
        and ax, shiftmask
        xor ax, shiftmask
        jne @@1

        ; mask is correct -- hide keystroke

        mov dx,61h
        in al,dx
        push ax
        or al,80h
        out dx,al
        pop ax
        out dx,al
        mov dx,20h
        mov al,20h
        out dx,al

        ; set goforit

        mov byte ptr cs:[goforit], 1
        pop dx
        pop ds
        pop ax
        popf
        iret

@@3:    mov cs:[goforit], 0             ;  yes -- turn
                                        ;  "goforit" off.

        jmp @@1

key_entry endp

===========================================================

Hope that helps. The complete source code for ROTSR is available -- just send 
me some netmail. I'm not posting it because it's near 30k long. To give you an 
idea of the commenting, the executable is 1873 bytes long.


gk

--- FD 1.99c
 * Origin: deadly bloody serious v1.3 (3:680/828)
