// ******************************************************************** //
//                                                                      //
//  PCDEZIP.CPP  Copyright 1994, Bob Flanders and Michael Holmes      //
//  First Published in PC Magazine January 11, 1994                     //
//                                                                      //
//  PCDEZIP decompresses .ZIP files created with PKZIP through          //
//  version 2.04g.  PCDEZIP provides syntax and switch compatibilty     //
//  with both Michael Mefford's PCUNZP and Phil Katz's PKUNZIP.         //
//  Although PCDEZIP does not handle encrypted files or files which     //
//  span multiple diskettes, it does however, process the majority of   //
//  command line switches which are used everyday.                      //
//                                                                      //
//                                                                      //
//  usage:  PCDEZIP  [switches]  zipfile  [target\]  [filespec [...]]   //
//                                                                      //
//  switches: -f  freshen existing files                                //
//            -n  extract new and updated files                         //
//            -o  do not prompt on overwrite                            //
//            -v  view ZIP directory                                    //
//            -d  create directories                                    //
//            -t  test file integrity                                   //
//                                                                      //
//  zipfile   is source .ZIP file                                       //
//                                                                      //
//  target\   is the target directory; trailing backslash required      //
//                                                                      //
//  filenames are files to be extracted; wildcards supported            //
//                                                                      //
// ******************************************************************** //

// ******************************************************************** //
//                                                                      //
//  Compile PCDEZIP using the following vendor specific commands.       //
//                                                                      //
//    Borland C++ version 3.1                                           //
//      BCC -w -O2 pcdezip.cpp                                          //
//                                                                      //
//    Microsoft C/C++ version 7.0                                       //
//      CL /AS /O pcdezip.cpp                                           //
//                                                                      //
// ******************************************************************** //

// ******************************************************************** //
//                                                                      //
//  Modifications Log                                                   //
//                                                                      //
//  Versn    Date    Author           Description                       //
//  ----- ---------  ---------------  --------------------------------  //
//   1.0  xx Nov 93  Flanders/Holmes  Initial release.                  //
//                                                                      //
// ******************************************************************** //


#include <stdio.h>                          // standard i/o library
#include <stdarg.h>                         // variable argument list
#include <string.h>                         // string handling routines
#include <stdlib.h>                         // std conversion routines
#include <dos.h>                            // dos functions
#include <conio.h>                          // console functions
#include <bios.h>                           // bios functions
#include <io.h>                             // i/o functions
#include <direct.h>                         // ..more directory routines
#include <fcntl.h>                          // ..and file control
#include <malloc.h>                         // memory functions

#if defined(__TURBOC__) || defined(__BORLANDC__)    // BC++ 3.1
#define  _BC_VER                            // Borland compiler shorthand
#include <ctype.h>                          // character routines
#include <dir.h>                            // directory routines
#include <sys\stat.h>                       // ..attribute bits
#endif


#if defined(_MSC_VER)                       // MSC C/C++ 7
#include <sys\types.h>                      // system types
#include <sys\stat.h>                       // ..attribute bits
#define findfirst(b,s,a)    _dos_findfirst(b,a,s)   // call compatibility
#define farmalloc(x)        _fmalloc(x)
#define farfree(x)          _ffree(x)
#define fnsplit(a,b,c,d,e)  _splitpath(a,b,c,d,e)
#define MK_FP(s,o)                                                       \
          (void far *)                                                   \
              (((long) s << 16) | (long) o) /* make a far pointer       */
#define ctrlbrk(c)                          // fnc not available
#define _dos_setvect(x, c)                  // fnc not available, also
#endif


#define COUNT(x) (sizeof(x) / sizeof(x[0])) // item count
#define NOT         !                       // shorthand logical
#define UINT        unsigned int            // unsigned integer
#define BYTE        unsigned char           // ..and unsigned character
#define ULONG       unsigned long           // ..and unsigned long
#define MAX_PATH    79                      // maximum path length
#define LAST(s)     s[strlen(s) - 1]        // last character in string
#define TRUE        1                       // true value
#define FALSE       0                       // false value
#define BUFFER_SIZE 32768L                  // dictionary/output buffer size
#define COPY_BUFFER 16384                   // copy buffer size
#define FILE_ATTR   _A_NORMAL | _A_RDONLY   // file attrib to search on


/* ******************************************************************** *
 *
 *  Header Definitions
 *
 * ******************************************************************** */

struct lf                                   // local file header
    {
    ULONG lf_sig;                               // signature (0x04034b50)
    UINT  lf_extract,                           // vers needed to extract
          lf_flag,                              // general purpose flag
          lf_cm,                                // compression method
          lf_time,                              // file time
          lf_date;                              // ..and file date
    ULONG lf_crc,                               // CRC-32 for file
          lf_csize,                             // compressed size
          lf_size;                              // uncompressed size
    int   lf_fn_len,                            // file name length
          lf_ef_len;                            // extra field length
    };


struct dd                                   // data descriptor
    {
    ULONG dd_crc,                               // CRC-32 for file
          dd_csize,                             // compressed size
          dd_size;                              // uncompressed size
    };


struct fh                                   // file header
    {
    ULONG fh_sig;                               // signature (0x02014b50)
    int   fh_made,                              // version made by
          fh_extract,                           // vers needed to extract
          fh_flag,                              // general purpose flag
          fh_cm,                                // compression method
          fh_time,                              // file time
          fh_date;                              // ..and file date
    ULONG fh_crc,                               // CRC-32 for file
          fh_csize,                             // compressed size
          fh_size;                              // uncompressed size
    int   fh_fn_len,                            // file name length
          fh_ef_len,                            // extra field length
          fh_fc_len,                            // file comment length
          fh_disk,                              // disk number
          fh_attr;                              // internal file attrib
    ULONG fh_eattr,                             // external file attrib
          fh_offset;                            // offset of local header
    };


struct ed                                   // end of central dir record
    {
    ULONG ed_sig;                               // signature (0x06054b50)
    int   ed_disk,                              // this disk number
          ed_cdisk,                             // disk w/central dir
          ed_current,                           // current disk's dir entries
          ed_total;                             // total dir entries
    ULONG ed_size,                              // size of central dir
          ed_offset;                            // offset of central dir
    int   ed_zc_len;                            // zip file comment length
    };


typedef struct lf LF;                       // set up
typedef struct fh FH;                       // ..structure
typedef struct dd DD;                       // ..shorthands
typedef struct ed ED;                       //


#define LF_SIG              0x0403          // local file header signature
#define FH_SIG              0x0201          // file header signature
#define ED_SIG              0x0605          // end of central dir signature

                                            // general purpose flag
#define LH_FLAG_ENCRYPT     0x01                // file is encrypted

                                                // for Method 6 - Imploding
#define LF_FLAG_8K          0x02                // use 8k dictionary vs 4k
#define LF_FLAG_3SF         0x04                // use 3 S-F trees vs 2

                                                // for Method 8 - Deflating
#define LF_FLAG_NORM        0x00                // normal compression
#define LF_FLAG_MAX         0x02                // maximum compression
#define LF_FLAG_FAST        0x04                // fast compression
#define LF_FLAG_SUPER       0x06                // super fast compression
#define LF_FLAG_DDREC       0x08                // use data descriptor record

                                            // compression method
#define LF_CM_STORED        0x00                // stored
#define LF_CM_SHRUNK        0x01                // shrunk
#define LF_CM_REDUCED1      0x02                // reduced with factor 1
#define LF_CM_REDUCED2      0x03                // reduced with factor 2
#define LF_CM_REDUCED3      0x04                // reduced with factor 3
#define LF_CM_REDUCED4      0x05                // reduced with factor 4
#define LF_CM_IMPLODED      0x06                // imploded
#define LF_CM_TOKENIZED     0x07                // tokenized (not used)
#define LF_CM_DEFLATED      0x08                // deflated



/* ******************************************************************** *
 *
 *  LZW Support Structures
 *
 * ******************************************************************** */

#define TABLE_SIZE          0x2001          // dictionary table size
#define FREE                0xffff          // free entry value

struct  dictionary                          // dictionary entry
    {
    UINT parent_c;                              // parent's code
    char c;                                     // replacement character
    };

typedef struct dictionary SD;               // structure shorthand



/* ******************************************************************** *
 *
 *  Expanded Structures
 *
 * ******************************************************************** */

#define EXPLODE_DLE         144             // escape character
#define EXPAND_BUFF         4096            // sliding buffer size

struct  follower_set                        // follower set
    {
    BYTE set_len,                               // set length
         set[32];                               // set
    };

typedef struct follower_set FS;             // structure shorthand



/* ******************************************************************** *
 *
 *  Shannon-Fano Tree Structure
 *
 * ******************************************************************** */

struct  shannon_fano_tree                   // Shannon-Fano trees
    {
    BYTE blen,                                  // bit length
         value;                                 // value
    UINT code;                                  // tree bit code
    };

typedef struct shannon_fano_tree SFT;       // structure shorthand



/* ******************************************************************** *
 *
 *  Huffman Tree Structure
 *
 * ******************************************************************** */

struct  huffman_tree                        // Huffman trees
    {
    BYTE eb,                                    // extra bits
         blen;                                  // bit length
    union
        {
        UINT code;                              // literal, len or distance
        struct huffman_tree *table;             // chain pointer
        } v;
    };

typedef struct huffman_tree HUFF;           // structure shorthand



/* ******************************************************************** *
 *
 *  PCDEZIP Includes
 *
 * ******************************************************************** */

#include "globals.cpp"                      // global work areas
#include "utility.cpp"                      // utility functions
#include "crc32.cpp"                        // crc 32 function
#include "view.cpp"                         // view zip directory
#include "extract.cpp"                      // extract files



/* ******************************************************************** *
 *
 *  initialization() -- init interrupts and parse command line
 *
 * ******************************************************************** */

void    initialization(int  ac,             // DOS cmd line token count
                       char *av[])          // ..token strings
{
int     i, j;                               // loop control


init_path = getcwd(NULL, MAX_PATH);         // get current directory
ctrlbrk(control_break);                     // set up ctrl break handler
_dos_setvect(0x24, critical_routine);       // ..and DOS critical handler

pos_count = parse_parms(ac, av,             // parse switches and
        COUNT(parm_table), parm_table,      // ..positional parameters
        &pos_parms);                        // ..and based on parm count

if (pos_count < 1)                          // q. zip file name given?
    quit_with(help);                        // a. no .. quit w/help message

if (pos_count > 1)                          // q. user selecting file?
    {
    if (NOT sw_view &&                      // q. extracting files
                LAST(pos_parms[1]) == '\\') // ..and 2nd parm a dir name?
        {
        strcpy(output_path, pos_parms[1]);  // a. yes .. save this parm
        touppers(output_path);              // ..in uppercase form
        LAST(output_path) = 0;              // ..but nop the last backslash
        j = 2;                              // ..and start with the next
        }
     else
        j = 1;                              // else .. start with the 2nd

    sf = (SFS *) malloc_chk(                // get enough memory
        sizeof(SFS) * pos_count - j);       // ..for each selected file

    for (i = 0; j < pos_count; j++)         // for each positional parm
        {
        touppers(pos_parms[j]);             // uppercase the string
        strcpy(sf[i].path, pos_parms[j]);   // ..copy to structure
        SPLIT(sf[i]);                       // ..and split into components
        i++;                                // ..bump index
        }

    sf_count = i;                           // save select file count
    }

if (sw_exclude)                             // q. exclude mask given?
    {                                       // a. yes .. set up structure
    touppers(sw_exclude);                   // ..uppercase the string
    strcpy(ef.path, sw_exclude);            // ..copy to structure
    SPLIT(ef);                              // ..and split into components
    }

strcpy(zfn, pos_parms[0]);                  // copy zipfile to global area
touppers(zfn);                              // ..and put into uppercase

if (NOT extension_given(zfn))               // q. file extension given?
    strcat(zfn, ".ZIP");                    // a. no .. append one

if ((ifile = fopen(zfn, "rb")) == NULL)     // q. requested zip file avail?
    quit_with(no_zip_found, zfn);           // a. no .. quit w/error msg

if (*output_path && change_dir(output_path))// q. output directory available?
    {                                       // a. no .. handle error
    if (sw_dirs)                            // q. make directories?
        {                                   // a. yes .. try creating dir
        if (make_path(output_path))         // q. create directory ok?
            quit_with(dir_error);           // a. no .. quit w/err message
        }
     else
        quit_with(invalid_dir);             // else .. quit w/err message
    }

getcwd(output_path, MAX_PATH);              // get fully qualified output path

}



/* ******************************************************************** *
 *
 *  main() -- PCDEZIP mainline
 *
 * ******************************************************************** */

void    main(int argc,                      // command line token count
             char *argv[])                  // ..and command line tokens
{

printf(copyright);                          // display copyright msg
initialization(argc, argv);                 // init and parse cmd line

if (sw_view)                                // q. just want a dir listing?
    scan_zip(view_zip);                     // a. yes .. give user output
 else
    scan_zip(extract_zip);                  // else .. extract files

rc = 0;                                     // set up DOS rtn code for ok
quit_with(done);                            // ..and quit w/completion msg

}
