

/*
    GWMON Parallel Ada Monitor for 386/486 PCs   
    Copyright (C) 1993, Charles W. Kann  & Michael Bliss Feldman
                        ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ed.h"
#include "keydef.h"

#if 0
#define ROWS 10
#endif
static int ROWS = 10;
#define COLS 78
#define MAX_WINDOWS 12
static char video[4000];
static AVL_WIN_PTR  top_win, output_win;
static struct rccoord text_pos;
static int next_monitor;
static int SAVE_WIN_SIZE;

/*
   Structures for Block names for monitor windows titles.  Note that the
   Block names structure does not malloc the names.  I was afraid that
   malloc would fragment core too much with alot of funny sized pieces of
   memory.
*/

#define MAX_LEVELS 200
#define NAME_SIZE 32
static char Block_Name[MAX_LEVELS][NAME_SIZE];

#define NEWLINE 0x0a
#define ESCAPE 0x1b

void CWK_DEL_WINDOW();
static struct {
	AVL_WIN_PTR w;
	int used;
	COORD wind_coord;
	int monitor;
} window[MAX_WINDOWS];
	
static int SCROLL_LINE = 0, escape_sequence = 0;

void CWK_ERASE_ALL_MON_WIN();
void CWK_ERASE_MON_WIN();
void CWK_CLEANUP_MON();

CWK_MOVE_INPUT( fp )
FILE *fp;
{
    struct rccoord text_p;
    if ( ! isatty( fileno(fp) )) 
	return;


    text_p= _gettextposition();
    text_p.col = 1;
    text_p.row++;
    if (text_p.row >= ROWS) {
        SCROLL_LINE = 1;
	text_p.row--;
        }
    _settextposition(text_p.row, text_p.col);
}

CWK_PUTC( inchar, fp )
int inchar;
FILE *fp;
{
    struct rccoord text_p;
    static int screen_row, screen_col;
    static char next_char;
    char TextString[2];

    /*
	if this file is not a tty, write the character and continue
    */

    if ( ! isatty( fileno(fp) )) {
	fputc(inchar,fp);fflush(fp);
	return;
 	}


    /*
	Cheap kludge to handle ascii control sequences
    */

    if ( escape_sequence ) {
	switch ( next_char ) {
	   case '[' :
		if ( inchar == '[' ) {
			next_char = '1';
			return;
		}
		break;
	   case '1' :
		if ( inchar == 'J' ) {
			int i;
			char buf[80];

			escape_sequence = 0;
			sprintf(buf,"%-78s"," ");
			for(i = 1; i <= ROWS; ++i) {
				_settextposition(i, 1 );
				_outtext(buf);
			}
			_settextposition(1, 1 );
			return;
		}
		else if ( inchar == ';' ) {
			next_char = '2';
			return;
		}
		else if (isdigit( inchar )) {
			screen_row = screen_row * 10 + (inchar - '0');
			return;
		}
		break;
	    case '2' :
		if ( inchar == 'f' ) {
			escape_sequence = 0;
    			_settextposition(screen_row, screen_col);
			return;
		}
		else if ( isdigit( inchar )) {
			screen_col = screen_col * 10 + (inchar - '0');
			return;
		}
		break;
	    default:
		break;
	}
	escape_sequence = 0;
    }

    if ( inchar != ESCAPE ) {
        text_p= _gettextposition();
        if ( SCROLL_LINE ) {
            _scrolltextwindow(_GSCROLLUP);
	    SCROLL_LINE = 0;
            }
    }

    if ( inchar == ESCAPE ) {
	SCROLL_LINE = 0;
	escape_sequence = 1;
	screen_row = screen_col = 0;
	next_char = '[';
	return;
    }

    else if ( ( inchar == NEWLINE ) || ( inchar == CTRL_M ) ) {
	text_p.col = 1;
	text_p.row++;
    	if (text_p.row >= ROWS) {
            SCROLL_LINE = 1;
	    text_p.row--;
            }
        }
    else {
        sprintf( TextString, "%c", inchar );
        _outtext( TextString );
        text_p.col++;
	if (  text_p.col > COLS ) {
	    text_p.col = 1;
	    text_p.row++;
	    }
	}
    if (text_p.row >= ROWS) {
        SCROLL_LINE = 1;
	text_p.row--;
        }
    _settextposition(text_p.row, text_p.col);
}

static int CWK_MON_GET_WIN(monitor)
int monitor;
{
	int i;
	static int last_used;
	
	for (i = 0; i < Windows_Used; i++) {
	    if ( ! window[i].used ) {
		window[i].used = 1;
		window[i].monitor = monitor;
		last_used = i;
		return i;
		}
	    }
	return -1;
	
}

static void CWK_MAKE_WINDOW(title, win_no)
char *title;
int win_no;
{
	window[win_no].w = AVL_MAKE_WINDOW( title, window[win_no].wind_coord.x1,
				window[win_no].wind_coord.y1, 
				window[win_no].wind_coord.x2, 
				window[win_no].wind_coord.y2, 
				1, 15 );
}

static void CWK_SAVE_TEXT_POS()
{
	text_pos = _gettextposition();
}
	
static void CWK_RES_TEXT_POS()
{
	_settextwindow(2,2,ROWS,79);
	_settextposition(text_pos.row, text_pos.col);
}

MON_REC_PTR CWK_CREATE_MON_WIN( title, display )
char *title;
int display;
{
	CWK_SAVE_TEXT_POS();
	CWK_MONS[next_monitor].title = malloc( strlen( title ) + 1 );
	strcpy( CWK_MONS[next_monitor].title, title );
	if ( display )
	{
	    CWK_MONS[next_monitor].mon_win = CWK_MON_GET_WIN(next_monitor);
	    if (CWK_MONS[next_monitor].mon_win == -1)
	    {
		CWK_MONS[next_monitor].WON = -1;
	    }
	    else
	    {
		CWK_MONS[next_monitor].WON = 1;
		CWK_MAKE_WINDOW( title, CWK_MONS[next_monitor].mon_win );
	    }
	}
	else
	    CWK_MONS[next_monitor].WON = -1;

	CWK_RES_TEXT_POS();
	return &CWK_MONS[next_monitor++];
}

/*************************************************************************/
/*	Routines to draw the monitor windows                             */
/*************************************************************************/
void CWK_REMOVE_BLOCK ( tmp_mon )
MON_REC *tmp_mon;
{
	CWK_SAVE_TEXT_POS();

	CWK_ERASE_MON_WIN(tmp_mon);

 	Block_Level--;
 	if ( Block_Level < 0 )
 	{
		char msg[80];
        	sprintf( msg, "Internal Error, leaving too many blocks" );
		CWK_CLEANUP_MON( -1, msg );
	}
	*Block_Name[Block_Level] = '\0';
	CWK_RES_TEXT_POS();
}

void CWK_DRAW_PROC_WIN( tmp_mon, enter_or_exit )
MON_REC *tmp_mon;
int enter_or_exit;
{
	int i, First_Win_On_Screen;

	CWK_SAVE_TEXT_POS();

	if ( ! enter_or_exit )
	{
	    strcpy( Block_Name[Block_Level], tmp_mon->title );
	    Block_Level++;  
	}
	

	if ( Block_Level >= Windows_Used )
	{
	    WIN_SIZE = SAVE_WIN_SIZE - Windows_Used;
	    tmp_mon->mon_win = Windows_Used - 1;
	    First_Win_On_Screen = Block_Level - Windows_Used;
	    CWK_ERASE_ALL_MON_WIN();
	    tmp_mon->WON = 1;
	    for ( i = 0; i < Windows_Used; ++i )
	    {
		window[i].used = 1;
	        CWK_MAKE_WINDOW( Block_Name[First_Win_On_Screen+i], i );
	    }
	}
	else if ( Block_Level > 0 )
	{
	    WIN_SIZE = SAVE_WIN_SIZE - Block_Level;
	    tmp_mon->mon_win = Block_Level - 1;
	    if ( enter_or_exit )
	    	CWK_ERASE_MON_WIN(tmp_mon);
	    window[Block_Level-1].used = 1;
	    tmp_mon->WON = 1;
	    CWK_MAKE_WINDOW( Block_Name[Block_Level-1], Block_Level-1);
	}

	CWK_RES_TEXT_POS();

	/*
		Note that we have to redraw the time, otherwise it
		doesn't look right.
	*/
	CWK_REPORT_TIME(Run_Total_Time);
}

void CWK_DRAW_MON_WIN(tmp_mon)
MON_REC   *tmp_mon;
{
	CWK_SAVE_TEXT_POS();
	tmp_mon->mon_win = CWK_MON_GET_WIN(next_monitor);
	if (tmp_mon->mon_win == -1)
	{
		tmp_mon->WON = -1;
	}
	else
	{
		tmp_mon->WON = 1;
		CWK_MAKE_WINDOW( tmp_mon->title, tmp_mon->mon_win );
	}
	CWK_RES_TEXT_POS();
} 

void CWK_ERASE_ALL_MON_WIN()
{
	int i;
	CWK_SAVE_TEXT_POS();
	for (i = MAX_WINDOWS - 1; i >= 0; i--) {
	    if ( window[i].used ) {
		window[i].used = 0;
		window[i].monitor = -1;
		CWK_DEL_WINDOW(i); 
		}
	    }
	CWK_RES_TEXT_POS();
}

void CWK_ERASE_MON_WIN(tmp_mon)
MON_REC   *tmp_mon;
{
#if 0
	{
	char msg[80];
	sprintf( msg, " in erase_mon_win, name = %s, used =%d\n", 
		tmp_mon->title, window[tmp_mon->mon_win].used );
	_outtext(msg);
	getch();
	}
#endif
	if ( window[tmp_mon->mon_win].used ) 
	{
		CWK_SAVE_TEXT_POS();
		window[tmp_mon->mon_win].used = 0;
		window[tmp_mon->mon_win].monitor = -1;
		CWK_DEL_WINDOW(tmp_mon->mon_win);
		CWK_RES_TEXT_POS();
	}
}

void CWK_DEL_MON_WIN(tmp_mon)
MON_REC   *tmp_mon;
{
	CWK_SAVE_TEXT_POS();
	free( CWK_MONS[next_monitor].title );
	window[tmp_mon->mon_win].used = 0;
	tmp_mon->WON = -1;
	CWK_DEL_WINDOW(tmp_mon->mon_win);
	CWK_RES_TEXT_POS();
}

void CWK_INIT_MON()
{
	int i;
	char buf[80];

        _settextrows( 25 );
        _clearscreen( _GCLEARSCREEN );

	top_win = AVL_MAKE_WINDOW( "", 1, 1, 24, 80, 1, 15 );
	output_win = AVL_MAKE_WINDOW( " GWU ADA MONITOR - Type Ctrl h for help, ESC to leave", 1, 1, ROWS+1, 80, 1, 15 );

	/*  make the rest of the screen Blue so it looks ok  */

	_settextwindow(ROWS+2,1,24,80);
	_setbkcolor( 1 );
	_settextcolor( 15 );
	sprintf( buf, "%80.80s", " " );
	for(i = 1; i < 25 - (ROWS - 2); ++i) {
		_settextposition(i, 1 );
		_outtext(buf);
		}
	
	_settextrows(11);
	_settextwindow(2,2,ROWS,79);
	_settextposition(1,1);
	next_monitor = 0;
}

/*
*/

void CWK_CLEANUP_MON(status, msg)
int status;
char *msg;
{
	AVL_WIN_PTR w;
	int ch;

	w = AVL_MAKE_WINDOW( "", 4,15,9,76, 1, 15);
        _settextposition(1, 1);
	if ( status < 0 )
	{
        	_outtext(msg);
		ch = getch();
		AVL_DEL_WINDOW( w );
		AVL_DEL_WINDOW( top_win );
		exit(status);
	}
	else if ( status )
        	_outtext("Do you wish to Exit (y/n)");
	else
	{
        	_outtext("Execution completed");
		ch = getch();
		AVL_DEL_WINDOW( w );
		AVL_DEL_WINDOW( top_win );
		exit(status);
	}
	ch = getch();
	AVL_DEL_WINDOW( w );
	if (( ch == 'y') ||  (ch == 'Y')) {
		AVL_DEL_WINDOW( top_win );
		exit(status);
	}
}

void CWK_WRITE_LINE( MON, line, text_line )
MON_REC_PTR MON;
int line;
char *text_line;
{
	if ( MON->WON == -1 )
		return;
	CWK_SAVE_TEXT_POS();
	if ( ! MON->WON ) {
		MON->mon_win = CWK_MON_GET_WIN(next_monitor);
		if ( MON->mon_win == -1 )
			return;
	        CWK_MAKE_WINDOW( MON->title, MON->mon_win );
		MON->WON = 1;
	}

	/*
		This statement because necessary when procedure monitoring
		came in.  This is because the WON flag is not meaningful to
		the monitoring, and we don't want to use the window if it
		no longer exists.
	*/
	if ( MON->mon_win == -1 )
		return;

	_settextwindow(window[MON->mon_win].wind_coord.x1+1,
		window[MON->mon_win].wind_coord.y1+1,
		window[MON->mon_win].wind_coord.x2,
		window[MON->mon_win].wind_coord.y2);
	_settextposition(line,5);
	_outtext(text_line);
	CWK_RES_TEXT_POS();
}

void CWK_CUR_LINE( MON, line, string )
MON_REC_PTR MON;
int line;
char *string;
{
	if ( MON->WON == -1 )
		return;
	CWK_SAVE_TEXT_POS();
	if ( ! MON->WON ) {
		MON->mon_win = CWK_MON_GET_WIN(next_monitor);
		if ( MON->mon_win == -1 )
			return;
	        CWK_MAKE_WINDOW( MON->title, MON->mon_win );
		MON->WON = 1;
	}

	/*
		This statement because necessary when procedure monitoring
		came in.  This is because the WON flag is not meaningful to
		the monitoring, and we don't want to use the window if it
		no longer exists.
	*/
	if ( MON->mon_win == -1 )
		return;
	
	_settextwindow(window[MON->mon_win].wind_coord.x1+1,
		window[MON->mon_win].wind_coord.y1+1,
		window[MON->mon_win].wind_coord.x2,
		window[MON->mon_win].wind_coord.y2);
	_settextposition(line,1);
	strncpy( string, string, 3);
	_outtext(string);
	CWK_RES_TEXT_POS();
}

void CWK_DEL_WINDOW(int win_num)
{
	struct rccoord pos;
	char format[80], buf[81];
	int i;

	_settextwindow(window[win_num].wind_coord.x1, 
		window[win_num].wind_coord.y1, window[win_num].wind_coord.x2, 
		window[win_num].wind_coord.y2);

	sprintf(format,"%c-%ds",'%', ( window[win_num].wind_coord.y2 - 
		window[win_num].wind_coord.y1) + 1 );
	_setbkcolor(window[win_num].w -> bk);
	_settextcolor(window[win_num].w -> co);
	sprintf(buf,format," ");
	for(i = 1; 
		i <= (window[win_num].wind_coord.x2 -
		window[win_num].wind_coord.x1 + 1); 
		++i) {
			_settextposition(i, 1 );
			_outtext(buf);
		}
	free(window[win_num].w);
}

void print_license()
{
	AVL_WIN_PTR w;
	int ch;

	w = AVL_MAKE_WINDOW( "License", 1,4,18,76, 1, 15);
        _settextposition(1, 1);
        _outtext("GWUMON Copyright (C) 1993 Charles W. Kann  & Michael Bliss Feldman \n");
        _outtext("                          ckann@seas.gwu.edu mfeldman@seas.gwu.edu \n");
    	_outtext( "This program is free software; you can redistribute it and/or modify\n" );
    	_outtext( "it under the terms of the GNU General Public License as published by\n" );
    	_outtext( "the Free Software Foundation; either version 2 of the License, or\n" );
    	_outtext( " any later version. \n\n" );

    	_outtext( "This program is distributed in the hope that it will be useful,\n" );
    	_outtext( "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" );
    	_outtext( "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" );
    	_outtext( "GNU General Public License for more details.\n\n" );

    	_outtext( "You should have received a copy of the GNU General Public License\n" );
    	_outtext( "along with this program; if not, write to the Free Software\n" );
    	_outtext( "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n" );

	ch = getch();
	AVL_DEL_WINDOW( w );

}

/*************************************************************************
*
*	This section of code prints out any help type screens (ie. ones
*	which just give straight text in a window which is put up for
*	a single clock cycle.
*
*************************************************************************/

void print_setup_help()
{
	AVL_WIN_PTR w;
	int ch;

	w = AVL_MAKE_WINDOW( "Setup Help", 3,5,22,75, 1, 15);
        _settextposition(1, 1);
	_outtext("The following can be set from the setup Screen                     \n");
        _outtext("Delay Rate - This is the amount to delay the monitor on each clock \n");
        _outtext("             cycle. Note that a clock cycle is one pass through    \n");
        _outtext("             the interpreter.                                      \n");
        _outtext("Cycles for Reporting Exec % - If Type of Monitoring is Exec %, then\n");
        _outtext("             this tells how many cycles to run between reporting\n");
	_outtext("Delay time - If the Type of Delay is set to Scaled then this is \n");
	_outtext("             the number of clock ticks to be interpreted as     \n");
	_outtext("             1 second                                           \n");
	_outtext("RR statments - If Type of Tasking is set to Round Robin, then   \n");
	_outtext("             this is the number of cycles between task switches \n");
	_outtext("Type of Tasking - This is the task type model.  It can be set   \n");
	_outtext("             to Round Robin or Run Til Blocked                  \n");
	_outtext("Type of Delay - The type of delay can be either Real ( 1 second \n");
	_outtext("             is a real time second), or Scaled ( 1 second is    \n");
	_outtext("             some number of clock cycles                         \n");
	ch = getch();
	_outtext("Type of Monitoring - This can be either None (No monitoring is   \n");
	_outtext("             used), Line (show the lines of code as they are     \n");
	_outtext("             executed ),  or Exec % (show the execution % for    \n");
	_outtext("             each task at the interval specified above)          \n");
	_outtext("Line Trace - Turns Line Tracing on.  This stops the monitor after\n");
	_outtext("             each line on the current monitor screen is executed \n");
	_outtext("Task Trace - Turns Task Tracing on.  This stops the monitor after\n");
	_outtext("             each task switch for a task on the current monitor  \n");
	_outtext("             screen.                                             \n");
	_outtext("Type of Monitoring Window - Type of window to use  in Line       \n");
	_outtext("             Monitoring Mode.  You can show 1 - 4 tasks in       \n");
	_outtext("             4 different ways.      \n");

	ch = getch();
	AVL_DEL_WINDOW( w );
}

void print_help()
{
	AVL_WIN_PTR w;
	int ch;

	w = AVL_MAKE_WINDOW( "Help", 5,15,18,70, 1, 15);
        _settextposition(1, 1);
        _outtext("Up Arr - increase speed    Dn Arr - decrease speed\n");
        _outtext("ctrl l - line step         ctrl h - help screen\n");
        _outtext("ctrl t - task step         ctrl a - control screen\n");
        _outtext("ctrl b - stop monitoring   ctrl d - setup screen\n");
        _outtext("ctrl r - resize window \n");
        _outtext("ctrl c or ESC - stop the execution of the monitor\n\n");
        _outtext("Status Codes \n");
        _outtext("R - Wait on Rendezvous      M - Rendezvous Meet\n");
        _outtext("D - Wait on Delay           * - Task Ready to Run\n");
        _outtext("--> Task currently running ");

	ch = getch();
	AVL_DEL_WINDOW( w );
	
}

/***********************************************************************/
/*   Control Window code is contained here.                            */
/***********************************************************************/

static AVL_WIN_PTR Control_Window;
CWK_CONTROL_TASK( Schedule_Type, Task_Type, Execution_Time, Report_Time )
char *Schedule_Type, *Task_Type;
int Execution_Time, Report_Time;
{
	char msg[100];

	CWK_SAVE_TEXT_POS();
	Control_Window = AVL_MAKE_WINDOW( "Task Control -- use t to toggle task, Esc to quit", 12, 5, 24, 75, 1, 15);
        _settextposition(1, 1);
        sprintf(msg, "Scheduling : %s        Current task : %s\n",
			Schedule_Type, Task_Type );
        _outtext(msg);
        sprintf(msg, "Execution Time : %5d   Time to Report: %5d\n", 
		Execution_Time, Report_Time );
        _outtext(msg);
}

CWK_PRINT_CONTROL_LINE( iline, msg )
int iline;
char *msg;
{
	_settextposition(iline, 1);
	_outtext(msg);
	_settextposition(iline, 1);
}
CWK_DEL_CONTROL ()
{
	AVL_DEL_WINDOW( Control_Window );
	CWK_RES_TEXT_POS();
}

/***********************************************************************/
/*   Exception Reports are printed out here			       */
/***********************************************************************/

CWK_Report_Exception( task_name, msg )
char *task_name, *msg;
{
	char msg1[80];
	AVL_WIN_PTR Win;
	CWK_SAVE_TEXT_POS();
	Win = AVL_MAKE_WINDOW( "Exception Raised", 6, 1, 11, 80, 1, 15);
        _settextposition(2, 1);
	sprintf( msg1, "Exception Raised in task name %s\n", task_name );
	_outtext( msg1 );
	_outtext( msg );
	getch();
	AVL_DEL_WINDOW( Win );
	CWK_RES_TEXT_POS();
	
}

/***********************************************************************/
/*   Execution Pct Report is contained here                            */
/***********************************************************************/

CWK_REPORT_TIME( execution_time )
long execution_time;
{
	char msg[100];
	int i, start;
	static int save_step_rate;

	if (save_step_rate == step_rate )
	{
		save_step_rate = step_rate;
		return;
	}
	CWK_SAVE_TEXT_POS();
	_settextwindow(24,35,24,79);
	start = 16 - step_rate ;
        _settextposition(1, 1);
	sprintf( msg, "Speed " );
	_outtext( msg );
	for ( i = 7; i < start; ++i )
	{
        	_settextposition(1, i);
		_outtext( "=" );
	}

	for ( i = start; i <= 15; ++i )
	{
        	_settextposition(1, i);
		_outtext( "." );
	}
#if 0
        _settextposition(1, 20);
	sprintf( msg, "Cycles Exec %d", execution_time );
	_outtext( msg );
#endif
	CWK_RES_TEXT_POS();
}

/***********************************************************************/
/*   Execution Pct Window code is contained here.                      */
/***********************************************************************/

static AVL_WIN_PTR Exec_Pct_Window;
static int Exec_WON = 0;
CWK_EXEC_PCT()
{
	char msg[100];
	
	if ( Exec_WON )
		return;
	Exec_WON = 1;

	CWK_SAVE_TEXT_POS();
	Exec_Pct_Window = AVL_MAKE_WINDOW( "Exec Pct Viewer -- Use Ctrl-B to quit", 12, 1, 24, 80, 1, 15);
	_settextwindow(13,2,23,79);
        _settextposition(1, 1);
	sprintf( msg, " #  Name    St  %c   #  Name    St  %c   #  Name    St  %c   #  Name    St  %c " , '%', '%', '%', '%'); 
	_outtext( msg );
	CWK_RES_TEXT_POS();
}


CWK_EXEC_PRINT_LINE( line, msg )
int line;
char *msg;
{
	CWK_SAVE_TEXT_POS();
	_settextwindow(13,2,23,79);
        _settextposition(line, 1);
	_outtext( msg );
	CWK_RES_TEXT_POS();
}

CWK_DEL_EXEC_PCT()
{
	CWK_SAVE_TEXT_POS();
	AVL_DEL_WINDOW( Exec_Pct_Window );
	Exec_WON = 0;
	CWK_RES_TEXT_POS();
}

/***********************************************************************
*
*	This section of code initializes the monitor windows.  It puts
*	the windows on the screen, and sets up the structures so that
*	they can be used by the CUR_LINE and WRITE_LINE routines.
*
***********************************************************************/

CWK_SETUP_WINDOWS()
{
	int i; 

	for ( i = 0; i < MAX_WINDOWS; ++i) 
		window[i].used = 0;
	
	/*
		Procedure monitoring.  The windows are inset one row and
		column as the procedures continue down.
	*/
	if ( ! task_monitor )
	{
	    /*
		For procedure monitoring, set up the windows based on the
		whether the Large_Monitor (ie, the monitor is 20 lines) or
		small monitor (ie. the monitor is 13 lines) is choosen.

		Note that the SAVE_WIN_SIZE is 1 larger than the maximum
		window size.  This is because the first window has a block
		level of 1, and will thus make the WIN_SIZE =SAVE_WIN_SIZE -1
	    */
	    if ( Large_Monitor )
	    {
	        Windows_Used = 12;
		SAVE_WIN_SIZE = 19;
		ROWS = 3;
	    }
	    else
	    {
	        Windows_Used = 5;
	    	SAVE_WIN_SIZE = 12;
		ROWS = 10;
	    }
	    LINE_SIZE = 68;

	    if ( Large_Monitor )
	    {
	        for ( i = 0; i < MAX_WINDOWS; ++i) 
	        {
	        window[i].wind_coord.x1 = 5+i; window[i].wind_coord.y1 = 1;
	        window[i].wind_coord.x2 = 24; window[i].wind_coord.y2 = 80-i;
	        }
	    }
	    else
	    {
	        for ( i = 0; i < MAX_WINDOWS; ++i) 
	        {
	        window[i].wind_coord.x1 = 12+i; window[i].wind_coord.y1 = 1;
	        window[i].wind_coord.x2 = 24; window[i].wind_coord.y2 = 80-i;
	        }
	    }
	}

	/*
		Task monitoring windows.  This sets up the four types of
		task windows.  The definition of the windows is completely
	  	done here, and this should be all that is needed to change
		to change the sizes or definitions of the windows.  NOTE:
		You will have to change the MONITOR definition (ie. the
		ROWS define) if you are going to increase the size of the
		monitor windows.
	*/
	else
	{
	    switch ( monitor_window_type ) {
	    	case 0 :
		    Windows_Used = 4;
		    WIN_SIZE = 5;
		    LINE_SIZE = 28;
		    window[0].wind_coord.x1 = 12; window[0].wind_coord.y1 = 1;
		    window[0].wind_coord.x2 = 18; window[0].wind_coord.y2 = 40;
		    window[1].wind_coord.x1 = 12; window[1].wind_coord.y1 = 41;
		    window[1].wind_coord.x2 = 18; window[1].wind_coord.y2 = 80;
		    window[2].wind_coord.x1 = 18; window[2].wind_coord.y1 = 1;
		    window[2].wind_coord.x2 = 24; window[2].wind_coord.y2 = 40;
		    window[3].wind_coord.x1 = 18; window[3].wind_coord.y1 = 41;
		    window[3].wind_coord.x2 = 24; window[3].wind_coord.y2 = 80;
		    break;

	       case 1 :
		    Windows_Used = 2;
		    WIN_SIZE = 5;
		    LINE_SIZE = 68;
		    window[0].wind_coord.x1 = 12; window[0].wind_coord.y1 = 1;
		    window[0].wind_coord.x2 = 18; window[0].wind_coord.y2 = 80;
		    window[1].wind_coord.x1 = 18; window[1].wind_coord.y1 = 1;
		    window[1].wind_coord.x2 = 24; window[1].wind_coord.y2 = 80;
		    break;
	
	        case 2 :
		    Windows_Used = 2;
		    WIN_SIZE = 11;
		    LINE_SIZE = 28;
		    window[0].wind_coord.x1 = 12; window[0].wind_coord.y1 = 1;
		    window[0].wind_coord.x2 = 24; window[0].wind_coord.y2 = 40;
		    window[1].wind_coord.x1 = 12; window[1].wind_coord.y1 = 41;
		    window[1].wind_coord.x2 = 24; window[1].wind_coord.y2 = 80;
		    break;

	        case 3 :
		    Windows_Used = 1;
		    WIN_SIZE = 11;
		    LINE_SIZE = 68;
		    window[0].wind_coord.x1 = 12; window[0].wind_coord.y1 = 1;
		    window[0].wind_coord.x2 = 24; window[0].wind_coord.y2 = 80;
		    break;

	        default :
		    printf( "invalid use of monitor window types\n" );
		    break;
	    }
	}
}

/*
*	This routine resizes the windows.  It takes space from the output 
*	window to be used by the monitor windows.  It reallocates the space,
*	and then clears the output window (since I don't know what is in
*	it).
*/

CWK_Resize_Window()
{
	CWK_ERASE_ALL_MON_WIN();
	AVL_DEL_WINDOW( output_win );
	CWK_SETUP_WINDOWS();
	output_win = AVL_MAKE_WINDOW( " GWU ADA MONITOR - Type Ctrl h for help, ESC to leave", 1, 1, ROWS+1, 80, 1, 15 );

}

