WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Weekly_Pay IS

  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
 
  Tax : CONSTANT NonNegFloat = 25.0;
  Hours : NonNegFloat;
  Rate  : NonNegFloat;
  Gross : NonNegFloat;
 
BEGIN -- Weekly_Pay

  Ada.Text_IO.Put (Item => "Enter hours worked > ");
  Ada.Float_Text_IO.Get (Item => Hours);
  Ada.Text_IO.New_Line
  Ada.Text_IO.Put (Item => "Enter hourly rate > ");
  Ada.Float_Text_IO.Get (Item => Rate);   
  Ada.Text_IO.New_Line;
 
  Gross := Hours * Rate;
  Net := Gross - Tax;
   
  Ada.Text_IO.Put (Item => "Gross pay is $ ");
  Ada.Float_Text_IO.Put (Item => Gross, Fore => 6, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;
   
  Ada.Text_IO.Put (Item => "Net pay is   $ ");
  Ada.Float_Text_IO.Put (Item => Net, Fore => 6, Aft => 2, Exp => 0);
  Ada.Text_IO.New_Line;

END Weekly_Pay;
