WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Sum_Items IS
------------------------------------------------------------------
--| Finds and displays the sum of a list of data items.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  NumValues :    Natural;      -- input - the number of items to be added   
  CurrentValue : Integer;      -- input - the next data item to be added   
  Sum :          Integer;      -- output - the sum being accumulated   

BEGIN  -- Sum_Items   

  -- Read the number of items to be summed   
  Ada.Text_IO.Put(Item => "Enter number of integer items to be summed > ");
  Ada.Integer_Text_IO.Get(Item => NumValues);  
  Ada.Text_IO.New_Line;

  -- Read each data item and add it to Sum   
  Sum := 0;
  FOR Count IN 1 .. NumValues LOOP
    Ada.Text_IO.Put(Item => "Integer item no. ");
    Ada.Integer_Text_IO.Put(Item => Count, Width => 1);
    Ada.Text_IO.Put(Item => " to be summed > ");
    Ada.Integer_Text_IO.Get(Item => CurrentValue);  
    Sum := Sum + CurrentValue;
  END LOOP;

  -- Print the sum   
  Ada.Text_IO.Put(Item => "The Sum is ");
  Ada.Integer_Text_IO.Put(Item => Sum, Width => 1);  
  Ada.Text_IO.New_Line;

END Sum_Items;
