WITH Dates; USE Dates;
PACKAGE Persons IS
------------------------------------------------------------------
--| Specification for Persons. This package provides a root type
--| Person, with the fields Name, Gender, and BirthDate. Person
--| is a tagged private type, which means that it has all the
--| characteristics of an ordinary private type but also that it
--| can be extended by derivation.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: November 1995                                     
------------------------------------------------------------------
  
  TYPE Genders IS (Female, Male);
  
  SUBTYPE NameRange IS Positive RANGE 1..20;
  SUBTYPE NameType  IS String(NameRange); 

  TYPE Person IS TAGGED PRIVATE;
   
  -- selectors
  
  FUNCTION NameOf  (Whom: Person) RETURN NameType; 
  FUNCTION GenderOf(Whom: Person) RETURN Genders;
  FUNCTION DOBOf   (Whom: Person) RETURN Date;
  -- Pre:  Whom is defined
  -- Post: returns the appropriate field value
  
  PROCEDURE Put(Item: IN Person);
  -- Pre:  Item is defined
  -- Post: Item's fields are displayed
  
  PACKAGE Constructors IS
    
    -- this inner package is necessary so that MakePerson is not a
    -- "primitive" function, that is, so that it is not inherited
    -- by types derived from Person.
    
    FUNCTION MakePerson(Name     : String;
                        Gender   : Genders; 
                        BirthDate: Date) RETURN Person;
    -- Pre:  Name, Gender, and BirthDate are defined
    -- Post: returns a Person with the given field values
    
  END Constructors;  
  
PRIVATE
  
  TYPE Person IS TAGGED RECORD
    NameLength: NameRange := 1;
    NameField : NameType := (OTHERS => ' ');
    Gender    : Genders := Female;
    BirthDate : Date;
  END RECORD;

END Persons;
