WITH Ada.Text_IO;
PROCEDURE Cryptogram IS
------------------------------------------------------------------
--| Program to generate a cryptogram
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: November 1995                                     
------------------------------------------------------------------

  SUBTYPE Letter IS Character RANGE 'A'..'Z';
  TYPE CodeArray IS ARRAY (Letter) OF Character;

  SUBTYPE Message IS String(1..60);

  Code      : CodeArray;          -- input - array of code symbols
  PlainText : Message;            -- input - plain text message
  CodedText : Message;            -- output - coded message

  HowLong   : Natural;   

  FUNCTION Cap (InChar : Character) RETURN Character IS
  -- Pre: InChar is defined
  -- Post: if InChar is a lower-case letter, returns its upper-case
  --   equivalent; otherwise, returns InChar unmodified

  BEGIN -- Cap

    IF InChar IN 'a'..'z' THEN
      RETURN Character'Val(Character'Pos(InChar)
            - Character'Pos('a') + Character'Pos('A'));
    ELSE
      RETURN InChar;
    END IF;

  END Cap;
    
BEGIN -- Cryptogram   

  Ada.Text_IO.Put(Item => "Enter a code symbol under each letter.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "ABCDEFGHIJKLMNOPQRSTUVWXYZ");  
  Ada.Text_IO.New_Line;

  -- Read each code symbol into array Code.   
  FOR NextLetter IN Letter LOOP
    Ada.Text_IO.Get(Item => Code(NextLetter));
  END LOOP;
  Ada.Text_IO.Skip_Line;

  -- Read plain text message
  Ada.Text_IO.Put(Item => "Enter each character of your message.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "No more than 60 characters, please.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "Press RETURN after your message.");
  Ada.Text_IO.New_Line;

  -- Display scale so user knows how many characters
  Ada.Text_IO.Put(Item => "         1         2         3" &
                          "         4         5         6");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "123456789012345678901234567890" &
                          "123456789012345678901234567890");
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Get_Line (Item => PlainText, Last => HowLong);

  -- Encode message by table lookup
  FOR WhichChar IN 1..HowLong LOOP
    IF Cap(PlainText(WhichChar)) IN Letter THEN
      CodedText(WhichChar) := Code(Cap(PlainText(WhichChar)));
    ELSE
      CodedText(WhichChar) := PlainText(WhichChar);
    END IF;
  END LOOP;
  
  -- Display coded message
  Ada.Text_IO.Put (Item => CodedText(1..HowLong));
  Ada.Text_IO.New_Line;

END Cryptogram;
