with Unchecked_Deallocation;

generic

type Item is private;

package Stk is
	type Stack is private;
	procedure Make_Empty(S : in out Stack);
	function Is_Empty(S : Stack) return Boolean;
	procedure Push(S : in out Stack; E : Item);
	procedure Pop(S : in out Stack);
	function Top(S : Stack) return Item;
	Stack_Full  : exception;
	Stack_Empty : exception;
private
	type Node;
	type Node_Link is access Node;
	type Node is record
		Value    : Item;
		Previous : Node_Link;
		end record;
	type Stack is record
		Last : Node_Link := null;
		end record;
end Stk;

package body Stk is
	Temp : Node_Link := null;
	-- Non portable ; Instantiate Unchecked_Deallocation
	procedure Free(Ptr : in out Node_Link) is
	begin
		Ptr := null;
	end Free;

	procedure Make_Empty(S : in out Stack) is
	begin
		-- First release memory
		while S.Last /= null loop
			Temp := S.Last;
			S.Last := Temp.Previous;
			Free(Temp);
			end loop;
	end Make_Empty;

	function Is_Empty(S : Stack) return Boolean is
	begin
		return S.Last = null;
	end Is_Empty;

	procedure Push(S : in out Stack; E : Item) is
	begin
		Temp := New Node;
		if Temp = null then
			raise Stack_Full;
		end if;
		Temp.Previous := S.Last;
		Temp.Value := E;
		S.Last := Temp;
	end Push;

	procedure Pop(S : in out Stack) is
	begin
		if S.Last = null then
			raise Stack_Empty;
		end if;
		Temp := S.Last;
		S.Last := Temp.Previous;
		Free(Temp);
	end Pop;

	function Top(S : Stack) return Item is
	begin
		if S.Last = null then
			raise Stack_Empty;
		end if;
		return S.Last.Value;
	end Top;
begin
	-- Nothing to do here!
	null;
end Stk;

-- To instantiate the package use:
-- PACKAGE My_Stack is NEW($); USE My_Stack;
