#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__getfont = "$Header: C:\CURSES\private\RCS\_getfont.c 2.1 1993/06/18 20:22:30 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_get_font()	- Get the current font size

  PDCurses Description:
 	This is a private PDCurses routine.

 	This function returns the current font size.  This function only
 	works if the #define FAST_VIDEO is true.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	An ERR will be returned if FAST_VIDEO is not true.

  Portability:
 	PDCurses	int PDC_get_font( void );

**man-end**********************************************************************/

int	PDC_get_font(void)
{
#if	defined (DOS) && defined (FAST_VIDEO)
	int	retval;
#endif

#ifdef OS2
	VIOMODEINFO modeInfo;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_font() - called\n");
#endif

#if	defined (DOS) && defined (FAST_VIDEO)
	retval = getdosmemword (0x485);
	if ((retval == 0) && (_cursvar.adapter == _MDS_GENIUS))
	{
		retval = _FONT15; /* Assume the MDS Genius is in 66 line mode. */
	}
	switch (_cursvar.adapter)
	{
	case _MDA:
			retval = 10; /* POINTS is not certain on MDA/Hercules */
			break;
	case _EGACOLOR:
	case _EGAMONO:
		switch (retval)
		{
		case _FONT8:
		case _FONT14:
			break;
		default:
			retval = _FONT14;
		}
		break;

	case _VGACOLOR:
	case _VGAMONO:
		switch (retval)
		{
		case _FONT8:
		case _FONT14:
		case _FONT16:
			break;
		default:
			break;
		}
		break;
	default:
		break;
	}
	return( retval );
#endif

#ifdef OS2
	modeInfo.cb = sizeof(modeInfo);
        /* set most parameters of modeInfo */
	VioGetMode(&modeInfo, 0);
        return ( modeInfo.vres / modeInfo.row);
#endif

#ifdef UNIX
	return(0); /* this is N/A */
#endif
}
