#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	typeahead

#ifdef PDCDEBUG
char *rcsid_typeahea = "$Header: C:\CURSES\portable\RCS\typeahea.c 2.1 1993/06/18 20:19:35 MH Rel MH $";
#endif


/*man-start*********************************************************************

  typeahead()	- check for type-ahead

  X/Open Description:
 	The curses package does the "line-breakout optimisation" by
 	looking for type-ahead periodically while updating the screen.
 	If input is found, the current update will be postponed until
 	refresh() or doupdate() are called again.  This allows faster
 	response to commands typed in advance.  Normally, the input FILE
 	pointer passed to newterm(), or stdin in the case when initscr()
 	was called, will be used to do this type-ahead checking.  The
 	typeahead() routine specified that the file descriptor fd is to
 	be used to check for type-ahead instead.  If fd is -1, then no
 	type-ahead checking will be done.

  PDCurses Description:
 	Previous version of this function have been incorrect. 
 	Version 2.1 corrected the inconsistancy.

  X/Open Return Value:
 	The typeahead() routine returns the value of the previous file
 	descriptor.

  Portability:
 	PDCurses	int typeahead( int fd );
 	SysV Curses	
 	BSD Curses	
 	X/Open Dec '88	int typeahead( int fd );

**man-end**********************************************************************/

int	typeahead( int fd )
{
 static int saved_fd;
 int old_fd;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("typeahead() - called\n");
#endif

	old_fd = saved_fd;
	saved_fd = fd;
	if (fd == (-1))
		_cursvar.refrbrk = FALSE;
	else
		_cursvar.refrbrk = TRUE;
	return(old_fd);
}
