#include <limits.h>
#define CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef baudrate

#ifdef PDCDEBUG
char *rcsid_baudrate = "$Header: C:\CURSES\portable\RCS\baudrate.c 2.1 1993/06/18 20:19:31 MH Rel MH $";
#endif




/*man-start*********************************************************************

  baudrate()	- Return terminal baud rate

  X/Open Description:
 	Returns the output speed of the terminal.  The number returned
 	is bits per second, for example 9600, and is an integer.

  PDCurses Description:
 	If FAST_VIDEO is true, then this is the largest possible
 	(portable) int value (INT_MAX from limits.h) IF direct
 	video is possible, OR the approximate guess at BIOS speeds,
 	19200.

 	If FAST_VIDEO is false, this is an approximate guess at BIOS
 	speeds, 19200.

  X/Open Return Value:
 	The baudrate() function returns a pointer to a verbose description
 	of the current terminal on success and the null pointer on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses		int baudrate( void );
 	X/Open Dec '88		int baudrate( void );
 	BSD Curses
 	SYS V Curses

**man-end**********************************************************************/

int	baudrate(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("baudrate() - called\n");
#endif

#ifdef UNIX
	return (_CUR_TERM.baudrate);
#else
#ifdef FAST_VIDEO
	return (_cursvar.direct_video ? INT_MAX : 19200 );
#else
	return (19200);			/* Approx. guess at BIOS speeds.*/
#endif
#endif
}
