extproc gawk -f

#!/bin/sh
#FILE=${1-/dev/null}
#awk '

BEGIN {
	node = "";
	seq = -1;
	count = 0;
	file = "NONE";
}
/^@node / {
	if (seq > 0)
		printf(" --  %d file%s", seq, seq == 1 ? "" : "s");
	if (seq >= 0)
		printf("\n");

	split($0, tmp, ",");
	node = substr(tmp[1], 7);
	if (length(node) > 11)
		printf("Node: %s (truncating)", node);
	else
		printf("Node: %s ", node);
	gsub(" ", "_", node);
	node = tolower(substr(node, 1, 11));
	seq = 0;
}

/^@comment ignore$/ {
	getline;
	next;
}

/^@example$/, /^@end example$/ {
	if (seq < 0)
		next;
	if ($0 ~ /^@example$/) {
		seq++;
		count++;
		file = sprintf("examples/%02d.%s", count, node);
		printf("dnl \"%s\": %d: Origin here\n", FILENAME, NR) > file;
		next;
	}
	if ($0 ~ /^@end example$/) {
		next;
	}
	if ($0 ~ /^\^D$/)
		next;
	if ($0 ~ /^@result{}/ || $0 ~ /^@error{}/)
		prefix = "dnl ";
	else
		prefix = "";
	gsub("@@", "@", $0);
	printf("%s%s\n", prefix, $0) >> file;
}

END {
	printf("\n");
}

#' $FILE
