/* access extended mode bits */

#define INCL_NOPM
#include <os2.h>
#include <string.h>

int getfmode(char *name)
{
  USHORT mode;
  return DosQFileMode(name, &mode, 0L) ? -1 : mode;
}


int setfmode(char *name, unsigned mode)
{
  return DosSetFileMode(name, mode, 0L) ? -1 : 0;
}


char *modestring(unsigned mode)
{
  static char buf[5];

  strcpy(buf, "---");
  if ( mode & FILE_ARCHIVED )
    buf[0] = 'a';
  if ( mode & FILE_HIDDEN )
    buf[1] = 'h';
  if ( mode & FILE_SYSTEM )
    buf[2] = 's';
  
  return buf;
}
