NAME
     ls, dir, vdir - list contents of directories

SYNOPSIS
     ls [-abcdgiklmnpqrstuxABCFLNQRSUX1] [-w cols] [-T cols] [-I
     pattern] [+all] [+escape] [+directory] [+inode] [+kilobytes]
     [+numeric-uid-gid] [+hide-control-chars] [+reverse] [+size]
     [+width=cols] [+tabsize=cols] [+almost-all] [+ignore-
     backups] [+classify] [+file-type] [+ignore=pattern]
     [+dereference] [+literal] [+quote-name] [+recursive]
     [+sort={none,time,size,extension}]
     [+format={long,verbose,commas,across,vertical,single-
     column}] [+time={atime,access,use,ctime,status}] [path...]

DESCRIPTION
     This manual page documents the GNU version of ls.  dir and
     vdir are versions of ls with different default output for-
     mats.  These programs list each given file or directory
     path.  Directory contents are sorted alphabetically.  For
     ls, files are by default listed in columns, sorted verti-
     cally, if the standard output is a terminal; otherwise they
     are listed one per line.  For dir, files are by default
     listed in columns, sorted vertically.  For vdir, files are
     by default listed in long format.

     OPTIONS

     -a, +all
          List all files in directories, including all files that
          start with `.'.

     -b, +escape
          Quote nongraphic characters in file names using alpha-
          betic and octal backslash sequences like those used in
          C.

     -c, +time=ctime, +time=status
          Sort directory contents according to the files' status
          change time instead of the modification time.  If the
          long listing format is being used, print the status
          change time instead of the modification time.

     -d, +directory
          List directories like other files, rather than listing
          their contents.

     -g   Ignored; for Unix compatibility.

     -i, +inode
          Print the index number of each file to the left of the
          file name.

     -k, +kilobytes
          If file sizes are being listed, print them in kilobytes
          instead of in 512-byte blocks.

     -l, +format=long, +format=verbose
          In addition to the name of each file, print the file
          type, permissions, number of hard links, owner name,
          group name, size in bytes, and timestamp (the modifica-
          tion time unless other times are selected).

     -m, +format=commas
          List files horizontally, with as many as will fit on
          each line, separated by commas.

     -n, +numeric-uid-gid
          List the numeric UID and GID instead of the names.

     -p   Append a character to each file name indicating the
          file type.

     -q, +hide-control-chars
          Print question marks instead of nongraphic characters
          in file names.

     -r, +reverse
          Sort directory contents in reverse order.

     -s, +size
          Print the size of each file in 512-byte blocks to the
          left of the file name.

     -t, +sort=time
          Sort directory contents by timestamp instead of alpha-
          betically, with the newest files listed first.

     -u, +time=atime, +time=access, +time=use
          Sort directory contents according to the files' last
          access time instead of the modification time.  If the
          long listing format is being used, print the last
          access time instead of the modification time.

     -x, +format=across, +format=horizontal
          List the files in columns, sorted horizontally.

     -A, +almost-all
          List all files in directories except for `.' and `..'.

     -B, +ignore-backups
          Do not list files that end with `~', unless they are
          given on the command line.

     -C, +format=vertical
          List files in columns, sorted vertically.

     -F, +classify
          Append a character to each file name indicating the
          file type.  For regular files that are executable,
          append a `*'.  The file type indicators are `/' for
          directories, `@' for symbolic links, `|' for FIFOs, `='
          for sockets, and nothing for regular files.

     -L, +dereference
          List the files linked to by symbolic links instead of
          listing the contents of the links.

     -N, +literal
          Do not quote file names.

     -Q, +quote-name
          Enclose file names in double quotes and quote non-
          graphic characters as in C.

     -R, +recursive
          List the contents of all directories recursively.

     -S, +sort=size
          Sort directory contents by file size instead of alapha-
          betically, with the largest files listed first.

     -U, +sort=none
          Do not sort directory contennts.

     -X, +sort=extension
          Sort directory contents alphabetically by file exten-
          sion (characters after the last `.'); files with no
          extension are sorted first.

     -1, +format=single-column
          List one file per line.

     -w, +width cols
          Assume the screen is cols columns wide.  The default is
          taken from the terminal driver if possible; otherwise
          the environment variable COLUMNS is used if it is set;
          otherwise the default is 80.

     -T, +tabsize cols
          Assume that each tabstop is cols columns wide.  The
          default is 8.

     -I, +ignore pattern
          Do not list files whose names match the shell pattern
          pattern unless they are given on the command line.  As
          in the shell, an initial `.' in a filename does not
          match a wildcard at the start of pattern.
