#!/bin/sh

PREFIX=/usr/local

# Caution, this script is originally from 
#	http://dis.cs.umass.edu/stats/script.html
# More Info see http://dis.cs.umass.edu/stats/fly.html
#
# I modified it for use with gwstat port 
# in the FreeBSD ports collection
#
# 	- Andreas Klemm <andreas@FreeBSD.ORG>

# where to seach 'gs' and other commands
PATH=${PREFIX}/bin:${PREFIX}/sbin:/bin:/usr/bin:/sbin:/usr/sbin
export PATH

# $oldresult is the stats up to the beginning of the month
# this file is used as the base to compute $wwwresult
# and is updated at the beginning of each month

if [ -f ${PREFIX}/www/data/stats/oldwwwstats.html ]; then
	# ok, file is present
else
	# if we start the show the first time, then an empty
	# file has to be created, otherwise wwwstat would hang
	touch ${PREFIX}/www/data/stats/oldwwwstats.html
fi

oldresult=${PREFIX}/www/data/stats/oldwwwstats.html


# $wwwresult is updated every hour
# will use $oldresult as the base

wwwresult=${PREFIX}/www/data/stats/wwwstats.html

# the day of today
day="`/bin/date +'%d'`"
time="`/bin/date +'%H'`"

# 
pidfile=/var/run/httpd.pid
access=/var/log/httpd-access.log
error=/var/log/httpd-error.log

# backup files to store all the accesses
oldaccess=${PREFIX}/www/data/stats/access_archive
olderror=${PREFIX}/www/data/stats/error_archive

# stop httpd first if it is at the beginning of the month, then
# append log files to the corresponding backup files

if  [ "$day" -eq 1 -a "$time" -eq 0 ]; then
	/bin/kill -9 `/bin/cat $pidfile`
	/bin/cat $access  >>$oldaccess	
	/bin/cat $error >>$olderror
fi

# get the current $wwwresult incrementally from the $oldresult
wwwstat $oldresult $access>/tmp/wwwstats.html
mv -f /tmp/wwwstats.html $wwwresult


# if it is at the beginning of the month, use the current $wwwresult
# to update $oldresult,  delete $access, $error (since they have been
# appended to the backup files) , restart httpd

if [ "$day" -eq 1 -a  "$time" -eq 0 ]; then
	cp $wwwresult $oldresult
	cp /tmp/htmls.html $oldhtmls
	rm -f $access $error
	httpd
fi

# use the current wwwstat file to generat all the gifs
gwstat -R recent -b blue -f yellow
gwstat -D daily -b RosyBrown -f brown -o RosyBrown
gwstat -H hourly -b gray -f brown -o brown
gwstat -W weekly -b turquoise -f DarkViolet
gwstat -M monthly -b gray -f blue
gwstat -Y yearly -f "red blue"
gwstat -C country -n 
gwstat -n -A archive -b blue -f white -o blue 

### compose (from ImageMagick) the chip files into stats.gif (for imagemap)
### 
all=/tmp/all.gif

cd ${PREFIX}/www/data/stats

combine +display -geometry +32+97 -size 100x100 \
	-compose replace archive-chip.gif base.gif $all

combine +display -geometry +196+97 -size 100x100 \
	-compose replace country-chip.gif $all $all

combine +display -geometry +360+97 -size 100x100 \
	-compose replace hourly-chip.gif  $all $all

combine +display -geometry +32+281 -size 100x100 \
	-compose replace daily-chip.gif  $all $all

combine +display -geometry +196+281 -size 100x100 \
	-compose replace weekly-chip.gif $all $all

combine +display -geometry +360+281 -size 100x100 \
	-compose replace monthly-chip.gif $all $all

combine +display -geometry +32+465 -size 100x100 \
	-compose replace yearly-chip.gif $all $all

combine +display -geometry +196+465 -size 100x100 \
	-compose replace recent-chip.gif $all $all

mv $all stats.gif

exit 0
