#!/bin/sh
# tgif configuration shell script
# usage: /bin/sh setup 

if [ X"${BATCH:-no}" = X"no" ] ; then
/usr/bin/dialog --title "Tgif port setup for Kanji code selection" --radiolist \
"You can select EUC kanji code (Default) or JIS kanji code. \n \
EUC kanji code is compatible to former Tgif ports. \n \
Recently there are many printers which do not understand \n \
EUC encoded PS files correctly.  In that case choose JIS." -1 -1 2 \
"EUC" "EUC-JP mode" ON \
"JIS" "JIS mode" OFF 2>/tmp/TGIF.kanji.selection

if [ X`cat /tmp/TGIF.kanji.selection` = "XJIS" ]
	then
	 echo 'JIS is selected'
	 echo 'Remember to change X resources entry for TgifNihongoFonts'
	 echo 'If you have already set'
	 ${GZCAT} ${DISTDIR}/tgif-3.0J0.12-p13-PSJISr1.gz | \
		${PATCH} ${PATCH_DIST_ARGS}
	else
 	 echo 'EUC-JP mode (default) is selected'
	fi
fi
rm -f /tmp/TGIF.kanji.selection
