
;
;                          SERIAL SPY
;
;
;   TSR to display the current modem input and output states of 
;   a specific port. 
;
;   (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:tsrstk
    
;
; This is the resident handler than monitors the current state
;   of the specified serial port

int_1Ch_hook    proc    far
        pushf

        push    ax
        push    cx
        push    dx
        push    di
        push    si
        push    es

; check if scroll lock on

        mov     ax, 40h            ; BIOS data area
        mov     es, ax
        test    byte ptr es:[17h], 10h   ; Scroll lock on ?
        jz      int_1Ch_exit       ; exit if not

        mov     dx, cs:[serv_port] ; get serial I/O port 
        add     dx, 6              ; modem status register
        cli                        ; disable interrupts
        in      al, dx             ; get status
        IODELAY
        out     dx, al             ; restore to prior value
        sti                        ; enable interrupts
        mov     ah, al             ; save modem status
        and     ah, 0F0h           ; only keep upper bits
        sub     dx, 2              ; modem control register
        in      al, dx             ; get modem control bits
        and     al, 3              ; only keep DTR and RTS
        shl     al, 1
        shl     al, 1              ; shift left
        or      ah, al             ; insert with other bits
        mov     si, offset status
        mov     es, cs:[crt_seg]
        mov     di, 76             ; column 38
        xor     cx, cx

; Display status directly on video display - This routine is a 
;  little odd.  All characters other that upper case are 
;  displayed as color_x.  When the first of three upper case 
;  letters are encountered, CX is set to 3, and the three 
;  characters are output with the color dependent on the state 
;  of bit 7 in AH (where we saved the modem bits). After three 
;  characters are output, AH is rotated left so bit 7 has the 
;  next bit state to use.

display_loop:
        mov     al, cs:[si]
        stosb                      ; store char at es:[di]
        mov     al, cs:[color_x]   ; assume color non-bit 
        test    byte ptr cs:[si], 20h  ; upper case ?
        jnz     color_set          ; jump if not
        cmp     cx, 0
        jne     not_begin_bit
        mov     cx, 3              ; 3 characters for each bit
not_begin_bit:
        mov     al, cs:[color_1]   ; assume "1"
        test    ah, 80h            ; test top bit, modem status
        jnz     color_set
        mov     al, cs:[color_0]
color_set:
        stosb                      ; store attribute at es:[di]
        inc     si
        jcxz    no_rotate_bit      ; skip if non-bit characters
        loop    display_loop       ; output characters for bit
        rol     ah, 1              ; rotate for next bit check
no_rotate_bit:
        cmp     di, 160            ; done ?
        jb      display_loop

int_1Ch_exit:
        pop     es
        pop     si
        pop     di
        pop     dx
        pop     cx
        pop     ax
        popf
        jmp     cs:[old_int_1Ch]   ; process old int_1Ch
        
int_1Ch_hook    endp

old_int_1Ch dd  0                  ; old pointer saved here

status      db  ' port '
status_port db        '1 in: DCD RIN DSR CTS  out: RTS DTR '

serv_number db  0                  ; serial port #
serv_port   dw  0                  ; serial I/O port address

crt_seg     dw  0B800h             ; default display segment
color_1     db  1Ah                ; default green on blue "1"
color_0     db  41h                ; default blue  on red  "0"
color_x     db  17h                ; default white on blue


;===============================================================
; Start of non-resident installation portion

sspy    proc    far

start:
        push    cs
        pop     ds
        mov     al, es:[82h]       ; get command line option
        mov     [msg1a], al        ; save
        mov     [status_port], al  ; save 
        sub     al, 31h
        cmp     al, 4
        ja      serv_error         ; out of range
        mov     [serv_number], al  ; save
        shl     al, 1              ; * 2
        xor     ah, ah
        mov     di, ax
        mov     ax, 40h            ; BIOS data area
        mov     es, ax
        mov     ax, es:[di]        ; get port addres
        cmp     ax, 0              ; valid port ?
        je      serv_error         ; jump if not
        mov     [serv_port], ax    ; save

; find display segment

        cmp     byte ptr es:[49h], 7  ; monochrome ?
        jne     serv_skip1
        mov     [crt_seg], 0B000h  ; color segment
        mov     [color_0], 70h     ; bit 0, inverse
        mov     [color_1], 0Fh     ; bit 1, bright
        mov     [color_x], 07h     ; text, normal
serv_skip1:

; get the current interrupt 1Ch vector (timer) and save
        
        mov     al, 1Ch       
        mov     ah, 35h
        int     21h                ; get current int 1Ch pointer
        mov     word ptr old_int_1Ch, bx
        mov     word ptr old_int_1Ch+2, es

; install our new interrupt 1Ch routine

        mov     dx, offset int_1Ch_hook
        mov     al, 1Ch
        mov     ah, 25h
        int     21h                ; install our interrupt 

        OUTMSG  msg1               ; output installed message

; now determine the size to remain resident (paragraphs) 
;   and become a TSR

        mov     dx, (offset start - offset int_1Ch_hook) SHR 4
        add     dx, 11h            ; add PSP size + 1 paragraph
        mov     ax, 3100h          ; exit to DOS as tsr 
        int     21h

serv_error:
        OUTMSG  msgerr             ; output error message
        mov     ah, 4Ch
        int     21h                ; return to DOS, no TSR
sspy    endp

msg1    db  CR, LF
        db  ''
        db  CR, LF
        db  '   SSPY installed - Serial Port '
msg1a   db  '  Monitor', CR, LF
        db  '  Active when Scroll-Lock on.  (c)1994 FVG', CR, LF
        db  '  ', CR, LF
        db  '  Display: Inverted=0, Normal=1           ', CR, LF
        db  '                                       Pin', CR, LF
        db  '  Input:   DCD - Data Carrier Detect     8', CR, LF
        db  '           RIN - Ring Indicator         22', CR, LF
        db  '           DSR - Data Set Ready          6', CR, LF
        db  '           CTS - Clear To Send           5', CR, LF
        db  '  Output:  RTS - Request To Send         4', CR, LF
        db  '           DTR - Data Terminal Ready    20', CR, LF
        db  ''
        db  CR, LF, '$'

msgerr  db      CR, LF
        db      'SSPY - Must indicate a valid serial port '
        db      '1 to 4 on command line.', CR, LF, '$'

cseg    ends

;==================================================== stack ====

tsrstk  segment para stack
        db      150 dup (0)
tsrstk  ends
        end     start


