
;
;                          CTRL2CAP
;
;
;   TSR to swap the functions of the Ctrl and CapsLock keys.
;   System scan code for Ctrl = 1Dh, and for Caps Lock = 3Ah
;
;   For all AT and later computers (not for PC/XT).
;
;   (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc


cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:tsrstk

; 
; This is the resident handler to detect if CAPS or CTRL pressed
;   and swaps the system scan codes if so.

int_15h_hook    proc    far
        pushf
        cmp     ah, 4Fh            ; interrupt 9 key function ?
        jne     skip_change        ; jump if not

        cmp     al, 3Ah            ; caps make ?
        je      caps_make          ; jump if so
        cmp     al, 0BAh           ; caps release ?
        je      caps_release       ; jump if so

        cmp     al, 1Dh            ; ctrl make ?
        je      ctrl_make          ; jump so
        cmp     al, 9Dh            ; ctrl release ?
        je      ctrl_release       ; jump if so
        jmp     skip_change

caps_make:
        mov     al, 1Dh            ; switch to ctrl make
        jmp     finish_int15
caps_release:
        mov     al, 9Dh            ; switch to ctrl release
        jmp     finish_int15
ctrl_make:
        mov     al, 3Ah            ; switch to caps make
        jmp     finish_int15
ctrl_release:
        mov     al, 0BAh           ; switch to caps release

finish_int15:
skip_change:
        popf
        jmp     cs:old_int_15h     ; process old int_15h

int_15h_hook    endp

old_int_15h     dd      0          ; old pointer saved here


;===============================================================
; Start of nonresident installation portion

ctrl2cap        proc    far

start:
        push    cs
        pop     ds

; get the current interrupt 15h vector and save

        mov     al, 15h
        mov     ah, 35h
        int     21h                ; get current int 15h pointer
        mov     word ptr old_int_15h, bx
        mov     word ptr old_int_15h+2, es

; install our new interrupt 15h routine

        mov     dx, offset int_15h_hook
        mov     al, 15h
        mov     ah, 25h
        int     21h                ; install our interrupt

        OUTMSG  installmsg         ; display installed message

; now determine the size to remain resident (paragraphs)
;   and become a TSR

        mov     dx, (offset start - offset int_15h_hook) SHR 4
        add     dx, 11h            ; add PSP size + 1 paragraph
        mov     ax, 3100h          ; exit to DOS as tsr
        int     21h
ctrl2cap        endp


installmsg db   CR, LF
        db      'CTRL2CAP TSR Installed'
        db      ' - Ctrl key swapped with Caps-Lock'
        db      CR, LF, '$'

cseg    ends


;==================================================== stack ====

tsrstk  segment para stack

        db      150 dup (0)

tsrstk  ends

        end     start

