{**********************************************************************}
{*                              D V I P                               *}
{*--------------------------------------------------------------------*}
{*    Task           : Demonstrates direct access to video RAM from   *}
{*                     Turbo Pascal                                   *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    Developed on   : 10/02/1987                                     *}
{*    Last update    : 06/20/1989                                     *}
{**********************************************************************}

program DVIP;

Uses Crt, Dos;                                 { Use CRT and DOS units }

const NORMAL        = $07;            { Define character attributes in }
      LIGHT         = $0f;            { conjunction with monochrome    }
      INVERSE       = $70;            { video card                     }
      UNDERSCORED   = $01;
      BLINKING      = $80;

      BLACK         = $00;           { Color attributes for color card }
      BLUE          = $01;
      GREEN         = $02;
      COBALTBLUE    = $03;
      RED           = $04;
      VIOLET        = $05;
      BROWN         = $06;
      LIGHTGRAY     = $07;
      DARKGRAY      = $01;
      LIGHTBLUE     = $09;
      LIGHTGREEN    = $0A;
      LIGHTCOBALT   = $0B;
      LIGHTRED      = $0C;
      LIGHTVIOLET   = $0D;
      YELLOW        = $0E;
      WHITE         = $0F;

type TextTyp = string[80];

var VSeg : word;                        { Segment address of video RAM }

{**********************************************************************}
{* InitDPrint: Determines segment address of video RAM for DPrint     *}
{* Input   : none                                                     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure InitDPrint;

var CRTC_PORT : word absolute $0040:0063;  { Variable in BIOS var.seg. }

begin
  if CRTC_PORT = $3B4 then                { Monochrome card connected? }
    VSeg := $B000                        { YES, video RAM at B000:0000 }
  else                                      { NO, must be a color card }
    VSeg := $B800;                            { Video RAM at B800:0000 }
end;

{**********************************************************************}
{* DPrint: Writes a string direct into video RAM                      *}
{* Input   : - COLUMN: Output column                                  *}
{*           - LINES : Output line                                    *}
{*           - COLOR : Color (attribute) for individual characters    *}
{*           - STROUT: String to be displayed                         *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure DPrint( Column, Lines, Color : byte; StrOut : TextTyp);

var PAGE_OFS : word absolute $0040:$004E;  { Variable in BIOS var.seg. }
    Offset   : word;              { Pointer to current output position }
    i, j     : byte;                                    { Loop counter }
    Attribute : word;                           { Attribute for output }

begin
  Offset := Lines * 160 + Column * 2 + PAGE_OFS;
  Attribute := Color shl 8;   { High byte for word access to video RAM }
  i := length( StrOut );                     { Determine string length }
  for j:=1 to i do                                    { Execute string }
    begin          { Put character & attribute directly into video RAM }
      memw[VSeg:Offset] := Attribute or ord( StrOut[j] );
      Offset := Offset + 2;  { Set offset to next ASCII/attribute pair }
    end;
end;

{**********************************************************************}
{* Demo: Demonstrates application of DPrint                           *}
{* Input   : none                                                     *}
{* Output  : none                                                     *}
{**********************************************************************}

procedure demo;

var Column,                                  { Current output position }
    Lines,
    Color   : integer;

begin
  TextBackGround( BLACK );                     { Turn background black }
  ClrScr;                                               { Clear screen }
  DPrint( 22, 0, WHITE, 'DVIP  - (c) 1988 by Michael Tischer');
  Randomize;                          { Enable random number generator }
  while not KeyPressed do            { Repeat until user presses a key }
    begin
      Column := Random( 76 );                { Select column, row and  }
      Lines := Random( 22 ) + 1;             { color at random         }
      Color := Random( 14 ) + 1;
      DPrint( Column, Lines,   Color, '');{ Block character can be }
      DPrint( Column, Lines+1, Color, '');{ created by pressing    }
    end;                                      {<Alt><2><1><9>          }
  ClrScr;                                               { Clear screen }
end;

{**********************************************************************}
{**                           MAIN  PROGRAM                          **}
{**********************************************************************}

begin
  InitDPrint;                         { Initialize output using DPrint }
  Demo;                                           { Demonstrate DPrint }
end.

