{*********************************************************************}
{*                               D I R                               *}
{*-------------------------------------------------------------------*}
{*    Task        : Display all files of any Directory,              *}
{*                  including Sub-Directories and                    *}
{*                  Volume Names                                     *}
{*-------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                               *}
{*    developed on   : 07/08/87                                      *}
{*    last Update    : 05/04/89                                      *}
{*********************************************************************}

program DIRP;


Uses Crt, Dos;                          {* combines CRT and DOS unit *}
                     {** The format of a directory entry              }
                     {** as returned by the functions 4E(h) and 4F(h) }

type  DirBufTyp = record
                   Reservebuf : array [1..21] of char;
                   Attribute  : byte;
                   Ftime      : integer;
                   Fdate      : integer;
                   Fsizelo    : integer;
                   Fsizehi    : integer;
                   Fname      : array [1..13] of char
                 end;

     Path      = string[65];
     MonVec    = array[1..12] of string[3];
const ENTRY = 14;                         { Number of entries visible }
      Month: MonVec = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                       'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

var DirBuf : DirBufTyp;                   { accepts a Directory entry }
    Fname  : Path;                               { Files to be found  }

{*********************************************************************}
{* GETFIRST : read in the first Directory entry                      *}
{* Input    : none                                                   *}
{* Output   : true or false, depending if an entry was found         *}
{*                                                                   *}
{* Info     : the entry is stored in Variable DIRBUF                 *}
{*********************************************************************}

function GetFirst(FileName : Path;                { files to be found }
                 Attribute : integer) : boolean;   { search Attribute }

var Regs : Registers;      { Register-Variable for call of Interrupt }

begin
  FileName := FileName + #0;           { terminate file name with NUL }
  Regs.ah     := $4E;           { Function number for search of first }
  Regs.cx     := Attribute; { Attribute for which search is performed }
  Regs.ds     := seg(FileName);        { Segment address of file name }
  Regs.dx     := succ(ofs(FileName));   { Offset address of file name }
  MsDos( Regs );                           { Call DOS Interrupt 21(h) }
  if (Regs.flags and 1) = 0                     { Test Carry-Flag }
    then GetFirst := true                   { Equal to 0 : file found }
    else GetFirst := false;                           { no file found }
end;

{*********************************************************************}
{* GETNEXT : read in the following Directory entry                   *}
{* Input   : none                                                    *}
{* Output  : true or false, depending if another entry was found     *}
{*                                                                   *}
{* Info    : this function can only be called after a successful     *}
{*           call of the function GETFIRST                           *}
{*           the entry is stored in the  Variable DIRBUF             *}
{*********************************************************************}

function GetNext : boolean;

var Regs : Registers;         { Register variables for interrupt call }

begin
  Regs.ah     := $4F;               { Function number for next search }
  MsDos( Regs );                           { Call DOS Interrupt 21(h) }
  if (Regs.flags and 1) = 0                         { Test Carry-Flag }
    then GetNext := true                    { Equal to 0 : File found }
    else GetNext := false;                  { otherwise no file found }
end;

{*********************************************************************}
{* PRINTDATA : Output information on an entry                        *}
{* Input     : none                                                  *}
{* Output    : none                                                  *}
{* Info      : the information about the entry are taken by this     *}
{*             procedures from Variable DIRBUF                       *}
{*********************************************************************}

procedure PrintData;

var Counter    : byte;
    FileLength1,                            { both Variables are used }
    FileLength2 : real;                    { to calculate file length }
begin
  writeln;                   { the window is scrolled up by one line  }
  Counter := 1;         { begins with the first character of the name }
  while (DirBuf.Fname[Counter]<>#0) do             { repeat up to NUL }
   begin
    write(DirBuf.Fname[Counter]);         { output characters of name }
    Counter := succ(Counter)                 { process next character }
   end;
  gotoxy(13, ENTRY);
  FileLength1 := DirBuf.Fsizehi;              { determine file length }
  if FileLength1 < 0 then FileLength1 := 65536.0 + FileLength1;
  FileLength2 := DirBuf.Fsizelo;
  if FileLength2 < 0 then FileLength2 := 65536.0 + FileLength2;
  write('', FileLength1 * 65536.0 + FileLength2:7:0);
  gotoxy(21, ENTRY);
  write('',Month[DirBuf.Fdate shr 5 and 15]);
  write('/',DirBuf.Fdate and 31:2,'/');               { determine day }
  write(DirBuf.Fdate shr 9 + 1980:4);                { determine year }
  gotoxy(34, ENTRY);
  write('', DirBuf.Ftime shr 11:2, ':');            { determine hour }
  write(DirBuf.Ftime shr 5 and 63:3);             { determine minutes }
  gotoxy(44, ENTRY);                        { evaluate file attribute }
  write('');                          { separator to preceding field }
  if (DirBuf.Attribute and 1)<>0 then write('X')         { Read-only? }
                                else write(' ');
  if (DirBuf.Attribute and 2)<>0 then write('X')            { hidden? }
                                else write(' ');
  if (DirBuf.Attribute and 4)<>0 then write('X')            { system? }
                                else write(' ');
  if (DirBuf.Attribute and 8)<>0 then write('X')      { Volume-Label? }
                                else write(' ');
  if (DirBuf.Attribute and 16)<>0 then write('X')        { Directory? }
                                 else write(' ');
  write('');                          { right border of window frame }
end;

{*********************************************************************}
{* SETDTA  : set Address of DTA                                      *}
{* Input   : see above                                               *}
{* Ouptut  : none                                                    *}
{*********************************************************************}

procedure SetDTA(Segment,            { new Segment address of the DTA }
                 Offset  : integer);  { new Offset address of the DTA }

var Regs : Registers;  { Register-Variable for call of the Interrupt }

begin
  Regs.ah     := $1A;             { Set Function number for DTA }
  Regs.ds     := Segment;          { Segment address into DS register }
  Regs.dx     := Offset;            { Offset address into DX register }
  MsDos( Regs );          { Call DOS-Interrupt 21(h) }
end;

{*********************************************************************}
{* BUILDSCREENDISPLAY: prepares the display for output of the        *}
{*                     Directory                                     *}
{* Input   : none                                                    *}
{* Output  : none                                                    *}
{*********************************************************************}

procedure BuildScreenDisplay;

var Counter : integer;

begin
 clrscr;                                              { clear display }
 window(14,(20-ENTRY) shr 1+1,64,(20-ENTRY) shr 1 +5+ENTRY);
 gotoxy(1,1);                 { Cursor to left upper corner of window }
 write('ͻ');
 write(' File Name   Size     Date       Time   RHSVD');
 write('Ķ');
 for Counter := 1 to ENTRY do
  write('                                             ');
 write('ͼ');
 window(15,(20-ENTRY) shr 1+4,66,(20-ENTRY) shr 1 +3+ENTRY);
 gotoxy(1, ENTRY);            { Cursor to upper left corner of window }
end;

{*********************************************************************}
{* DIR: controls the input and output of Directories                 *}
{* Input   : none                                                    *}
{* Output  : none                                                    *}
{*********************************************************************}

procedure Dir;

var NumEntries,                       { Total number of entries found }
    Numwind      : integer;             { Number of entries in window }
    KeyPress     : char;                    { wait for key activation }
begin
 SetDTA(Seg(DirBuf), Ofs(DirBuf));            { DirBuf is the new DTA }
 clrscr;                                              { clear display }
 writeln('DIR (c) 1987 by Michael Tischer'#13#10);
 writeln('Please indicate search path for files         ');
 writeln('Example: if all files with the extension .BAT in the root ');
 writeln('         directory of the disk in drive A: are to be displayed ');
 writeln('         please input   A:*.BAT.');
 writeln('         If no search path is indicated, all files in the current');
 writeln('         directory are displayed.'#13#10);

 write('Which files are to be displayed: ');
 readln(Fname);                                  { read in file names }
 if Fname = '' then Fname := '*.*';            { search for all files }
 BuildScreenDisplay;                   { Construct display for output }
 Numwind := -1;                              { no entry in window yet }
 NumEntries := 0;                                    { no entry found }
 if GetFirst(Fname, 255) then                { search for first entry }
                                          { Attribute does not matter }
  repeat
   NumEntries := succ(NumEntries);             { found another entry  }
   Numwind := succ(Numwind);             { one more entry into window }
   if Numwind = ENTRY then                            { window full ? }
    begin                                                       { Yes }
     window(14,(20-ENTRY) shr 1 +5+ENTRY,66,(20-ENTRY) shr 1 +6+ENTRY);
     gotoxy(1, 1);                    { Cursor to last line of window }
     textbackground( LightGray );                  { gray  background }
     textcolor( Black  );                           { black characters}
     write('                Please press a key                 ');
     KeyPress := readkey;                        { wait for key press }
     gotoxy(1, 1);    { Cursor to the upper left corner of the window }
     textbackground( Black );                      { black background }
     textcolor( Lightgray );                       { white characters }
     write('                                                   ');
     window(15,(20-ENTRY) shr 1+4,65,(20-ENTRY) shr 1 +3+ENTRY);
     gotoxy(1, ENTRY);                { return Cursor to old position }
     Numwind := 0;                         { start count with 0 again }
    end;
   PrintData;                                  { output data of entry }
  until not(GetNext);                    { does another entry exist ? }
  window(14,(20-ENTRY) shr 1 +5+ENTRY,65,(20-ENTRY) shr 1 +6+ENTRY);
  gotoxy(1, 1);           { Cursor to the upper left corner of window }
  textbackground( LightGray );                     { black background }
  textcolor( Black );                     { light grey characters }
  write('                                                   ');
  gotoxy(2, 1);
  case NumEntries of
   0 : write('no file found ');
   1 : write('found a file ');
   else write(NumEntries,' files found ')
  end;
 window(1, 1, 80, 25);                  { set whole display as window }
end;

{*********************************************************************}
{**                           MAIN PROGRAMM                         **}
{*********************************************************************}

begin
 Dir;                                    { Load Directory and display }
end.
