/**********************************************************************/
/*                             T Y P M C                              */
/*--------------------------------------------------------------------*/
/*    Description    : Sets the key repeat rate on the AT keyboard    */
/*                     according to the preferences of the user.      */
/*--------------------------------------------------------------------*/
/*    Author         : MICHAEL TISCHER                                */
/*    developed on   : 08/28/1988                                     */
/*    last update    : 08/28/1988                                     */
/*--------------------------------------------------------------------*/
/*    (MICROSOFT C)                                                   */
/*    creation       : CL /AS /c TYPMC.C                              */
/*                     LINK TYPMC TYPMCA;                             */
/*    call           : TYPMC                                          */
/*--------------------------------------------------------------------*/
/*    (BORLAND TURBO C)                                               */
/*    creation      : via project file with following contents:       */
/*                     TYPMC                                          */
/*                     TYPMCA.OBJ                                     */
/**********************************************************************/

/*== Include files ===================================================*/

#include <stdlib.h>

/*== Typedefs ========================================================*/

typedef unsigned char byte;                 /* build ourselves a byte */
typedef byte bool;                            /* always TRUE or FALSE */

/*== Constants =======================================================*/

#define TRUE  1                       /* needed for working with BOOL */
#define FALSE 0

/*== Declaration of external functions in the assembler module =======*/

extern bool set_typm( byte trate );       /* sets the key repeat rate */

/**********************************************************************/
/**                           MAIN PROGRAM                           **/
/**********************************************************************/

void main(int argc, char *argv[] )
{
 int delay,                            /* stores the specified delay */
     speed;                      /* stores the specified repeat rate */

 printf("\nTYPMC  -  (c) 1988 by MICHAEL TISCHER\n");
 if (argc!=3 || ( (delay = atoi(argv[1]))<0 || delay>3 ) ||
                ( (speed = atoi(argv[2]))<0 || speed>31 ))
  {        /* illegal parameters were passed */
   printf("call: TYPMC         delay      key_repeat_rate\n");
   printf("                     \x1e              \x1e\n");
   printf("                                    \n");
   printf("     Ŀ  Ŀ\n");
   printf("       0 : 1/4 second       0 : 30.0 rep./s. \n");
   printf("       1 : 1/2 second   :   1 : 26.7 rep./s. \n");
   printf("       2 : 3/4 second   :   2 : 24.0 rep./s. \n");
   printf("       3 : 1 second     :   3 : 21.8 rep./s. \n");
   printf("     Ĵ           .         \n");
   printf("      all values  q20%%             .         \n");
   printf("                .         \n");
   printf("                             28 :  2.5 rep./s. \n");
   printf("                             29 :  2.3 rep./s. \n");
   printf("                             30 :  2.1 rep./s. \n");
   printf("                             31 :  2.0 rep./s. \n");
   printf("                            \n");
  }
 else                                           /* the parametes are OK */
  {
   if (set_typm( (delay << 5) + speed ))             /* set repeat rate */
    printf("The keyboard repeat rate was set.\n");
   else
    printf("ERROR accessing the keyboard controller.\n");
  }
}
