PROGRAM Sw_In;  { basic switch input }
{
  input BUSY, ACK, PAPER END, INPUT, STROBE, AUTO FEED, ERROR,
  and SELECT INPUT signals from IBM type parallel printer port.

  written in Turbo Pascal 6.0
}
USES CRT;

VAR   Base, Base_Address                 : INTEGER;
      Data_Byte, High_Nibble, Low_Nibble, OffSet : BYTE;
      
PROCEDURE Read_Switches(VAR Data_Byte : BYTE);

VAR High_Nibble, Low_Nibble : BYTE;

BEGIN { read switches }
{ first set all open collector output pins HIGH to read from base + 2      }
Port[Base + 2] := Port[Base_Address + 2] OR 15;
delay(50);
Low_Nibble :=  Port[Base + 2];
High_Nibble := Port[Base + 1];
Low_Nibble := Low_Nibble AND $0F;        { $0F = 00001111                   }
High_Nibble := High_Nibble AND $F0;      { $F0 = 11110000                   }
Data_Byte := High_Nibble OR Low_Nibble;
END;  { read switches  }

PROCEDURE Display_Data(Data_Byte : BYTE);
{
  display the bytes value and condition of each bit, HIGH or LOW
}
BEGIN
GoToXY(1,3); WRITELN('Base Address = ',Base, ';   Data Byte = ',Data_Byte:4);
WRITELN;
WRITE('D0 = '); IF (Data_Byte AND     1) =   1 THEN  { 00000001 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D1 = '); IF (Data_Byte AND     2) =   2 THEN  { 00000010 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D2 = '); IF (Data_Byte AND     4) =   4 THEN  { 00000100 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D3 = '); IF (Data_Byte AND     8) =   8 THEN  { 00001000 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D4 = '); IF (Data_Byte AND    16) =  16 THEN  { 00010000 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D5 = '); IF (Data_Byte AND    32) =  32 THEN  { 00100000 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D6 = '); IF (Data_Byte AND    64) =  64 THEN  { 01000000 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
WRITE('D7 = '); IF (Data_Byte AND   128) = 128 THEN  { 10000000 }
  WRITELN('HIGH') ELSE WRITELN('LOW ');
END;

BEGIN { basic switch input }
ClrScr;
{ find base address of LPT1, use 10 for LPT2, and 12 for LPT3 }
Base_Address := 1024; OffSet := 8;
Base := MemW[0: Base_Address + OffSet]; { Get base address }
  REPEAT
  Read_Switches(Data_Byte);
  Display_Data(Data_Byte);
  UNTIL KeyPressed;
END. { basic switch input }
