PROGRAM GamePort;
{
  Relatively fast input of joystick port info for your application.
  Originally written for IBM XT / XT clone machines.  With the AT and
  higher machines, you can use BIOS interrupts to read the joysticks.
  However, I find this version more than adequate for my needs.
  Written in Borland's Turbo Pascal 6.0.

  REF: IBM PC Joystick Control Using Turbo Pascal by James P. McAdems,
          BYTE Mag., October 1985, Page 143-144.
}
USES DOS, CRT;

 CONST Joy_Port_Address = $201; { game port base address }

VAR        I : INTEGER;
        Temp : BYTE;
          Ch : CHAR;
   Max_Count : INTEGER;     { Delay time needed for my AT clone machine }
                            { Adjust this value for your machine.       }


  FUNCTION Button_Pressed(Which_One : CHAR) : BOOLEAN;
   { return true if selected button is pressed }
  VAR Mask : BYTE;
  BEGIN
  IF NOT (Which_One IN ['A'..'D']) THEN Which_One := 'A';
  CASE Which_One OF
    'A' : Mask := 16;
    'B' : Mask := 32;
    'C' : Mask := 64;
    'D' : Mask := 128;
    END; { case }
  Button_Pressed := (PORT[Joy_Port_Address] AND Mask) = 0;
  END; { button pressed }

FUNCTION Joystick_Position(Which_One : CHAR) : INTEGER;
{
  Returns a number based on a joystick's position.  Values will
  vary depending on your joystick.  You can 'tweak' the program's
  performance by:
      1) Changing value of Max_Count,
      2) Using larger capacitors on game card
  Function returns 0 for out of range or uninstalled joystick polling.
}

VAR Counter : INTEGER;
    Mask : BYTE;

LABEL READ;
BEGIN
IF NOT (Which_One IN ['A'..'D']) THEN Which_One := 'A';
CASE Which_One OF
  'A' : Mask := 1;
  'B' : Mask := 2;
  'C' : Mask := 4;
  'D' : Mask := 8;
  END; { case }
{
  The Inline Code below causes the CX register to count down from Max_Count
  toward zero.  When CX reaches zero, or when the one-shot on the game
  adapter times out, the looping stops and counter is loaded with the
  active count.  Max_Count should be chosen so that CX never reaches 0,
  then the usable range ofthe joystick is not compromised.
}
              ASM
              MOV CX,Max_Count     {  Init down counter                  }
              MOV DX,Joy_Port_Address  {  load joystick port address     }
              MOV AH,Mask { [BP] } {  Mask of selected one_shot          }
              OUT DX,AL            {  Start the one shots                }
       READ:  IN AL,DX             {  Read the one shots                 }
              TEST AL,AH           {  Check selected one-shot            }
              LOOPNZ READ          {  Repeat until timed out             }
              MOV Counter,CX {  Make CX available to Turbo Pascal }
              END; { asm }
IF Counter = 0
  THEN Joystick_Position := 0
    ELSE Joystick_Position := Max_Count - Counter;
END;  { function joystick position }

PROCEDURE Process_Key_Press(VAR Ch : CHAR);
BEGIN
Ch := ReadKey;
IF CH IN ['J','j'] THEN
  BEGIN
  gotoxy(1,20); WRITE('Count now reads: ',Max_Count,';  Enter new value: ');
  ReadLn(Max_Count);
  gotoxy(1,20);
  WRITE('Count now reads: ',Max_Count,'                              ');
  END; { if }
END; { process key press }

BEGIN { main, GamePort }
ClrScr; Ch := ' ';
Max_Count := 2000;      { Delay time needed by my AT clone machine }
                        { Adjust this value for your machine.      }
REPEAT
gotoxy(1,24); write('Max_Count = ',Max_count,':   Press "J" to change');
GOTOXY(1,5);   { get joystick #1 info }
WRITE(Joystick_Position('A'):5, Joystick_Position('B'):5);
IF Button_Pressed('A') THEN WRITE('PRES':5) ELSE WRITE('UP':5);
IF Button_Pressed('B') THEN WRITE('PRES':5) ELSE WRITE('UP':5);
GOTOXY(1,7);   { get joystick #2 info }
WRITE(Joystick_Position('C'):5, Joystick_Position('D'):5);
IF Button_Pressed('C') THEN WRITE('PRES':5) ELSE WRITE('UP':5);
IF Button_Pressed('D') THEN WRITE('PRES':5) ELSE WRITE('UP':5);
If KeyPressed THEN Process_Key_Press(ch);
UNTIL ORD(Ch) = 27;
END. { main GamePort }


