PROGRAM AT_Game;
{
  Read joystick status.  Uses Bios calls added to AT bios.  This routine
  will not work on XT machines.

  REF: PC System Programming for Developers, Abacus Pub. 1989, Page 753

  INTERRUPT 15H, FUNCTION 84H, SUB-FUNCTION 0
  Reads status of joystick switches interfaced to a PC ( AT and higher ) IF
    a game port and switches are present.

  Read joystick info.  Uses BIOS Interrupt 15H
  INPUT:    AH = 84H
            DX = 0
  OUTPUT:   IF Carry Flag = 1 then no game port is installed
            IF Carry Flag = 0 then game port is installed
            AL = switch settings
              If bit 7 = 0 then first joystick's button 'A' is enabled
              If bit 6 = 0 then first joystick's button 'B' is enabled
              If bit 5 = 0 then second joystick's button 'A' is enabled
              If bit 4 = 0 then second joystick's button 'B' is enabled
  NOTES:    Sub Function 1 reads joystick positions

  INTERRUPT 15H, FUNCTION 84H, SUB-FUNCTION 1
  Reads position of joysticks interfaced to a PC ( AT and higher ) if game
  port and joysticks are present.

  INPUT:    AH = 84H
            DX = 1
  OUTPUT:   IF Carry Flag = 1 then no game port is installed
            IF Carry Flag = 0 then game port is installed
            AX contains X-Position of first joystick
            BX contains Y-Position of first Joystick
            CX contains X-Position of second Joystick
            DX contains Y-Position of second Joystick

            FLAGS Register =
                  BIT: 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
             FUNCTION:  -  -  -  -  O  D  I  T  S  Z  -  A  -  P  -  C
}

USES DOS, CRT;
VAR Regs : REGISTERS;
    Ch   : BYTE;
    Bit  : WORD;

   (* sub *) PROCEDURE Process_Joysticks;

   BEGIN
   Ch := 32;
   REPEAT
   REGS.AH := $84;     { get joystick positions     }
   Regs.DX := $01;
   INTR($15,Regs);
   gotoxy(1,5);        { display stick position     }
   WRITE(Regs.AX:7, Regs.BX:9, Regs.CX:16, Regs.DX:10);

   REGS.AH := $84;     { get joystick button values }
   Regs.DX := $00;
   INTR($15,Regs);
   GOTOXY(1,8);
                       { display button position    }
   IF (REGS.AL AND 16) <> 16 THEN WRITE(' ON':6) ELSE WRITE('OFF':6);
   IF (REGS.AL AND 32) <> 32 THEN WRITE(' ON':13) ELSE WRITE('OFF':13);
   IF (REGS.AL AND 64) <> 64 THEN WRITE(' ON':16) ELSE WRITE('OFF':16);
   IF (REGS.AL AND 128) <> 128 THEN WRITE(' ON':10) ELSE WRITE('OFF':10);

   IF KeyPressed THEN BEGIN Ch := ORD(ReadKey); END;
   UNTIL ch = 27;
   END; { process joystick }

BEGIN
ClrScr; Ch := 32;
WITH Regs DO
  BEGIN
  AH := $84;
  DX := $00;
  INTR($15,Regs);
  Bit := FLAGS AND $0001;
  IF Bit <> 0 THEN        { is game board installed }
    BEGIN
    WRITELN;
    WRITELN('NO GAME CARD IS INSTALLED ON THIS MACHINE'); WRITELN;
    WRITELN('PRESS ANY KEY TO CONTINUE '); READLN;
    HALT;
    END { if }
  ELSE
    BEGIN
    GOTOXY(1,3);
    WRITELN('       JOYSTICK A               JOYSTICK B ');
    WRITE('    x-pos    y-pos           x-pos     y-pos');
    gotoxy(1,7); WRITE(' Button-A     Button-B       Button-A     Button-B');
    GOTOXY(5,24); WRITE(' Press ESC to exit');
    END; { else }
  Process_Joysticks;
  END; { with regs. }
END.





