 /*                        UNIT My33_TPU
		     Code conversion by Eugene Klein
		 A TPU unit of procedures I repeatedly use
 */


union REGS regs;
struct Line_Info_Type
       {
	int X1;
	int Y1;
	int X2;
	int Y2;
       };

char OK_Set[15];
char Digit[10][10][15];
int X, Y, Color, Xdir, Ydir;
struct Line_Info_Type Lines;
unsigned int Lpt_Port_Address;


void Clear_Kbd_Buffer(void)
  // Clear contents of keyboard buffer.
  // From PC Intern, by Michael Tischer, Abacus Press, 1992, page 462
{
 disable();                  // disable hardware interrupts
 poke(0x40,0x1A,peek(0x40,0x1C));  // No more characters in Buffer
 enable();                   // enable hardware interrupts
}

int Get_Character( char OK_Set[15])
// Read a character from the keyboard.  Print the character's ASCII code at
// the cursor.  Return the ASCII code to program via variable Ch
{
 unsigned int Ch=0;
 unsigned int extended;
 char *ptr=0;
 while(!ptr)
 {
  while(!kbhit()){}
   Ch=getch();
  if(!Ch)
  {
   extended = getch();
   Ch=extended + 0x80;
  }
  ptr=strchr(OK_Set,Ch);
  if(ptr)
  {
   if((Ch >= 0x32) && (Ch <=0xff))
   printf("%c",Ch);
  }
  else
   printf("\a");
 }
 return(Ch);
}

unsigned char Select_Printer_Port(void)
{
 // check for valid port selection  ( 1, 2, or 3 )
 // check that selected printer port is actually installed on machine
 // return port address from BIOS variable segment, ( Lpt_Port_Address )
 //  0x0408 contains port address of LPT1
 //  0x040A contains port address of LPT2
 //  0x040C contains port address of LPT3
 // The Programmer's PC Sourcebook, MicroSoft Press, 1991, Page 7-75,
 // Compute's Mapping the IBM PC, Compute Books, 1985, page 234

 char Ch;
 unsigned char Lpt_Num;

 do
 {
  char *OK_Set = "123";
  clrscr(); Lpt_Port_Address = 0;
  gotoxy(1,10); printf("Which printer port do you want to use, 1, 2, or 3? ");
  Ch=Get_Character( OK_Set);
  Lpt_Num = Ch - 48;
  Lpt_Port_Address = peek( 0, 0x0400 + 6 + ( Lpt_Num * 2 ) );
  if (Lpt_Port_Address == 0)
  {
   printf("\nPort selected is not installed on this machine.\n");
   printf("PRESS ANY KEY TO CONTINUE:");
   getch();
  }  // if address = 0
 }while(Lpt_Port_Address == 0);
 return(Lpt_Num);
}

unsigned int Init_Printer_Port(unsigned char Lpt_Num)
// Initialize selected printer port;
// Tell ROM-BIOS service routine $17, function $01, to initialize the selected
//   printer port, Lpt_Num.
// References:
// PC Interrupts, Addison-Wesley, 1991, page 3-31, &  Programmer's Reference
// Manual for IBM Personal Computers, Dow Jones Pub, 1986 Pub. Page 678
{
 regs.h.ah=0x01;           //function number
 regs.x.dx=Lpt_Num;        //port number
 int86(0x17,&regs,&regs);
 return( peek(0, 0x0400 + 6 + ( Lpt_Num * 2 )) );
}

void Cursor_Off(void)
// Hide the cursor.  Actually, sets cursor off the screen
// Uses BIOS interrupt $10, Function 1 to hide the curser
// Restores the normal default cursor settings.
// Uses BIOS interrupt $10, Function 1 to hide the curser
// Turbo Pascal 6, Comp. Ref; Borland/Osborne Pub; Stephen. O'Brien, Page 416
// PC Interrupts, Addison Wesley Pub. 1991, by Ralf Brown; Page 5-12
// Programmer's Ref Man for IBM Per. Comp. Dow Jones Irwin Pub, 1986; P.522
// Programming the IBM User Interface; Addison-Wesley 1989; Ben Ezzell; P.223

{
 regs.h.ah = 0x01;  // set cursor shape
 regs.h.ch = 0x20;  // hide cursor, starting row
 regs.h.cl = 0x02;  // hide cursor, ending row
 int86(0x10, &regs,&regs);
}

void Graphics_Cursor_ON(void)
// Uses BIOS interrupt $10, Function 1 to restore the normal cursor
// Restores the normal default cursor settings to any color graphics card
// Programming the IBM User Interface; Addison-Wesley, 1989; P.223
{
 regs.h.ah = 0x01;
 regs.h.ch = 0x06;
 regs.h.cl = 0x07;
 int86(0x10,&regs,&regs);
}

void Mono_Cursor_ON(void)
// Uses BIOS interrupt 0x10, Function 1 to restore the normal cursor. Restores
// the normal default cursor to monochrome and Hercules graphics cards.
// Programming the IBM User Interface; Addison-Wesley, 1989; P.223
{
 regs.h.ah = 0x01;
 regs.h.ch = 0x09;
 regs.h.cl = 0x0A;
 int86(0x10,&regs,&regs);
}

char *Get_Video_Card(void)
// Determine the active video card.  This is not a trivial task
// Turbo Pascal 6 System Programming, Abacus 1991, Michael Tischer,Pg 410-15
{
 char VGA_Vidio_Tab[13][8]  =
		   {"Unknown","MDA","CGA","Unknown","EGA","EGA","Unknown",
		    "VGA","VGA","Unknown","CGA","CGA","CGA"};
 unsigned int Mono_Adr_Reg = 0x3b4; // monochrome card port address
 unsigned int Mono_Status = 0x3ba;  // monochrome card's status port address
 unsigned int i;
 int status;                        // MDA-/ Hercules status port
 char Video_Card[10] ="Unknown";
 //int Video_Mode;

 regs.h.ah = 0x0F;                  // Function to determine vidio mode
 int86(0x10,&regs,&regs);
 //Video_Mode = regs.h.al && 0x7f;    // store vidio mode
 regs.x.ax = 0x1a00;                // Function to determine if only VGA
 int86(0x10,&regs,&regs);
 if(regs.h.al == 0x1a)              // is function available?
 {
  if(regs.h.bl != 0x1a)             // yes, VGA, code of current card in  BL }
   strcpy(Video_Card,VGA_Vidio_Tab[regs.h.bl]);    // yes, get code from table }
 }
 else                               // not VGA, is it an EGA ?
 {
  regs.h.ah = 0x12;                 // call function $12
  regs.h.bl = 0x10;                 // sub function $10
  int86(0x10,&regs,&regs);          // call video BIOS
  if(regs.h.bl != 0x10)
   strcpy(Video_Card,"EGA");        // EGA  is installed
 }
 if(!strcmp(Video_Card,"Unknown"))  // vidio card  still unknown?
 {
  if  (peek(0x0040,0x0063) == Mono_Adr_Reg ) // monochrome card ?
  {
   // yes, must be MDA or Hercules
   // if card is Hercules, then bit 7 in CRT status register will change,
   // otherwise, the card is a monochrome display
   status = inport(Mono_Status) && 0x80; // read CRT status port
   i = 0;
   while((inport(Mono_Status) && 0x80 == status) && (i++ <=32767))
   {
    if ( i == 32767 )
     strcpy(Video_Card,"MDA");
    else
     strcpy(Video_Card,"Herc");
   }
  }
 }
 else
   strcpy(Video_Card,"CGA");
 return(Video_Card);
}





void Error_Message(void)
{
 clrscr();
 printf("\nUnable to restore your cursor.\nYour type of vidio display is UNKNOWN to this software");
 printf("\nPRESS ANY KEY TO CONTINUE:");
 getch();
}


void Generate_Characters( char DIGIT[8][9][10])
// generate large numbers from extended ASCII characters
{
 strcpy(DIGIT[0][1],"  ");
 strcpy(DIGIT[0][2],"     ");
 strcpy(DIGIT[0][3],"       ");
 strcpy(DIGIT[0][4],"       ");
 strcpy(DIGIT[0][5],"       ");
 strcpy(DIGIT[0][6],"       ");
 strcpy(DIGIT[0][7],"       ");
 strcpy(DIGIT[0][8],"     ");
 strcpy(DIGIT[0][9],"  ");

 strcpy(DIGIT[1][1],"        ");
 strcpy(DIGIT[1][2],"        ");
 strcpy(DIGIT[1][3],"        ");
 strcpy(DIGIT[1][4],"        ");
 strcpy(DIGIT[1][5],"        ");
 strcpy(DIGIT[1][6],"        ");
 strcpy(DIGIT[1][7],"        ");
 strcpy(DIGIT[1][8],"        ");
 strcpy(DIGIT[1][9],"        ");

 strcpy(DIGIT[2][1],"  ");
 strcpy(DIGIT[2][2],"     ");
 strcpy(DIGIT[2][3],"        ");
 strcpy(DIGIT[2][4],"       ");
 strcpy(DIGIT[2][5],"  ");
 strcpy(DIGIT[2][6],"       ");
 strcpy(DIGIT[2][7],"        ");
 strcpy(DIGIT[2][8],"        ");
 strcpy(DIGIT[2][9],"");

 strcpy(DIGIT[3][1],"  ");
 strcpy(DIGIT[3][2],"     ");
 strcpy(DIGIT[3][3],"        ");
 strcpy(DIGIT[3][4],"       ");
 strcpy(DIGIT[3][5],"   ");
 strcpy(DIGIT[3][6],"       ");
 strcpy(DIGIT[3][7],"        ");
 strcpy(DIGIT[3][8],"     ");
 strcpy(DIGIT[3][9],"  ");

 strcpy(DIGIT[4][1],"       ");
 strcpy(DIGIT[4][2],"       ");
 strcpy(DIGIT[4][3],"       ");
 strcpy(DIGIT[4][4],"       ");
 strcpy(DIGIT[4][5],"");
 strcpy(DIGIT[4][6],"        ");
 strcpy(DIGIT[4][7],"        ");
 strcpy(DIGIT[4][8],"        ");
 strcpy(DIGIT[4][9],"        ");

 strcpy(DIGIT[5][1],"");
 strcpy(DIGIT[5][2],"        ");
 strcpy(DIGIT[5][3],"        ");
 strcpy(DIGIT[5][4]," ");
 strcpy(DIGIT[5][5],"       ");
 strcpy(DIGIT[5][6],"        ");
 strcpy(DIGIT[5][7],"        ");
 strcpy(DIGIT[5][8],"     ");
 strcpy(DIGIT[5][9],"  ");

 strcpy(DIGIT[6][1],"       ");
 strcpy(DIGIT[6][2],"       ");
 strcpy(DIGIT[6][3],"        ");
 strcpy(DIGIT[6][4]," ");
 strcpy(DIGIT[6][5],"     ");
 strcpy(DIGIT[6][6],"       ");
 strcpy(DIGIT[6][7],"       ");
 strcpy(DIGIT[6][8],"     ");
 strcpy(DIGIT[6][9],"  ");

 strcpy(DIGIT[7][1],"");
 strcpy(DIGIT[7][2],"        ");
 strcpy(DIGIT[7][3],"        ");
 strcpy(DIGIT[7][4],"        ");
 strcpy(DIGIT[7][5],"        ");
 strcpy(DIGIT[7][6],"        ");
 strcpy(DIGIT[7][7],"        ");
 strcpy(DIGIT[7][8],"        ");
 strcpy(DIGIT[7][9],"        ");

 strcpy(DIGIT[8][1],"  ");
 strcpy(DIGIT[8][2],"     ");
 strcpy(DIGIT[8][3],"       ");
 strcpy(DIGIT[8][4],"     ");
 strcpy(DIGIT[8][5],"  ");
 strcpy(DIGIT[8][6],"     ");
 strcpy(DIGIT[8][7],"       ");
 strcpy(DIGIT[8][8],"     ");
 strcpy(DIGIT[8][9],"  ");

 strcpy(DIGIT[9][1],"  ");
 strcpy(DIGIT[9][2],"     ");
 strcpy(DIGIT[9][3],"       ");
 strcpy(DIGIT[9][4],"     ");
 strcpy(DIGIT[9][5]," ");
 strcpy(DIGIT[9][6],"        ");
 strcpy(DIGIT[9][7],"        ");
 strcpy(DIGIT[9][8],"        ");
 strcpy(DIGIT[9][9],"        ");
}
