/*                            PROGRAM MOT_3
   5-wire stepping motor single phase control. Only one motor winding
   is energized at a time.

   Code conversion by Eugene Klein
*/
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

const int       D0 = 1;
const int       D1 = 2;
const int       D2 = 4;
const int       D3 = 8;
const int       t = 100;
int E;
unsigned int Lpt_Num, Lpt_Port_Address;

void main()
{
 /* %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD ONE ]=-  %%%%%%%%%%%%%%%%% *

   Basic 5-wire stepping motor control.  Uses Pascal's WRITE command to
   transmit data through computer's LPT1 printer port.  The WRITE commands
   sends data WITHOUT generating printer Line Feed, or Carriage Return
   instructions.
 */
 for(E=1;E<=10;E++)       // step motor clockwise through 40 steps
 {
  putc(D0,stdprn);
  delay(t);
  putc(D1,stdprn);
  delay(t);
  putc(D2,stdprn);
  delay(t);
  putc(D3,stdprn);
  delay(t);
 }
  for(E=1;E<=10;E++)       // step motor counter-clockwise through 40 steps
 {
  putc(D3,stdprn);
  delay(t);
  putc(D2,stdprn);
  delay(t);
  putc(D1,stdprn);
  delay(t);
  putc(D0,stdprn);
  delay(t);
 }

  /* * %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=-  %%%%%%%%%%%%%%%%% *

   Alternitive 5-wire stepping motor control.  Data is sent to printer port
   LPT1, LPT2, or LPT3.  From users keyboard input of the number 1, 2, or 3,
   port's address is computed, and used to route data.

   Since the printer port latches data sent to it, data sent to a printer
   port will remain on the output pins until new data replaces it.  That
   means stepping motors, directly driven by printer port logic, will hold
   there position between transmitted instructions.
 */
 Lpt_Num = Select_Printer_Port();
 Lpt_Port_Address = Init_Printer_Port(Lpt_Num);
 clrscr();

 for(E=1;E<=10;E++)    // step motor clockwise through 40 steps
 {
  outport(Lpt_Port_Address,D0);
  delay(t);
  outport(Lpt_Port_Address,D1);
  delay(t);
  outport(Lpt_Port_Address,D2);
  delay(t);
  outport(Lpt_Port_Address,D3);
  delay(t);
 }
 for(E=1;E<=10;E++)    // step motor counter-clockwise through 40 steps
 {
  outport(Lpt_Port_Address,D3);
  delay(t);
  outport(Lpt_Port_Address,D2);
  delay(t);
  outport(Lpt_Port_Address,D1);
  delay(t);
  outport(Lpt_Port_Address,D0);
  delay(t);
 }
}