/*                      Program LOGICAL
		   Code conversion by Eugene Klein

PROGRAM Logical; { demonstrates logical operators AND, OR, and XOR
*/


#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

unsigned char  Byte_1, Byte_2, Byte_3;

void AND_Operator(void)

/* PROCEDURE AND_Operator;  { demonstrate logical AND operation

 Logically "compares" the outcome of "ANDing" bits.  The AND operator
 reports the "truth" of bitwise comparing two, byte long variables. IF
 both bits are high, then the resultant outcome bit's value high

     Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
		      Ŀ
    Byte_1 =  77  =    0  1  0  0  1  1  0  1 
		      
    AND                AND AND AND AND AND AND AND AND
		      Ŀ
    Byte_2  = 62  =    0  0  1  1  1  1  1  0 
		      
    YIELDS                                   
		      Ŀ
    Byte_3  = 12  =    0  0  0  0  1  1  0  0 
		      

	IN DECIMAL;  77 AND 62 = 12
*/

{
 Byte_1 = 77;
 Byte_2 = 62;
 Byte_3 = Byte_1 & Byte_2;
 printf("Byte_1 AND Byte_2 = %i (00001100) \n",Byte_3);
}

void OR_Operator(void)    //    demonstrate logical OR operation

/* Logically "compares" the outcome of "ORing" bits.  The OR operator reports
 the "truth" of bitwise comparing two, byte long variables. IF either bit
 is high, then the resultant outcome bit's value high.

     Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
		      Ŀ
     Byte_1  = 77  =   0  1  0  0  1  1  0  1 
		      
     OR                OR  OR  OR  OR  OR  OR  OR  OR
		      Ŀ
     Byte_2  = 62  =   0  0  1  1  1  1  1  0 
		      
     YIELDS                                  
		      Ŀ
     Byte_3  = 127 =   0  1  1  1  1  1  1  1 
		      
*/
{
 Byte_1 = 77;
 Byte_2 = 62;
 Byte_3 = Byte_1 | Byte_2;
 printf("Byte_1 OR Byte_2 = %i (01111111) \n",Byte_3);
}

void XOR_Operator(void)     //  demonstrate logical XOR operation

/* Logically "compares" the outcome of "XORing" bits.  The XOR operator
 reports the "truth" of bitwise comparing two, byte long variables. IF
 either bit, but not both bits, is high, then the resultant outcome bit's
 value high

     Bit Position       7   6   5   4   3   2   1   0
     Decimal value     128 64  32  16   8   4   2   1
		      Ŀ
     Byte_1 = 77 =     0  1  0  0  1  1  0  1 
		      
     XOR               XOR XOR XOR XOR XOR XOR XOR XOR
		      Ŀ
     Byte_2 = 62 =     0  0  1  1  1  1  1  0 
		      
     YIELDS                                  
		      Ŀ
     Byte_3 = 115 =    0  1  1  1  0  0  1  1 
		      
*/
{
 Byte_1 = 77;
 Byte_2 = 62;
 Byte_3 = Byte_1 ^ Byte_2;
 printf("Byte_1 XOR Byte_2 = %i (01110011) \n",Byte_3);
}

void main()
{
 printf("\nByte 1 = 77 (01001101) Byte 2 = 66 (001111110)\n");
 AND_Operator();
 OR_Operator();
 XOR_Operator();
}















