 /*                     PROGRAM LCD_Demo
		   Code conversion by Eugene Klein
 */
/*
  Demonstrates how to control any LCD device that uses a Hatachi 44780
  controller. The 44780 is widely used to control LCD displays of up to two
  lines of 40 characters. This demo controls a LCD display via an IBM
  parallel printer port.  It generates 5 by 7 pixel characters and
  graphics, as well as 5 by 10 pixel characters and graphics,
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"

unsigned char String30[80];

const int T = 1;
const int All_High = 4; // 00000100, all control line outputs HIGH
const int All_Low = 11; // 00001011, all control line outputs LOW
const unsigned int Strobe = 0xFF01;   // 11110001 }
const unsigned int AutoFeed = 0xFF02; // 00000010 }

unsigned char Tab, Data;
int Temp,Strobe1;
int Use_Large_Letters;
unsigned char Message[80];
unsigned int RS, Lpt_Num, LPTx;
union REGS Regs;

void Pulse_Strobe_Line(void)
/* provide the LCD module with an ACTIVE LOW strobe
   in other words, pulse inverted strobe line so output goes HIGH, then LOW
*/
{
// pulse strobe line HIGH
 delay(T);
 outport(LPTx + 2,(inport( LPTx + 2) & 0xfe));
 delay(T);
 // pulse strobe line LOW
 outport(LPTx + 2,(inport( LPTx + 2) | 0x1));
 delay(T);  // turn strobe LOW
}

void Set_Control_Bit(unsigned int LPTx, unsigned int Bit)
{
 outport(LPTx + 2,All_Low); delay(T); //clear I/O lines,00000100
 if(Bit == 2)       // turn RS, ( = D1, inverted AutoFeed line) HIGH
  Temp = inport(LPTx + 2) & (255 - Bit);
 else               // turn RS, ( = D1, inverted AutoFeed line ) LOW          }
 {
  Temp = inport(LPTx + 2) | Bit;
 }
 outport(LPTx + 2, Temp); delay(T);      // read value at Lpt1 + 2
}

void Transmit_Byte(int LPTx, int RS, int Data)
// RS = AutoFeed = Bit 2 of Base + 2.  This is an INVERTED bit                 }
{
 Set_Control_Bit(LPTx, RS);
 outport(LPTx, Data); delay(T);       // put data on data lines
 Pulse_Strobe_Line();
}

void Write_Character(unsigned int LPTx,int Data)
// RS must be high to send LCD display character data
{
 RS = 0x02;
 Transmit_Byte( LPTx, RS, Data);
}

void Write_Instruction(unsigned int LPTx,int Data)
 // RS must be LOW to to send LCD display control instruction
{
 RS = 0x00;
 Transmit_Byte(LPTx, RS, Data);
}

void Init_LCD_Module(unsigned int LPTx)
/* Transmit Control Word three times to tell module you are initilizing set-up.
   Just follow sequence set forth in LCD's data manual: to initilize module:
   -send control number three times with small delay between transmissions.
   -Delay provids time for LCD chip to digest information.  Delay is
   usually not required for PASCAL, C, or BASIC compiled programs, BUT,
   -Delay is a must for Embedded controller / LCD module control.
*/
{
 outport(LPTx + 2,All_Low);
 delay(T); // set all control lines LOW
 Data = 0x34;     //30hex = 48dec,  set for 8-bit interface, one display line
 outport(LPTx, Data); delay(T);
 Pulse_Strobe_Line();
 delay(T);
}

void Set_Desired_Configuration(int Large_Letters)
// all options are listed in LCD data manual                                   }
{
// Set 8 bit interface, 1 line display, & 5 by 10 character set = $34          }
 if(Large_Letters)
  Data = 0x34;
 else
  Data = 0x30;
 Write_Instruction(LPTx, Data);
// display on, cursor off  }
 Data = 0x0C; Write_Instruction(LPTx, Data);
// clear display }
 Data = 0x01; Write_Instruction(LPTx, Data);
	// move cursor to beginning of line }  { for beginning of 2ed line, use $40    }
 Data = 0x02; Write_Instruction(LPTx, Data);
// increment addr counter after each write, to keep cursor moving to right }
 Data = 0x06; Write_Instruction(LPTx, Data);
}


void Send_Message(int Tab, char Message[30])
//   For each byte of data sent:                                              }
//   1) Tell module you are going to write to CG memory                       }
//   2) Send data to that address                                             }
{
 int E;

// clear display }
 Data = 0x01; Write_Instruction(LPTx, Data);
// move cursor to beginning of line }
 Data = 0x02; Write_Instruction(LPTx, Data);
// tab to center text }
 Data = 127 + Tab; Write_Instruction(LPTx, Data);
// send message }
 for(E=0;E<strlen(Message);E++)
 {
  Data = (Message[E]);
  Write_Character(LPTx, Data);
 }
 delay(1500);
}

void Load_User_Defined_Character(int size, unsigned char  *Redefined_Character)
// Send redefined character info to CG memory }
{
 int Instr, E;
 Instr = 0x40;
 for(E=0;E<size;E++)
 {
// tell LCD module you are going to write to CG memory, at address Instr }
 Write_Instruction(LPTx, Instr++);
// write character definition BYTE to CG memory }
  Data = *(Redefined_Character+E);
  Write_Character(LPTx, Data);
 }
}

void Define_And_Load_Airplane(void)
// Define airplane.  This is one case where BASIC had a better idea.  DATA
//  statement support would be very useful here.
{
 int Instr, E;
 unsigned char Airplane[]=

		  {0x00,
		   0x00,
		   0x00,
		   0x00,
		   0x00,
		   0x00,
		   0x00,
		   0x00,

		   0x18,  // 000* *000 }
		   0x18,  // 000* *000 }
		   0x18,  // 000* *000 }
		   0x1F,  // 000* **** }
		   0x1F,  // 000* **** }
		   0x00,
		   0x00,
		   0x00,

		   0x10,  // 000* 0000 }
		   0x0C,  // 0000 **00 }
		   0x06,  // 0000 *0*0 }
		   0x1F,  // 000* **** }
		   0x1F,  // 000* **** }
		   0x06,  // 0000 *0*0 }
		   0x0C,  // 0000 **OO }
		   0x10,  // 000* 0000 }

		   0x00,
		   0x00,
		   0x00,
		   0x1C,  // 000* **00 }
		   0x1F,  // 000* **** }
		   0x00,
		   0x00,
		   0x00};








 Load_User_Defined_Character(sizeof(Airplane),Airplane);
}

void Define_And_Load_Happy_Face(void)
{


// this is the closest thing to BASIC's DATA statement }
 unsigned char Happy_Face[]  =
		   { 0x03,  // 0000 00** }
		     0x08,  // 0000 *000 }
		     0x10,  // 000* 0000 }
		     0x12,  // 000* 00*0 }
		     0x10,  // 000* 0000 }
		     0x10,  // 000* 0000 }
		     0x14,  // 000* 0*00 }
		     0x03,  // 0000 00** }
		     0x08,  // 0000 *000 }
		     0x03,  // 0000 00** }
		     0x00,  // 0000 0000 }

	0x00,0x00, 0x00, 0x00, 0x00,       // spaces

		     0x18,  // 000* *000   char B
		     0x02,  // 0000 00*0 }
		     0x01,  // 0000 000* }
		     0x09,  // 0000 *00* }
		     0x01,  // 0000 000* }
		     0x01,  // 0000 000* }
		     0x05,  // 0000 0*0* }
		     0x18,  // 000* *000 }
		     0x02,  // 0000 00*0 }
		     0x18,  // 000* *000 }
		     0x00 };// 0000 0000 }

 Load_User_Defined_Character(sizeof(Happy_Face),Happy_Face);
}


void main()
{
 const int TRUE = 1;
 const int FALSE = 0;
 int Use_Large_Letters;
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 clrscr();
 do
 {
  printf(" 5 by 10 characters with user defined happy face \n");
  Init_LCD_Module(LPTx);
  Use_Large_Letters = TRUE;
  Set_Desired_Configuration(Use_Large_Letters);
  Define_And_Load_Happy_Face();
  stpcpy(Message,"\x01");                        // ASCII characters
  strcat(Message,"\x02");                        // happy smile  pattern
  strcat(Message," HELLO! ");
  strcat(Message,"\x01");
  strcat(Message,"\x02");
  Tab = 3;
  Send_Message(Tab, Message);
  if(kbhit())
    exit(0);
  printf("-=[ send ASCII using 5 by 10 character set ]=-\n");
  Init_LCD_Module(LPTx);
  Use_Large_Letters = TRUE;
  Set_Desired_Configuration(Use_Large_Letters);
  stpcpy(Message,"Paul Ber");
  strcat(Message,"\xE7");
  strcat(Message,"sman");
  Tab = 2; Send_Message(Tab, Message);
  printf("-=[ 5 by 7 characters with user defined airplane ]=-\n");
  Init_LCD_Module(LPTx);
  Use_Large_Letters = FALSE;
  Set_Desired_Configuration(Use_Large_Letters);
  Define_And_Load_Airplane();
  stpcpy(Message,"\x02");
  strcat(Message,"\x01");
  strcat(Message,"\x03");
  strcat(Message," HELLO! ");
  strcat(Message,"\x02");
  strcat(Message,"\x01");
  strcat(Message,"\x03");
  Tab = 2;
  Send_Message(Tab, Message);
  if(kbhit())
    exit(0);
  printf("-=[ send ASCII using 5 by 10 character set ]=-\n");
  Init_LCD_Module(LPTx);
  Use_Large_Letters = TRUE;
  Set_Desired_Configuration(Use_Large_Letters);
  stpcpy(Message,"Paul Ber");
  strcat(Message,"\xE7");
  strcat(Message,"sman");
  Tab = 2; Send_Message(Tab, Message);
  printf("\n");
 }while(!kbhit());
}

