/*                    PROGRAM Batch_Sw
		   Code conversion by Eugene Klein

  This program is run at the start of an Autoexec.BAT file. It will read
  switches connected to a parallel printer port. It leaves the value,
  (0 - 255 ), as an ERROR CODE for the remaining AUTOEXEC.BAT code.
  Using Autoexec.bat's GOTO command, I can branch to different system
  configurations at boot up.

  I mounted my eight switches on an unused disk drive bay panel.

  If switches are concealed, this setup cam provide a security padlock.

  All IBM / IBM clone computers support three printer port locations:
    LPTx = 3BC HEX = 956 DECIMAL = MGA Graphics Card's printer port
    LPTx = 378 HEX = 888 DECIMAL = CGA Graphics Card's printer port
    LPTx = 278 HEX = 632 DECIMAL = PS/2 printer port,  XT & AT's 3rd PRN port

  The high nibble is read from LPTx + 1, the low nibble from LPTx + 2.
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include "My_TPU.h"


int *Exit_Save, Error_Code;
unsigned int  LPTx;
unsigned char B, Lo_Bit, Hi_Bit, Lpt_Num;


void main()
{
 Lpt_Num = Select_Printer_Port();
 LPTx = Init_Printer_Port(Lpt_Num);
 B = inport(LPTx + 2);
 outport(LPTx + 2,B | 32);    // Set port's LPTx + 2 address to input data.
 Lo_Bit = inport(LPTx + 2);   // D0 - D3 connected to DB-25 pins  1,14,16,17.
 Hi_Bit = inport(LPTx + 1);   // D4 - D7 connected to DB-25 pins 13,12,10,11.
 // Leave error code byte for autoexec.bat.
 Error_Code = (Hi_Bit & 0xF0) + (Lo_Bit & 0x0F);
 printf("\n\nErrorCode being left = %i\n\n",Error_Code);
 exit(Error_Code);
}

