1   REM
2   REM  FILE: SW_IN.BAS
3   REM
100 REM  basic 8-bit switch input  from parallel printer port
105 REM
110 REM  input BUSY, ACK, PAPER END, INPUT, STROBE, AUTO FEED, ERROR,
120 REM  and SELECT INPUT signals from IBM type parallel printer port.
130 REM
140 REM  written in QBASIC
150 LPT = 0: BaseAddress = 0
160 DataByte = 0: HighNibble = 0:  LowNibble = 0: OffSet = 0
170 REM
200 REM -=[ begin program ]=-
210 CLS 0
220 REM  find base address of LPT1, use 10 for LPT2, and 12 for LPT3
230 BaseAddress = &H400 + 8
240 DEF SEG = 0
245 LPT = PEEK(BaseAddress) + (PEEK(BaseAddress + 1) * 256)
250 REM
260 GOSUB 700: REM  read switches
270 GOSUB 860: REM  display data
280 IF INKEY$ = "" THEN GOTO 250
290 END: REM  -=[ program end ]=-  
300 REM
310 REM
699 REM   
700 REM  -=[ Subroutine,  Read Switches ]=-
710 REM
720 HighNibble = 0: LowNibble = 0
730 REM   first set all open collector output pins HIGH to read from base + 2
735 REM
740 OUT (LPT + 2), (INP(LPT + 2) OR 15)
750 FOR E = 1 TO 50: NEXT E:           REM delay dependent on your machine
760 LowNibble = INP(LPT + 2)
770 HighNibble = INP(LPT + 1)
780 LowNibble = (LowNibble AND &HF)
790 HighNibble = (HighNibble AND &HF0)
800 DataByte = (HighNibble OR LowNibble):   REM   combine nibbles into byte
810 RETURN: REM   end of subroutine, read switches
850 REM
860 REM    -=[ subroutine, display data ]=-
870 REM
880 LOCATE 1, 3
890 PRINT "Base Address = "; LPT; ";    Data Byte = "; DataByte; "   "
895 PRINT
900 PRINT "D0 = ";
902 IF (DataByte AND 1) = 1 THEN PRINT "HIGH" ELSE PRINT "LOW "
904 PRINT "D1 = ";
906 IF (DataByte AND 2) = 2 THEN PRINT "HIGH" ELSE PRINT "LOW "
908 PRINT "D2 = ";
910 IF (DataByte AND 4) = 4 THEN PRINT "HIGH" ELSE PRINT "LOW "
912 PRINT "D3 = ";
914 IF (DataByte AND 8) = 8 THEN PRINT "HIGH" ELSE PRINT "LOW "
916 PRINT "D4 = ";
918 IF (DataByte AND 16) = 16 THEN PRINT "HIGH" ELSE PRINT "LOW "
920 PRINT "D5 = ";
922 IF (DataByte AND 32) = 32 THEN PRINT "HIGH" ELSE PRINT "LOW "
924 PRINT "D6 = ";
926 IF (DataByte AND 64) = 64 THEN PRINT "HIGH" ELSE PRINT "LOW "
928 PRINT "D7 = ";
930 IF (DataByte AND 128) = 128 THEN PRINT "HIGH" ELSE PRINT "LOW "
932 RETURN: REM   end of subroutine, display data
934 SYSTEM


