
1   REM  FILE: HALFSTEP.BAS,  WRITTEN IN QBASIC
2   REM
3   REM  Printer port control stepping motor using HALF STEP code logic
7   REM
100  T = 500
102 Motor(1) = 3:  REM 00000011
104 Motor(2) = 2:  REM 00000010
106 Motor(3) = 6:  REM 00000110
108 Motor(4) = 4:  REM 00000100
110 Motor(5) = 12: REM 00001100
112 Motor(6) = 8:  REM 00001000
114 Motor(7) = 9:  REM 00001001
116 Motor(8) = 1:  REM 00000001
137 REM
138 REM   %%%%%%%%%%%%%%%%%%% -=[ METHOD ONE ]=- %%%%%%%%%%%%%%%%%%%%%%%%%%
140 REM
142 REM  Semicolens at end of LPRINT statement tells BASIC to not add
145 REM  carrage return and line feed to transmitted data.
147 REM
150 FOR E = 1 TO 10: REM  step 40 full steps in clockwise direction using
155 FOR D = 1 TO 8
160 LPRINT CHR$(Motor(D)); : GOSUB 500
170 NEXT D: NEXT E
210 FOR E = 1 TO 10: REM step motor 40 steps in counter-clockwise direction
220 FOR D = 8 TO 1 STEP -1
230 LPRINT CHR$(Motor(D)); : GOSUB 500
240 NEXT D: NEXT E
270 REM
280 REM  %%%%%%%%%%%%%%%%%%%%%%%%  -=[ METHOD TWO ]=- %%%%%%%%%%%%%%%%%%%%%%
282 REM
283 REM   This method permits sending control signals to LPT1, LPT2, and LPT3
290 REM
300 GOSUB 600: REM   get port's base address
310 FOR E = 1 TO 10: REM  step motor clockwise through 40 steps
320 FOR D = 1 TO 8
340 OUT LptPortAddress, Motor(D): GOSUB 500
370 NEXT D: NEXT E
380 FOR E = 1 TO 10: REM step motor counterclockwise through 40 steps
390 FOR D = 8 TO 1 STEP -1
400 OUT LptPortAddress, Motor(D): GOSUB 500
410 NEXT D: NEXT E
499 END
500 REM  -=[ delay ]=-
510 FOR V = 1 TO T: NEXT V
520 RETURN
600 REM
605 PRINT
610 PRINT " Which printer port do you want to use? "
620 PRINT "             1) LPT1"
630 PRINT "             2) LPT1"
640 PRINT "             3) LPT3"
650 n = VAL(INPUT$(1))
670 IF (n < 1) OR (n > 3) THEN GOTO 605
675 DEF SEG = 0
680 OffSet = (n * 2) + 6: Address = 1024 + OffSet
690 LptPortAddress = PEEK(Address) + (PEEK(Address + 1) * 256)
700 RETURN







