
OLDMETHOD       equ     0       ; True if allowing old ctv_halt procedure.
;; CTV_HALT your method locks up if you run PEND PEND.SND

	P386
;; 3.0  -> stereo rev.
;; 3.1	-> version number rev, semaphore reporting.
;; 3.11 -> fixed bug halting looped sample, when looped sample wasn't playing.
;; 3.12 -> got rid of the int 3 instructions accidently left in sblaster.
;; 3.2	-> auto-init dma mode functions.
;; 3.3	-> auto-init dma on SBLASTER cards, as well as SB16 support.
;; 3.4	-> 32 bit register passing support.

VERSION_NUMBER	equ	340

        LOCALS                  ;; Enable local labels

        IDEAL                   ;; Use Turbo Assembler's IDEAL mode
	JUMPS

        INCLUDE "PROLOGUE.MAC"          ;; common prologue
	INCLUDE "SOUNDRV.INC"

;; Set's the DIGPAK semaphore
Macro	SetSemaphore
	mov	[cs:INDIGPAK],1
	endm

;; Clear's the semaphore, and does an IRET
Macro	ClearSemaphoreIRET
	mov	[cs:INDIGPAK],0
	iret
	endm

Macro	ClearSemaphore
	mov	[cs:INDIGPAK],0
	endm

Macro   SET_DS                          ; Saves DS and sets DS = CS
        push    ds
        push    cs
        pop     ds
        endm

Macro   RESTORE_DS
        pop     ds
        endm

Macro   INISR
        push    es                      ; Save      {    are used
        push    ds
        push    di
        push    si
        push    cx
        push    bx
        cld
        mov     ax,cs
        mov     es,ax
        mov     ds,ax                   ; Establish data addressability.
        endm

Macro   OUTISR
        pop     bx
        pop     cx
        pop     si
        pop     di
        pop     ds
        pop     es
        endm

Macro   PUSH_ALL
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
	endm

Macro   POP_ALL
        pop     di
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
	endm

Macro	ConvertDPMI seg,indx
	LOCAL	@@HOP
	cmp	[cs:DPMI],0	; In 32 bit DPMI mode?
	je	@@HOP
	push	eax		; Save EAX
	mov	eax,indx	; Get the entire 32 bit flat-model address.
	shr	eax,4		; leave just the segment portion.
	mov	seg,ax		 ; place the segment into DS
	and	indx,0Fh	 ; leave just the offset portion.
	pop	eax
@@HOP:
	endm


;; Set up for which of the five different 'soundblaster' variants.
;; They are SBLASTER
;;	    SBPRO
;;	    SB16
;;	    STFX
;;	and SBCLONE

IFNDEF  SBPRO
SBPRO           equ     0
ENDIF

IFNDEF  SB16                            ;SB16
SB16            equ     0
ENDIF

IFNDEF  STFX
STFX            equ     0
ENDIF

IFNDEF  SBCLONE
SBCLONE 	equ	0
ENDIF

IFNDEF SBLASTER
SBLASTER	equ	0
ENDIF

DIG_SBLASTER	equ	1

KINT	equ	66h		; Software interrupt vector for DIGPAK

SEGMENT  _TEXT PARA PUBLIC 'CODE'
ENDS

	ASSUME	CS: _TEXT, DS: _TEXT, SS: NOTHING, ES: NOTHING


SEGMENT _TEXT
	org	100h
START:
	jmp	LoadSound		; Load the digitized sound driver
	db	"DIGPAK",0,13,10        ; Digitized Sound Package Identity String
IDENTIFIER:
IF	SB16
        db      "Sound Blaster 16",0,13,10
ENDIF
IF      SBPRO
        db      "Sound Blaster Pro",0,13,10
ENDIF
IF	STFX
	db	"ATI Stereo FX",0,13,10
ENDIF
IF	SBCLONE
	db	"Sound Blaster CLONE",0,13,10
ENDIF
IF	SBLASTER
	db	"Sound Blaster - Creative Labs",0,13,10
ENDIF
	db	"The Audio Solution, Copyright (c) 1994",0,13,10
	db	"Written by John W. Ratcliff",0,13,10
	org	200h		; Beginning address of jumps.
	jmp	InstallInterupt 	; Install the interupt vector.
	jmp	DeInstallInterupt	; De-install the interupt.

IF      SB16
_io_addx        dw      220h            ; TEST!
_intr_num       dw      -1              ; read from board
_dma_channel    dw      -1              ; read from board
_dma_channel_16 dw      -1              ; read from board
ELSE
_io_addx	dw	220h		; TEST!
_intr_num       dw      7               ; Default is interupt #5 (Feb 93)
_dma_channel	dw	1		; default DMA is ONE!
ENDIF

JumpTable	dw	offset	FUNCT1
		dw	offset	FUNCT2
		dw	offset	FUNCT3
		dw	offset	FUNCT4
		dw	offset	FUNCT5
		dw	offset	FUNCT6
		dw	offset	FUNCT7
		dw	offset	FUNCT8
		dw	offset	FUNCT9
		dw	offset	FUNCTA
		dw	offset	FUNCTB
		dw	offset	FUNCTC
		dw	offset	FUNCTD
		dw	offset	FUNCTE
		dw	offset	FUNCTF
		dw	offset	FUNCT10
		dw	offset	FUNCT11
		dw	offset	FUNCT12
		dw	offset	FUNCT13
		dw	offset	FUNCT14
		dw	offset	FUNCT15 ; Set DMA backfill mode.
		dw	offset	FUNCT16 ; Report DMAC count.
		dw	offset	FUNCT17 ; Verify DMA block.
		dw	offset	FUNCT18 ; Set PCM volume.
		dw	offset	FUNCT19 ; set 32 bit register mode on.

BACKF		dw	0	; Backfill defaults to off

JumpPtr 	dw	?
_voice_status	dw	0
_lastIntFlag    dw      0
CallBacks	dw	0	; Callback to application flag.
LABEL		CALLBACK	DWORD	     ; Callback address label.
CallLow 	dw	0	; Low word of callback address.
CallHigh	dw	0	; High word of callback address.
CallDS		dw	0	; Value of DS register at callback time.

RecordMode	dw	0	; set audio recording flag.
PlayMode	dw	PCM_8_MONO	; Default play mode is 8 bit PCM.

DPMI		dw	0

currentBuf	db	1	;SES - current buffer half being played
maxVol		dw	0	;SES - left & right volume settings

;; Data used by Kernel interrupt
KJUMP	FARPTR	<>		; Address
OLDIN	FARPTR	<>		; Original interupt vector.
ID      db      'KERN'          ; 4B45524Eh Interupt identifier string.
IND     db      'KR'            ; 4B52h indicates a kernel installed interupt.
Proc	SoundInterupt far
;;; Usage: DS:SI -> point to sound structure to play.
;; FUNCT1  AX = 0688h	 DigPlay
;; FUNCT2  AX = 0689h	 Sound Status
;; FUNCT3  AX = 068Ah	 Massage Audio
;; FUNCT4  AX = 068Bh	 DigPlay2, pre-massaged audio.
;; FUNCT5  AX = 068Ch	 Report audio capabilities.
;; FUNCT6  AX = 068Dh	 Report playback address.
;; FUNCT7  AX = 068Eh	 Set Callback address.
;; FUNCT8  AX = 068Fh	 Stop Sound.
;; FUNCT9  AX = 0690h	 Set Hardware addresses.
;; FUNCTA  AX = 0691h	 Report Current callback address.
;; FUNCTB  AX = 0692h	 Restore hardware vectors.
;; FUNCTC  AX = 0693h	 Set Timer Divisor Sharing Rate
;; FUNCTD  AX = 0694h	 Play preformatted loop
;; FUNCTE  AX = 0695h	 Post Pending Audio
;; FUNCTF  AX = 0696h	 Report Pending Status
;; FUNCT10 AX = 0697h	 Set Stereo Panning value.
;; FUNCT11 AX = 698h	 Set DigPak Play mode.
;; FUNCT12 AX = 699h	 Report Address of pending status flag.
;; FUNCT13 AX = 69Ah	 Set Recording mode 0 off 1 on.
;; FUNCT14 AX = 69Bh	 StopNextLoop
;; FUNCT15 AX = 69Ch	 Set DMA backfill mode.
;; FUNCT16 AX = 69Dh	 Report current DMAC count.
;; FUNCT17 AX = 69Eh	 Verify DMA block.
;; FUNCT18 AX = 69Fh	 Set PCM volume.
;; FUNCT19 AX = 6A0h	 Set DPMI mode

	cmp	ax,0688h
	jb	@@CHAIN
	cmp	ax,06A0h
	ja	@@CHAIN

	SetSemaphore		; Set the inside DigPak semaphore
	sti

	sub	ax,0688h
	shl	ax,1
	add	ax,offset JumpTable
	xchg	ax,bx
	mov	bx,[cs:bx]
	xchg	ax,bx
	mov	[cs:JumpPtr],ax
	jmp	[cs:JumpPtr]	;; Near jump will be modified!!
@@CHAIN:
	cmp	[cs:OLDIN.XPTR.POFF],0
	jne	@@CHAIN2
	cmp	[cs:OLDIN.XPTR.PSEG],0
	je	@@IRET
@@CHAIN2:
	jmp	[cs:OLDIN.DPTR] 	; Chain to original interrupt vector.
@@IRET:
	ClearSemaphoreIRET
	endp


FUNCT1:
;;**************************************************************************
;:Function #1: DigPlay, Play an 8 bit digitized sound.
;:
;:	  INPUT:  AX = 688h    Command number.
;:		  DS:SI        Point to a sound structure that
;:			       describes the sound effect to be played.
;;**************************************************************************
	PushCREGS

	ConvertDPMI ds,esi
	call	CompleteSound
	call	SetAudio
	call	PlaySound

	PopCREGS
	ClearSemaphoreIRET
FUNCT2:
;;**************************************************************************
;:Function #2: SoundStatus, Check current status of sound driver.
;:
;:	  INPUT:  AX = 689h
;:	  OUTPUT: AX = 0       No sound is playing.
;:		     = 1       Sound effect currently playing.
;;		    DX = 1	 Looping a sound effect
;;		  BX = Version numer, in decimal, times 100, so that 3.00
;;		       would be 300.  Version number begins with version 3.10
;;		       which includes the DigPak semaphore.
;;**************************************************************************
	mov	bx,VERSION_NUMBER	   ; Return VERSION NUMBER in BX! 3.40
	cmp	[cs:LOOPING],1	; Looping a sample?
	jne	@@REP
	xor	ax,ax
	mov	dx,1		; Return high word looping flag.
	ClearSemaphoreIRET
@@REP:
	mov	ax,[cs:_voice_status]
	xor	dx,dx		; Not looping
	ClearSemaphoreIRET
FUNCT3:
;;**************************************************************************
;:Function #3: MassageAudio, Preformat audio data into ouptut hardware format.
;:
;:	  INPUT:  AX = 68Ah
;:		  DS:SI        Point to address of sound structure.
;;**************************************************************************
	ClearSemaphoreIRET
FUNCT4:
;;**************************************************************************
;:Function #4: DigPlay2, Play preformatted audio data.
;:
;:	  INPUT:  AX = 68Bh
;:		  DS:SI        Point to address of sound structure.
;;**************************************************************************
	PushCREGS

	ConvertDPMI ds,esi
	call	CompleteSound
	call	DoSoundPlay
	mov	[cs:FROMLOOP],0    ; Turn from loop semephore off.
	PopCREGS

	ClearSemaphoreIRET
FUNCT5:
;;**************************************************************************
;:Function #5: AudioCapabilities, Report capabilities of hardware device.
;:
;:	  INPUT:  AX = 68Ch
;:	  OUTPUT: AX = Bit 0 -> On, supports background playback.
;:				Off, driver only plays as a foreground process.
;:		       Bit 1 -> On, source data is reformatted for output device.
;:				 Off, device handles raw 8 bit unsigned audio.
;:		       Bit 2 -> On, Device plays back at a fixed frequency, but
;:				    the audio driver will downsample input data
;:				    to fit.
;:				Off, device plays back at user specified frequency.
;:				(NOTE: You can still playback an audio sample at
;:				       whatever frequency you wish.  The driver
;:				       will simply downsample the data to fit
;:				       the output hardware.  Currently it does
;:				       not support upsampling though.)
;:		       Bit 3 -> On, this device uses the timer interrupt vector
;:				during sound playback.
;:				Off, this device does not use timer interrupt.
;:		       Bit 4 -> On, this device supports timer sharing.
;:				Off, this device doesn't support timer sharing.
;:		       Bit 5 -> On, this device supports looping and pending
;:				sounds.
;:				Off, this device doesn't support looping and
;:				pending sounds.
;:		       Bit 6 -> On, this device supports stereo panning.
;:				Off, this device doesn't support stereo panning.
;:		       Bit 7 -> On, this device can playback in stereo.
;:				Off, this device can't playback in stereo.
;:		       Bit 8 -> On, this device supports digital sound recording.
;:				Off, this device doesn't support digital sound
;:				recording.
;:		       Bit 9 -> On, this device supports DMA backfill mode
;:				(Auto-Init).
;:				Off, this device doesn't support DMA backfill
;:				mode (Auto-Init).
;:		       Bit 10-> On, this device supports 16 bit PCM data.
;:				Off, this device doesn't support 16 bit PCM data.
;:
;:		  DX = If this device plays back at a fixed frequency the DX
;:		       register will contain that fixed frequency playback rate.
;;**************************************************************************
	mov	ax,(PLAYBACK OR AUDIORECORD)
	cmp	[cs:AUTOALLOWED],1	; allowed to do auto-init DMA?
	jne	@@NOA
	or	ax,DMABACKFILL
@@NOA:
IF      SBPRO OR SB16
        or      ax,STEREOPAN            ;SB16
ENDIF
IF	STFX OR SBPRO OR SB16 OR DIG_PAUDIO  ;SB16
	or	ax,STEREOPLAY
ENDIF
IF	SB16	 ;SB16
	or	ax,PCM16		; Supports 16 bit PCM!!!
        or      ax,PCM16STEREO
ENDIF
	mov	bx,cs
	lea	cx,[IDENTIFIER]
	ClearSemaphoreIRET
FUNCT6:
;;**************************************************************************
;:Function #6: OBSOLETE FUNCTION
;;**************************************************************************
	xor	ax,ax		; Should compute aproximation!
	ClearSemaphoreIRET
FUNCT7:
;;**************************************************************************
;:Function #7: SetCallBackAddress, sets a user's sound completion
;:		       callback addess.
;:
;:	  INPUT: AX = 068Eh
;:		 BX = Offset portion of far procedure to callback.
;:		 DX = Segment portion of far procedure to callback.
;:		 DS = Data Segment register value to load at callback time.
;:	  OUTPUT: None.
;:
;:		 This function allows the user to specify a callback
;:		 address of a far procedure to be invoked when a sound
;:		 effect has completed being played.  This function is
;:		 disabled by default.  Sending a valid address to this
;:		 function will cause a callback to occur whenever a sound
;:		 sample has completed being played.  The callers DS register
;:		 will be loaded for him at callback time.  Be very careful
;:		 when using this feature.  The application callback procedure
;:		 is being invoked typically during a hardware interupt.
;:		 Your application should spend a small an amount of time
;:		 as possible during this callback.  Remember that the
;:		 callback must be a far procedure.  The sound driver
;:		 preserves ALL registers so your callback function does
;:		 not need to do so.  Do not perform any DOS functions
;:		 during callback time because DOS is not re-entrent.
;:		 Keep in mind that your own application has been interupted
;:		 by the hardware it this point.  Be very careful when making
;:		 assumptions about the state of your application during
;:		 callback time.  Hardware callbacks are generally used
;:		 to communicate sound event information to the application
;:		 or to perform a technique called double-buffering, whereby
;:		 your application immediatly posts another sound effect to
;:		 be played at the exact time that the last sound effect
;:		 has completed.
;:
;:		 WARNING!!! Be sure to turn off hardware callbacks when
;:		 your application leaves!!! Otherwise, harware callbacks
;:		 will be pointing off into memory that no longer contains
;:		 code.	This function is for advanced programmers only.
;;**************************************************************************
	or	bx,bx
	jnz	@@SC1
	or	dx,dx
	jnz	@@SC1
	xor	ax,ax
	mov	[cs:CallBacks],ax		; Callbacks disabled.
	mov	[cs:CallLow],ax 		; Low address.
	mov	[cs:CallHigh],ax
	jmp	@@EXIT
@@SC1:	mov	[cs:CallLow],bx
	mov	[cs:CallHigh],dx
	mov	[cs:CallDS],ds
	mov	[cs:CallBacks],1
@@EXIT:
	ClearSemaphoreIRET
FUNCT8:
;;**************************************************************************
;:Function #8: StopSound, stop currently playing sound.
;:
;:	  INPUT: AX = 68Fh
;:	  OUTPUT: None.
;:
;:		Will cause any currently playing sound effect to be
;:		terminated.
;;**************************************************************************
	mov	[cs:PENDING],0	; Turn pending flag OFF when stop-sound called.
	mov	[word cs:LOOPING],0
	call	StopSound
	ClearSemaphoreIRET
FUNCT9:
;;**************************************************************************
;:Function #9: OBSOLETE FUNCTION
;;**************************************************************************
	ClearSemaphoreIRET
FUNCTA:
;;**************************************************************************
;;FUNCTION #10: ReportCallbackAddress
;;
;;	  INPUT: AX = 691h
;;	  OUTPUT: AX:DX -> far pointer to current callback address.
;;		  BX -> original caller's DS register.
;;
;;	  This function should probably never need to be used by your
;;	  application software.  It is provided because the MIDPAK,
;;	  MIDI driver, needs to revector hardware callbacks so that
;;	  it can handle hardware contention problems between digitized
;;	  sound playback and synthesized sound playback.
;;**************************************************************************
	mov	ax,[cs:CallLow]
	mov	dx,[cs:CallHigh]
	mov	bx,[cs:CallDS]
	ClearSemaphoreIRET
FUNCTB:
;;**************************************************************************
;;FUNCTION #11: RestoreHardware
;;
;;	  INPUT: AX = 692h
;;	  OUTPUT:
;;
;;		Put hardware back to initial state.  Invoked by the
;;		DeInstall code.  Not to be called by an application program!
;;**************************************************************************
        mov     [cs:CallBacks],0
	mov	[word cs:CallBack],0
	mov	[word cs:CallBack+2],0
	push	ds
	push	cs
	pop	ds
	call	_ctv_uninstall
	pop	ds
	ClearSemaphoreIRET
FUNCTC:
;;**************************************************************************
;; FUNCTION #12: SetTimerDivsorRate
;;
;;	   INPUT: AX = 693h
;;		  DX = Countdown timer divisor rate, so that timer based
;;		       drivers can service application timer interrupts
;;		       at their previous rate.	Service rate will be an
;;		       aproximation, that is fairly close.  To reset timer
;;		       divisor to default of 18.2 pass a 0 in the DX register.
;;**************************************************************************
	ClearSemaphoreIRET
FUNCTD:
;;**************************************************************************
;; FUNCTION #13: DigPlayLoop
;;
;;	   INPUT: AX = 694h
;;		  DS:SI ->sound structure, preformated data.
;; Here's the process...
;;	Remember the current callback address.
;;	Set new callback address to US!
;;	Save sound structure.
;;	Call DigPlay.
;;	At call back, keep playing.
;;	This gets done until StopSound is called.
;;	Stop sound checks to see if we need to restore the callback address.
;;	If PlaySound is invoked, and we are currently looping a sound then
;;	stopsound is invoked.
;;**************************************************************************
	PushAll 	; Save all registers.
	ConvertDPMI ds,esi
	push	cs
	pop	es
	lea	di,[LOOPSND]
	mov	cx,SIZE LOOPSND
	rep	movsb
	mov	ax,068Fh	; Stop any currently playing sound.
	int	66h		; do it.
	mov	[cs:LOOPING],1	   ; We are now looping a sound sample.
	mov	ax,cs
	mov	ds,ax
	mov	dx,ax		;
	mov	ax,068Eh
	lea	bx,[LoopBack]	;
	int	66h		; Set loop callback.
	PopAll
	push	cs
	pop	ds
	lea	si,[LOOPSND]
	mov	[word cs:LOOPSOUND],si
	mov	[word cs:LOOPSOUND+2],ds
	mov	[cs:FROMLOOP],1 ; Set from looping semephore
	mov	ax,068Bh	; Do FUNCT4
	jmp	FUNCT4		; Do a DigPlay2
FUNCTE:
;;**************************************************************************
;; FUNCTION #14: PostAudioPending
;;
;;	   INPUT: AX = 695h
;;		  DS:SI ->sound structure, preformated data.
;;	   OUTPUT: AX = 0  Sound was started playing.
;;		   AX = 1  Sound was posted as pending to play.
;;**************************************************************************
	PushCREGS
	ConvertDPMI ds,esi
	cli    ; Turn off interupts while making this determination.
	mov	ax,[cs:_voice_status]
	or	ax,ax		; Currently playing a sound?
	jnz	@@POST		; yes->try to post pending.
	sti			; We can play it now.
	call	DoSoundPlay	;
	xor	ax,ax		; Return, audio sample is now playing.
	PopCREGs
	ClearSemaphoreIRET
@@POST: cmp	[cs:PENDING],1	; Already have a pending sound effect?
	jne	@@POST2 	; no, post it for pending play.
	mov	ax,2		; return code of two.
	PopCREGS
	ClearSemaphoreIRET
@@POST2:mov	[cs:PENDING],1
	push	es
	push	di
	push	cs
	pop	es
	lea	di,[PENDSND]	; Pending sound.
	mov	cx,SIZE PENDSND
	rep	movsb
	mov	[cs:PENDING],1
	mov	[cs:CallBacks],1
	mov	[word cs:CallBack],offset PlayPending
	mov	[word cs:CallBack+2],cs
	mov	[word cs:CallDS],cs
	pop	di
	pop	es
	mov	ax,1		; Posted as pending.
	PopCREGS
	ClearSemaphoreIRET
FUNCTF:
;;**************************************************************************
;; FUNCTION #15: Report Pending Status
;;
;;	   INPUT: AX = 696h
;;	  OUTPUT: AX = 0 No sound is playing.
;;		  AX = 1 Sound playing, sound pending.
;;		  AX = 2 Sound playing, no sound pending.
;;**************************************************************************
	cli		; Clear interrupts while we make this determination.
	mov	ax,[cs:_voice_status]
	or	ax,ax		; Currently playing a sound?
	jnz	@@POST		; yes->try to post pending.
	ClearSemaphoreIRET
@@POST: cmp	[cs:PENDING],1	; Have a sound pending?
	je	@@PEND		; yes, return pending status.
	mov	ax,1		; Sound is playing, but no sound is pending.
	ClearSemaphoreIRET
@@PEND:
	mov	ax,2
	ClearSemaphoreIRET
FUNCT10:
;;**************************************************************************
;; FUNCTION #16: SetStereoPan
;;
;;	 INPUT: AX = 697h
;;		DX = stereo pan value. 0 full volume right.
;;				      64 full volume both.
;;				     127 full volume left.
;;	 OUTPUT: AX = 0 command ignored, driver doesn't support stereo panning.
;;		 AX = 1 pan set.
;;
;;	 This function will pan using the current mixer settings available
;;	 when initializing the driver.	It will not corrupt the current
;;	 balance set by the user or the Set PCM Volume function (#24).
;;**************************************************************************
	xor	ax,ax			; Default - doesn't support stereo panning.

IF      SBPRO OR SB16
	push	cx
	mov	cl, 126
	mov	ax, dx			; move pan position to AX
	mov	dx, [cs:maxVol] 	; get current volume levels excluding pan offsets
	cmp	ax,64			; full volume right?
	jge	@@other 		; other case.

	mul	dh			; pan pos. * max left ch.
	shl	ax, 1			; pan pos. * max left ch. * 2
	add	ax, 63			; pan pos. * max left ch. * 2 + 63
	div	cl			; (pan pos. * max left ch. * 2 + 63) / 126
	mov	ah, al			; left channel = AH
	mov	al, dl			; right channel = AL = full volume
	jmp short @@SETV

@@other:
	mul	dl			; pan pos. * max right ch.
	shl	ax, 1			; pan pos. * max right ch. * 2
	add	ax, 63			; pan pos. * max right ch. * 2 + 63
	div	cl			; (pan pos. * max right ch. * 2 + 63) / 126
	xchg	dl, al			; result => DL, max right ch. => AL
	sub	al, dl			; max right ch. - result
	mov	ah, dh			; left channel = AH = full volume
@@SETV:
IF      SBPRO
	mov	cl, 4
	shr	al, cl			; new right volume scaled to 4 bits
	and	ah, 0f0h		; new left volume scaled to 4 bits
	or	al, ah			; high nibble = left, low nibble = right
	mov	dx,[cs:_io_addx]	; Base I/O address of sound blaster.
	add	dx,4			; Point to mixer address port.
	mov	ah,al			; Save volumes
	mov	ax,04h			; Select voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,ah			; Get volume computed.
	inc	dx			; Select data port
	out	dx,al			; Send volumes
	mov	ax,1			; Return volume set.
ELSE
	mov	cl, 3
	shr	al, cl			; new right volume scaled to 5 bits
	shr	ah, cl			; new left volume scaled to 5 bits
	mov	dx,[cs:_io_addx]	; Base I/O address of sound blaster.
	add	dx,4			; Select mixer address port.
	mov	bx, ax			; Save volumes
	mov	al,32h			; Select left voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,bh			; Get left volume computed.
	inc	dx			; Select mixer data port
	out	dx,al			; Send left volume
	dec	dx			; Select mixer address port
	mov	al,33h			; Select right voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,bl			; Get right volume computed.
	inc	dx			; Select mixer data port
	out	dx,al			; Send right volume
	mov	ax,1			; Return volume set.
ENDIF
	pop	cx
ENDIF

	pop cx
	ClearSemaphoreIRET

FUNCT11:
;;**************************************************************************
;; FUNCTION #17: SetPlayMode
;;
;;	   INPUT: AX = 698h
;;		  DX = Play Mode function.
;;                        DX = 0 -> 8 bit PCM mono.
;;                           = 1 -> 8 bit PCM stereo.
;;                           = 2 -> 16 bit PCM mono.
;;			     = 3 -> 16 bit PCM stereo.
;;
;;	 OUTPUT: AX = 1 -> mode set.
;;		 AX = 0 -> mode not supported by this driver.
;;
;;**************************************************************************
	cmp	dx,PCM_8_MONO	; ALL drivers support 8 bit PCM mono sound.
	je	@@OK

;; SB16 support 16 bit stereo sound.
IF	SB16
	cmp	dx,PCM_16_STEREO
	je	@@OK
ENDIF

;; SB16 support 16 bit mono sound.
IF	SB16
	cmp	dx,PCM_16_MONO
	je	@@OK
ENDIF

;; All sound cards that support 8 bit stereo PCM
IF	STFX OR SBPRO OR SB16
	cmp	dx,PCM_8_STEREO
	je	@@OK
ENDIF
	jmp	@@NOT			; Non supported sound playback mode.
@@OK:	mov	[cs:PlayMode],dx
        mov     ax,1                    ; Set!
	ClearSemaphoreIRET
@@NOT:
	xor	ax,ax
	ClearSemaphoreIRET

FUNCT12:
;;**************************************************************************
;; FUNCTION #18: Report Address of Pending Flag
;;
;;	   INPUT: AX = 699h
;;
;;	 OUTPUT: AX:DX -> form far address of pending status flag.
;;		 BX:DX -> form address of DigPak interrupt semaphore.
;;
;;**************************************************************************
	mov	dx,cs			; Code segment.
	lea	ax,[PENDING]		; Address of pending flag.
	lea	bx,[INDIGPAK]		; Address of semaphore address.
	ClearSemaphoreIRET

FUNCT13:
;;**************************************************************************
;; FUNCTION #19: Set audio recording mode.
;;
;;	   INPUT: AX = 69Ah
;;		  DX = 0 turn audio recording ON.
;;		     = 1 turn audio recording OFF.
;;
;;	 OUTPUT: AX = 0 sound driver doesn't support audio recording.
;;		 AX = 1 audio recording mode is set.
;;
;;**************************************************************************
	mov	[cs:RecordMode],dx
	mov	ax,1
	ClearSemaphoreIRET

FUNCT14:
;;**************************************************************************
;; FUNCTION #20: StopNextLoop
;;
;;	   INPUT: AX = 69Bh
;;
;;	   OUTPUT: NOTHING, Stop Looped sample, next time around.
;;
;;**************************************************************************
	mov	[cs:CallBacks],0
	mov	[cs:LOOPING],0
	ClearSemaphoreIRET
FUNCT15:
;;**************************************************************************
;; FUNCTION #21: Set DMA back fill mode.
;;
;;	   INPUT: AX = 69Ch
;;		  DX = backfill mode 0 means turn it off.
;;		       and a 1 means to turn it on.
;;
;;	   OUTPUT: AX = 1 -> back fill mode set.
;;			0 -> driver doesn't support DMA backfill.
;;
;;**************************************************************************
	push	ds
	push	di
	push	si

	push	cs
	pop	ds		; DS=CS

	push	dx
	mov	dx, [cs:_voice_status]
	call	StopSound
	pop	dx

	mov	[cs:BACKF],dx

	mov	ax,1			; Back fill mode was set.

	pop	si
	pop	di
	pop	ds
	ClearSemaphoreIRET
FUNCT16:
;;**************************************************************************
;; FUNCTION #22: Report current DMAC count.
;;
;;	   INPUT: AX = 69Dh
;;
;;	   OUTPUT: AX = Current DMAC count.
;;
;;**************************************************************************
	call	ReportDMAC
	ClearSemaphoreIRET
FUNCT17:
;;**************************************************************************
;; FUNCTION #23: Verify DMA block, check to see if it crosses a 64k page
;;		 boundary for the user.
;;
;;	   INPUT: AX = 69Eh
;;		  ES:BX -> address of sound.
;;		  CX	-> length of sound effect.
;;
;;	   OUTPUT: AX = 1 Block is ok, DOESN'T cross 64k bounadary.
;;		   AX = 0 block failed, DOES cross 64k boundary.
;;
;;**************************************************************************
	PushCREGS
	ConvertDPMI es,ebx
	push	cx
	push	es
	push	bx
	call	CheckBoundary
	add	sp,6
	PopCREGS
	ClearSemaphoreIRET

FUNCT18:
;;**************************************************************************
;; FUNCTION #24: Set PCM volume.
;;
;;	   INPUT: AX = 69Eh
;;		  BX = Left channel volume (or both if mono) 0-255
;;		  CX = Right channel volume (or both if mono) 0-255
;;
;;	   OUTPUT: AX = 1 Volume set
;;		   AX = 0 Device doesn't support volume setting.
;;
;;**************************************************************************
	xor	ax,ax			; Default, volume not set.
IF	SBPRO OR SB16
	push	dx

	mov	al,cl			; Get right volume.
	mov	ah,bl			; Get right volume.
	mov	[cs:maxVol], ax 	; Save volume for max panning values

IF	SBPRO
	mov	cl, 4
	shr	al, cl			; new right volume scaled to 4 bits
	and	ah, 0f0h		; new left volume scaled to 4 bits
	or	al, ah			; high nibble = left, low nibble = right
	mov	dx,[cs:_io_addx]	; Base I/O address of sound blaster.
	add	dx,4			; Point to mixer address port.
	mov	ah,al			; Save volumes
	mov	ax,04h			; Select voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,ah			; Get volume computed.
	inc	dx			; Select data port
	out	dx,al			; Send volumes
ELSE
	mov	cl, 3
	shr	al, cl			; new right volume scaled to 5 bits
	shr	ah, cl			; new left volume scaled to 5 bits
	mov	dx,[cs:_io_addx]	; Base I/O address of sound blaster.
	add	dx,4			; Select mixer address port.
	mov	bx, ax			; Save volumes
	mov	al,32h			; Select left voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,bh			; Get left volume computed.
	inc	dx			; Select mixer data port
	out	dx,al			; Send left volume
	dec	dx			; Select mixer address port
	mov	al,33h			; Select right voice volume register
	out	dx,al			; Send it.
	jmp	$+2
	mov	al,bl			; Get right volume computed.
	inc	dx			; Select mixer data port
	out	dx,al			; Send right volume
ENDIF
	mov	ax,1			; Return volume set.
ENDIF
	ClearSemaphoreIRET
FUNCT19:
	mov	[cs:DPMI],dx
	ClearSemaphoreIRET


Macro  GET20BIT
       PUSH   CX
       MOV    CL,4
       ROL    DX,CL
       MOV    CX,DX
       AND    DX,0FH
       AND    CX,0FFF0H
       ADD    AX,CX
       ADC    DX,0
       POP    CX
       endm

Proc	CheckBoundary	near
	ARG	SOURCE:DWORD,SLEN:WORD
	PENTER	0

	mov	ax,[word SOURCE]
	mov	dx,[word SOURCE+2]
	GET20BIT			; Into 20 bit mode.
	mov	bx,dx			; Save DMA page.
	mov	ax,[word SOURCE]
	mov	dx,[word SOURCE+2]
	add	ax,[SLEN]		; Point to end.
	GET20BIT
	mov	ax,1			; Default is OK.
	cmp	bl,dl			; Same DMA page?
	je	@@OK
	xor	ax,ax			; Didn't work.
@@OK:
	PLEAVE
	ret
	endp


Proc	PlayPending	far
        cmp     [PENDING],1             ; Pending?
	jne	@@not
	mov	[PENDING],0
	mov	[cs:CallBacks],0	; No longer have one pending..
        lea     si,[PENDSND]            ; Address of pending sound.
        call    DoSoundPlay             ; Do a sound play call.
	ret
@@not:
	mov	[cs:CallBacks],0	; Disable callbacks.
	ret
	endp

Proc	DoSoundPlay	near
        PushCREGS                       ; Save all of the important C registers.
	call	SetAudio
	call	PlaySound		; Restore important C registers.
	PopCREGS
	ret
	endp


Proc	CheckCallBack	near
	cmp	[cs:CallBacks],0	; Callbacks enabled?
	je	@@GOUT		; no, exit.
	PushAll 		; Save all registers
	mov	ds,[cs:CallDS]	; Get DS register.
	call	[cs:CallBack]	; far call to application.
	PopAll			; Restore all registers.
@@GOUT:
	ret
	endp

INDIGPAK	dw	0	; Inside DigPak semaphore.

FROMLOOP	dw	0
SAVECALLBACK	dd	?	; Saved callback address.
SAVECALLDS	dw	?
LOOPING 	dw	0	; True if we were looping.

LOOPSOUND	dd	?
LOOPSND 	SOUNDSPEC	<>

PENDING 	dw	0	; True, when second sound sample is pending.
PENDSND         SOUNDSPEC <>    ; Sound structure of pending sound.

Proc	LoopBack	far
	mov	ax,068Bh	; Play preformated data.
	mov	[cs:FROMLOOP],1
	lds	si,[LOOPSOUND]	;
	int	66h		; Start playing the sound again.
	ret
	endp

Proc    SetAudio        near
	mov	[ds:(SOUNDSPEC ptr si).ISPLAYING.XPTR.POFF],offset _voice_status
	mov	[ds:(SOUNDSPEC ptr si).ISPLAYING.XPTR.PSEG],cs
	les	bx,[ds:(SOUNDSPEC ptr si).PLAYADR.DPTR]
	mov	cx,[ds:(SOUNDSPEC ptr si).PLAYLEN]
	mov	dx,[ds:(SOUNDSPEC si).FREQUENCY]
	push	cs
	pop	ds		; DS = Code group.
	ret
	endp

Proc	EndLoop near
	mov	[cs:CallBacks],0	;
	mov	[word cs:CallBack],0
	mov	[word cs:CallBack+2],0
	mov	[word cs:LOOPING],0
	call	StopSound
	ret
	endp

Proc	CompleteSound	near
	cmp	[cs:FROMLOOP],1    ; In loop callback?
	jne	@@YES
	call	EndLoop 	; don't wait for loop to complete, end it!
@@YES:
@@WT:	cmp	[cs:_voice_status],0	 ; Wait until last sound completed.
	jne	@@WT
	ret
	endp

	IDEAL
	JUMPS

;======================================================================
;======================================================================
;======================================================================
;** FINDSBLASTER
SMALL_MODEL     equ     1

Macro	CPROC	name		; Macro to establish a C callable procedure.
	public	_&name
IF	SMALL_MODEL
Proc	_&name	near
ELSE
Proc	_&name	far
ENDIF
	endm



ORG_INT_ADDX    DD      ?       ; Original IRQ address.
INT2            DD      ?       ; Holds address of original interrupt vectors.
INT3            DD      ?       ; Which we steal to perform autodection.
INT5            DD      ?
INT7            DD      ?

;---------------------
;      DMA DATA      |
;---------------------
DMA_CURRENT_PAGE    DB     ?            ; Current DMA page we are transmitting.
DMA_CURRENT_ADDX    DW     ?            ; Current DMA low word addresss.
DMA_CURRENT_COUNT   DW     ?            ; DMA current page count.
PAGE_TO_DMA         DB     ?
LEN_L_TO_DMA        DW     ?
LEN_H_TO_DMA        DW     ?
LAST_DMA_OFFSET     DW     ?

PRO_STOP_TIME       EQU    2000H        ; delay after reset when stopping the
                                        ;  SBPRO in stereo playback
WAIT_TIME           EQU    0FFFFH
DMA_VOICE_IN        EQU    44H
DMA_VOICE_OUT       EQU    48H
DMA_VOICE_IN_AI     EQU    54H
DMA_VOICE_OUT_AI    EQU    58H

DSP_ID_CMD          EQU    0E0H
DSP_VER_CMD         EQU    0E1H
DSP_VO8_CMD         EQU    14H
DSP_VI8_CMD         EQU    24H
DSP_VO8_AI_CMD      EQU    1CH          ; DSP auto init 8 bit.
DSP_VI8_AI_CMD      EQU    2CH          ; DSP auto init 8 bit.
DSP_VO8_HS_CMD      EQU    91H          ; DSP single-cycle high speed out
DSP_VI8_HS_CMD      EQU    99H          ; DSP single-cycle high speed in
DSP_VO8_AI_HS_CMD   EQU    90H          ; DSP auto-init high speed out
DSP_VI8_AI_HS_CMD   EQU    98H          ; DSP auto-init high speed in


DSP_TIME_CMD        EQU    40H
DSP_BLK_SIZE        EQU    48H          ;SES - used for all but low speed
                                        ;      non-auto init
DSP_HALT8_CMD       EQU    0D0H         ;SES - halts DSP immediately
DSP_ONSPK_CMD       EQU    0D1H
DSP_OFFSPK_CMD      EQU    0D3H
DSP_CONT8_CMD       EQU    0D4H
DSP_HALT8_AI_CMD    EQU    0DAH         ;SES - halts DSP after next interrupt
DSP_INT_REQ_CMD     EQU    0F2H

;; ---- SB16 commands ----
DSP16_SET_DA_RATE      EQU  41H         ;SES - followed by sample rate (LSB, MSB)
DSP16_SET_AD_RATE      EQU  42H         ;SES - followed by sample rate (LSB, MSB)
DSP16_HALT16_CMD       EQU  0D5H        ;SES - halts DSP immediately
DSP16_CONT16_CMD       EQU  0D6H        ;SES
DSP16_HALT16_AI_CMD    EQU  0D9H        ;SES - halts DSP after next interrupt

;; ----- SB16 modes -----
DSP16_8BIT             EQU  0C2H        ;SES
DSP16_16BIT            EQU  0B2H        ;SES
DSP16_SINGLE_CYCLE     EQU  0           ;SES
DSP16_AUTO_INIT        EQU  4           ;SES
DSP16_PLAYBACK         EQU  0           ;SES
DSP16_RECORD           EQU  8           ;SES

DSP16_MONO             EQU  0           ;SES
DSP16_STEREO           EQU  20H         ;SES
DSP16_UNSIGNED         EQU  0           ;SES
DSP16_SIGNED           EQU  10H         ;SES


DSP_STEREO_CMD      EQU    84H      ; DMA stereo!!

CMS_TEST_CODE       EQU    0C6H
RESET_TEST_CODE     EQU    0AAH

CMS_EXIST           EQU     1
FM_MUSIC_EXIST      EQU     2
CTV_VOICE_EXIST     EQU     4

FM_WAIT_TIME        EQU     40H

;; SoundBlaster detection code.....................

PortPossibilities   DW      220H,210H,230H,240H,250H,260H
IF SB16
IRQPossibilities    DW      10, 7 , 5, 3
DMAPossibilities    DW      7, 6, 5, -1, 3, -1, 1, 0  ;SES (-1 = invalid)
origDMA             DB      0
ENDIF

;; Initialize the sound blaster.
;;
;;	On entry: Nothing.
;;	   exit:  Carry clear, sound blaster found.
;;		  Carry set, sound blaster NOT-FOUND.
CProc	InitBlaster
	PushCREGS
        SET_DS                          ;SES - Data Segment = Code Segment
	push	cx

        call    DetectBlaster           ; see if there
	jz	@@FOUND
        stc
        mov     ax,1
        jmp     @@ERR                   ; exit, with error condition.  (short)
@@FOUND:
IF SB16
        xor     ah, ah                  ; zero it out
        mov     dx,[_io_addx]           ; Base I/O address of sound blaster
        add     dx,4                    ; Select mixer address port

        ;; Get IRQ number
        mov     al, 80h                 ; Select IRQ detect register
        out     dx, al
        inc     dx                      ; Select mixer data port
        in      al, dx                  ; Get current IRQ bit
        and     al, 00001111b
        mov     cx, 4
        shr     al, 1                   ; Search for IRQ
        loopnz  $-2
        mov     di, cx
        shl     di, 1
        mov     ax, [IRQPossibilities + di] ; Get current IRQ
        mov     [_intr_num], ax         ; save it

        ;; Get DMA channels
        dec     dx                      ; Select mixer address port
        mov     al, 81h                 ; Select DMA detect register
        out     dx, al
        inc     dx
        in      al, dx                  ; Get Current DMA channel bits
IF SB16
        ;; Force 16 bit DMA to use 8 bit channel (TEMP FIX!)
        mov     [origDMA], al
        and     al, 0fh
        out     dx, al
ENDIF
        ;; 8 bit DMA channel
        push    ax                      ; temp save
        and     al, 00001011b           ; Select 8 bit DMA
        mov     cx, 8
        shr     al, 1                   ; Search for 8 bit DMA
        loopnz  $-2
        mov     di, cx
        shl     di, 1
        mov     ax, [DMAPossibilities + di] ; Get current 8 bit DMA
        mov     [_dma_channel], ax      ; save it

        ;; 16 bit DMA channel
        pop     ax                      ; Get DMA channel bits
        and     ax, 11100000b
        mov     cx, 8
        shr     al, 1                   ; Search for 16 bit DMA
        loopnz  $-2
        mov     di, cx
        shl     di, 1
        mov     ax, [DMAPossibilities + di] ; Get current 8 bit DMA
        mov     [_dma_channel_16], ax   ; save it
ENDIF

;; Install interrupt vector
        mov     al,[byte _intr_num]     ;SES - moved from ctvd_output
        lea     dx,[DMA_OUT_INTR]       ;SES
        lea     bx,[ORG_INT_ADDX]       ;SES
        call    SETUP_INTERRUPT         ;SES

;; Disable MIDI interrupt on SB16.
;SES        mov     dx,[_io_addx]
;SES        add     dx,4
;SES        mov     al,83h
;SES        out     dx,al
;SES        inc     dx
;SES        mov     al,0Bh
;SES        out     dx,al                   ; disable MIDI interrupt.

	clc				; Carry clear, SB found, at IO_ADDX
@@ERR:
        pop     cx
        RESTORE_DS
	PopCREGS
	ret
	endp


;; On entry: _io_addx = to the address to search at.
;;    exit: zero condition -> sound blaster found, here.
;;	    non-zero condition, sound blaster not found.

Proc    DetectBlaster  near
        call    reset_dsp               ; Reset the DSP
        jnz     @@id90
        call    verify_io_chk
        jnz     @@id90
        call    chk_dsp_version
        jnz     @@id90
;;	  call	 verify_intr
;;	  jnz	 @@id90
        sub    ax,ax

@@id90:
	ret
	endp

;; Verify this IO address.
Proc    verify_io_chk   near
        mov     bx,2
        mov     al,DSP_ID_CMD
        call    write_dsp         ;_time
        jc      @@vio90

        mov     al,0aah
        call    write_dsp         ;_time
        jc      @@vio90

        call    read_dsp          ;_time
        jc      @@vio90

        cmp     al,055h
        jne     @@vio90

        sub     bx,bx

@@vio90:
        mov     ax,bx
        or      ax,ax
        ret
        endp

IF	0
;; Here, we verify this interrupt.
Proc	verify_intr	near
        mov     al,2
        lea     dx,[dummy_dma_int2]
        lea     bx,[INT2]               ; Storage for old address.
        call    setup_interrupt

        mov     al,3
        lea     dx,[dummy_dma_int3]
        lea     bx,[INT3]
        call    setup_interrupt

        mov     al,5
        lea     dx,[dummy_dma_int5]
        lea     bx,[INT5]
        call    setup_interrupt

        mov     al,7
        lea     dx,[dummy_dma_int7]
        lea     bx,[INT7]
        call    setup_interrupt

        mov     [_intr_num],0

        mov     al,DSP_INT_REQ_CMD
        call    write_dsp

        sub     ax,ax
        mov     cx,WAIT_TIME

@@vi10:
        cmp     [_intr_num],0
        jnz     @@vi90

        loop    @@vi10

        mov     ax,3

@@vi90:
        push    ax

        mov     al,2
        lea     bx,[INT2]
        call    restore_interrupt

        mov     al,3
        lea     bx,[INT3]
        call    restore_interrupt

        mov     al,5
        lea     bx,[INT5]
        call    restore_interrupt

        mov     al,7
        lea     bx,[INT7]
        call    restore_interrupt

        pop     ax

        or      ax,ax
	ret
	endp

ENDIF

AUTOALLOWED    dw      0

Proc	chk_dsp_version 	near
        mov     al,DSP_VER_CMD
        call    write_dsp
        call    read_dsp
        mov     ah,al
        call    read_dsp
        mov     bx,1
IF	SBCLONE OR STFX
        jmp     short @@NOAUTO          ; Never allow auto-init dma on clone cards.
ENDIF
        cmp     ax,200h                 ; If not version 2.0 and above then we
                                        ; don't support auto-init DMA!
        jb      @@NOAUTO
        mov     [AUTOALLOWED],1         ; Set auto-init dma flag allowed to true.
@@NOAUTO:
        cmp     ax,101h
        jb      @@cdv90
        sub     bx,bx
@@cdv90:
        mov     ax,bx
        or      ax,ax
        ret
        endp

;;

;------------------------------------------------------------------------;
; write_dsp : writes AL to the Sound Blaster after waiting for last
;             command to complete.
;
; Input: AL - data to write
;
; Output: Carry flag (Set = error, Clear = OK)
;------------------------------------------------------------------------; 
Proc    write_dsp       near
        push    ax
        push    cx
        push    dx

        mov     dx, [cs:_io_addx]       ; Select DSP write port
        add     dl, 0CH

        mov     cx,WAIT_TIME            ; Application wait time
        mov     ah,al                   ; Save character to send in AH.

@@WDT10:
        in      al,dx
        or      al,al
        jns     @@WDT20
        loop    @@WDT10
	stc
        jmp     short @@WDT90
@@WDT20:
	mov	al,ah
        out     dx,al                   ; Send the damned thing.
	clc
@@WDT90:

        pop     dx
        pop     cx
        pop     ax
	ret
	endp

;------------------------------------------------------------------------;
; read_dsp reads the next available data into al
;------------------------------------------------------------------------; 
Proc    read_dsp        near
        push    cx
        push    dx

        mov     dx,[cs:_io_addx]        ; Select DSP data available port
        add     dl,0EH

        mov     cx,WAIT_TIME

@@RDT10:
        in      al,dx
        or      al,al
        JS      @@RDT20

        loop    @@RDT10
        stc
        jmp     short @@RDT90

@@RDT20:
        sub     dl,4                    ; Select DSP read port
        in      al,dx
        clc

@@RDT90:
        pop     dx
        pop     cx
        ret
        endp

;------------------------------------------------------------------------;
; reset_dsp stops any process going on and places DSP in its default
; state.
;------------------------------------------------------------------------; 
Proc    reset_dsp       near

        mov     dx,[cs:_io_addx]
        add     dl,6

        mov     al,1                    ;JCM (USE THIS INSTEAD)
        out     dx,al                   ;JCM
                                        ;JCM
        mov     cx,20                   ;JCM
@@wait:
        in      al,dx                   ;JCM - wait > 3 uS
        loop    @@wait                  ;JCM
                                        ;JCM
        mov     al,0                    ;JCM - drop reset
        out     dx,al                   ;JCM

        mov     cl,20h
@@RDSP10:
        call    read_dsp
        cmp     al,0AAH
        je      @@RDSP20
        dec     cl
        jnz     @@RDSP10
        mov     ax,2
        jmp     SHORT @@RDSP90
@@RDSP20:
        sub     ax,ax
@@RDSP90:
        or      ax,ax

        ret
        endp

;-------------------------------------------------------------------------
; SETUP_DMA - determines page register, address register, count register,
;             mask register, and mode register based on selected channel.
;
; inputs: none
; output: none
;-------------------------------------------------------------------------

DMA_PAGE_REG db    87h,83h,81h,82h
IF SB16
             db    -1,8bh,89h,8ah
ENDIF

dmaChannel   db    1
dmaPageReg   db    83h
dmaAddrReg   db    02h
dmaCntReg    db    03h
dmaMaskReg   db    0ah
dmaModeReg   db    0bh
dmaFFReg     db    0ch

Proc    SETUP_DMA     near
        SET_DS                          ;SES - Data Segment = Code Segment
        push    ax
        push    bx
IF SB16
        cmp     [PlayMode],2            ; Is it 8 bit or 16 bit?
        jb      @@8BIT1
        mov     bx,[_dma_channel_16]    ; Get 16 bit DMA channel.
        cmp     bx,4                    ; 8 or 16 bit channel for 16 bit data?
        jb      @@8BIT1
;;**	    mov     [dmaMaskReg],0dch	    ; save slave 8237 mask register
;; John Miles Fix!!!!!!!!!!!!!!!!
	mov	[dmaMaskReg],0d4h	; save slave 8237 mask register
;; John Miles Fix!!!!!!!!!!!!!!!!
        mov     [dmaModeReg],0d6h       ; save slave 8237 mode register
        mov     [dmaFFReg],0d8h         ; save slave 8237 flip-flop reset reg.
        jmp     @@16BIT
ENDIF
@@8BIT1:
        mov     bx,[_dma_channel]       ; Get 8 bit DMA channel
        mov     [dmaMaskReg],0ah        ; save master 8237 mask register
        mov     [dmaModeReg],0bh        ; save master 8237 mode register
        mov     [dmaFFReg],0ch          ; save master 8237 flip-flop reset reg.
@@16BIT:
        mov     [dmaChannel],bl         ; save DMA channel
        mov     al,[DMA_PAGE_REG+bx]
        mov     [dmaPageReg],al         ; save DMA page register

        and     bl,00000011b            ; determine buffer address register
        shl     bl,1
        cmp     [dmaChannel],4          ; 8 or 16 bit channel?
        jb      @@8BIT2
        shl     bl,1                    ; buffer address register for slave
        add     bl,0C0h                 ;
@@8BIT2:
        mov     [dmaAddrReg],bl         ; save DMA buffer address register

        inc     bl                      ; determine count register
        cmp     [dmaChannel],4          ; 8 or 16 bit channel?
        jb      @@8BIT3
        inc     bl
@@8BIT3:
        mov     [dmaCntReg],bl          ; save DMA count register

        pop     bx
        pop     ax
        RESTORE_DS
        ret
        endp

;-------------------------------------------------------------------------
; PROG_DMA - programs the DMA for transfer.
;
; inputs: DH = DMA mode
;         DL = buffer page
;         AX = buffer address
;         CX = data count
; output: none
;
; note: you must call SETUP_DMA before calling this function.
;-------------------------------------------------------------------------

Proc    PROG_DMA      near
        SET_DS                          ;SES - Data Segment = Code Segment
        push    bx
        push    dx
        push    ax                      ; save buffer address
        mov     bx, dx                  ; save mode and page in BX
        xor     dh,dh                   ; clear MSB of port address

        call    STOP_DMA

        mov     dl,[dmaFFReg]           ;get flip-flop register
        out     dx,al                   ; reset the DMAC flip/flop

        pop     ax                      ; get buffer address
        mov     dl,[dmaAddrReg]
        out     dx,al                   ; send low byte of addresss to DMAC
        mov     al,ah
        out     dx,al                   ; send high byte of address to DMAC

        mov     ax, cx                  ; get data count
        mov     dl,[dmaCntReg]          ; get data count register
        out     dx,al                   ; send low byte of data count to DMAC
        mov     al,ah
        out     dx,al                   ; send high byte of data count to DMAC

        mov     al, bl                  ; get buffer page
        mov     dl, [dmaPageReg]        ; get DMAC page register
        out     dx,al                   ; send buffer page to DMAC

        mov     al,[dmaChannel]         ; get channel info
        and     al,3                    ; mod 4
        or      al,bh                   ; add in the DMA mode
        mov     dl,[dmaModeReg]         ; get DMA mode register
        out     dx,al                   ; send mode to DMAC

        pop     dx
        pop     bx
        RESTORE_DS
        ret
        endp

;-------------------------------------------------------------------------
; START_DMA - unmasks the DMA channel.
;
; inputs: none.
; output: none
;
; note: you must call SETUP_DMA and PROG_DMA before calling this function.
;-------------------------------------------------------------------------
Proc    START_DMA  near
        push    ax
        push    dx
        xor     dh,dh
        mov     al,[cs:dmaChannel]      ; get channel info for unmasking
        and     al,3                    ; mod 4
        mov     dl,[cs:dmaMaskReg]      ; get mask register
        out     dx,al                   ; mask channel ON
        pop     dx
        pop     ax
        ret
        endp

;-------------------------------------------------------------------------
; STOP_DMA - masks the DMA channel.
;
; inputs: none.
; output: none
;
; note: you must call SETUP_DMA and PROG_DMA before calling this function.
;-------------------------------------------------------------------------
Proc    STOP_DMA  near
        push    ax
        push    dx
        xor     dh,dh
        mov     al,[dmaChannel]         ; get channel info for masking
        and     al,3                    ; mod 4
        or      al,4h                   ; or mask bit on
        mov     dl,[dmaMaskReg]         ; get mask register
        out     dx,al                   ; mask channel OFF
        pop     dx
        pop     ax
        ret
        endp

;-------------------------------------------------------------------------
; ReportDMAC - determines which buffer we are currently playing.
;
; inputs: none
; output: ax - 0 if first buffer, 1/2 buffer size + 1 if second buffer
;-------------------------------------------------------------------------
Proc	ReportDMAC
        mov     ax, 1
        cmp     [cs:currentBuf], 0
        je      @@EXIT
        mov     ax, [cs:DMA_CURRENT_COUNT]
        add     ax, 3
        shr     ax, 1
@@EXIT:
        ret
	endp

;-------------------------------------------------------------------------
; CALC_20BIT_ADDX - Calculates a 20 address for use with the DMAC
;
; inputs: dx - buffer's segment
;         ax - buffer's offset
; output: dx - DMA page
;         ax - DMA offset
;-------------------------------------------------------------------------
Proc    CALC_20BIT_ADDX  near
        push    cx
        mov     cl,4
        rol     dx,cl
        mov     cx,dx
        and     dx,0FH
        and     cx,0FFF0H
        add     ax,cx
        adc     dx,0
        pop     cx
        ret
        endp


PIC0_val	db	?
PIC1_val	db	?
;-------------------------------------------------------------------------
; entry: AL = INTERRUPT NUM
;        DX = new vector ofs, seg is alway CS
;        BX = offset of store buffer
;-------------------------------------------------------------------------
Proc    SETUP_INTERRUPT  near
        SET_DS                          ;SES - Data Segment = Code Segment
        push    bx
        push    cx
        push    dx

        cli
        xor     ah,ah                   ; Zero high byte.
        mov     cl,al                   ; preserve interrupt number for use
        cmp     al,8
        jb      @@calc_vect
        add     al,60h                  ; index slave PIC vectors if IRQ > 7
@@calc_vect:
        add     al,8                    ; calculate interrupt vector addx
        shl     ax,1
        shl     ax,1
        mov     di,ax

        push    es                      ; setup and preserve interrupt

        sub     ax,ax
        mov     es,ax
        mov     ax,[es:di]
        mov     [bx],ax                 ;JCM
        mov     [es:di],dx

        mov     ax,[es:di+2]
        mov     [bx+2],ax               ;JCM
        mov     [es:di+2],cs

        pop     es

        mov     bx,1                    ; calculate mask
        shl     bx,cl
        not     bx

        in      al,0a1h
        mov     [PIC1_val],al
        and     al,bh
        out     0a1h,al
        in      al,21h
        mov     [PIC0_val],al
        and     al,bl
        out     21h,al

        sti
        pop     dx
        pop     cx
        pop     bx
        RESTORE_DS
        ret
        endp


;-------------------------------------------------------------------------
; entry: AL = INTERRUPT NUM
;        BX = offset to stored addx
;-------------------------------------------------------------------------

Proc    RESTORE_INTERRUPT   near
        cli
        SET_DS                          ;SES - Data Segment = Code Segment

        mov     cl,al

        mov     al,[PIC1_val]           ;don't kill any interrupts that were
        out     0a1h,al                 ; initially active
        mov     al,[PIC0_val]
        out     21h,al

        mov     al,cl                   ; Get back interrupt number.
        xor     ah,ah

        cmp      al,8
        jb       @@calc_vect
        add      al,60h                 ; index slave PIC if IRQ > 7
@@calc_vect:
        add     al,8                    ; calculate interrupt vector addx
        shl     ax,1
        shl     ax,1
        mov     di,ax

        push    es                      ; restore interrupt vector
        sub     ax,ax
        mov     es,ax
        mov     ax,[bx]                 ;JCM
        mov     [es:di],ax

        mov     ax,[bx+2]               ;JCM
        mov     [es:di+2],ax

        pop     es
        RESTORE_DS
        sti
        ret
        endp


Proc    DUMMY_ISR       far
LABEL   DUMMY_DMA_INT2  word
        push    dx
        mov     dl,2
        jmp     short @@OUT
LABEL   DUMMY_DMA_INT3  word
        push    dx
        mov     dl,3
        jmp     short @@OUT
LABEL   DUMMY_DMA_INT5  word
        push    dx
        mov     dl,5
        jmp     short @@OUT
LABEL   DUMMY_DMA_INT7  word
        push    dx
        mov     dl,7
@@OUT:
        push    ax
        mov     [byte cs:_intr_num],dl
        mov     dx,[cs:_io_addx]
        add     dx,0EH
        in      al,dx
        mov     al,20H
        out     20H,al                  ; Send a non specific EOI
        pop     ax
        pop     dx
        iret
        endp

MIDIINT   EQU   4                       ;SES - 3rd bit indicates 8 bit Int.

Proc	DMA_OUT_INTR	far
	SetSemaphore
        SET_DS                          ;SES - Data Segment = Code Segment
	push	ax
	push	dx
IF SB16                                 ;SES
;; check for MIDI interrupt when using driver with SB16
;; ----------------------------------------------------
        mov     dx,[_io_addx]           ;SES - read interrupt ID reg. (SB16)
        add     dx,4                    ;SES
        mov     al,82h                  ;SES
        out     dx,al                   ;SES
        inc     dx                      ;SES
        in      al,dx                   ;SES
        and     al,7                    ;SES - lowest 3 bits
        cmp     al,MIDIINT              ;SES - check for MIDI Interrupt
        je      @@VO_INT90              ;SES - exit ISR
ENDIF                                   ;SES

;; check for invalid interrupt when using IRQ 7 (Intel approved method)
;; --------------------------------------------------------------------
        mov     al,[byte _intr_num]     ;SES - Get interrupt number
        cmp     al,7                    ;SES - is it IRQ 7?
        jne     @@INT_OK                ;SES - no, then skip test of PIC

        mov     al,0bh                  ;SES - Select PIC In Service Reg.
        out     20h,al                  ;SES
        in      al,20h                  ;SES - read In Service Register
        test    al,80h                  ;SES - was it a valid interrupt?
        jz      @@VO_INT90              ;SES - no, then skip it

@@INT_OK:
IF SB16
 ;       cmp     [PlayMode],2            ;SES
 ;       jb      @@8BIT
        mov     dx,[_io_addx]           ; clear 16 bit interrupt in DSP
        add     dl,0FH
        in      al,dx
;        jmp     @@TRANS
@@8BIT:
ENDIF
        mov     dx,[_io_addx]           ; clear 8 bit interrupt in DSP
        add     dl,0EH
        in      al,dx
@@TRANS:
        cmp     [_voice_status],0       ; DSP interrupt possibly from HALT
        je      @@VO_INT90              ; yes, Ignore the interrupt.

        cmp     [BACKF],1               ; In backfill mode?
        jne     @@NOTBF
        xor     [currentBuf],1          ; toggle buffer flag
        jmp     @@VO_INT90
@@NOTBF:
        mov     ax,[LEN_L_TO_DMA]
        or      ax,ax
        jnz     @@VO_INT10
        call    END_DMA_TRANSFER
        jmp     short @@VO_INT90

@@VO_INT10:
        call    DMA_OUT_TRANSFER

@@VO_INT90:                             ; clears interrupt at PIC(s)
        mov     al,20H
        cmp     [_intr_num],7
        jbe     @@NOT
        out     0a0h,al                 ; clear PIC1 if IRQ >=8
@@NOT:
        out     20H,al
        pop     dx
        pop     ax
        RESTORE_DS
        ClearSemaphoreIRET
        endp

;;-------------------------------------------------------------------------
;; In an ISR, so all registers need to be saved!! (AX,DX, allready saved though.

Proc    DMA_OUT_TRANSFER        near
        INISR

        mov     cx,-1                   ; get current page end address

        cmp     [PAGE_TO_DMA],0         ; last page to dma ?
        jnz     @@DOT10                 ; no, skip

        inc     [PAGE_TO_DMA]
        mov     cx,[LAST_DMA_OFFSET]    ; get end addx

@@DOT10:
        sub     cx,[DMA_CURRENT_ADDX]   ; calculate current page addx
        mov     [DMA_CURRENT_COUNT],cx
        inc     cx
        jz      @@DOT20

        sub     [LEN_L_TO_DMA],cx
        sbb     [LEN_H_TO_DMA],0
        jmp     short @@DOT30

@@DOT20:
        dec     [LEN_H_TO_DMA]

        ;; Program DMAC
@@DOT30:
        cmp     [BACKF],1               ; test to see if in backfill mode.
        jne     @@NOTBF
        mov     dh,DMA_VOICE_OUT_AI
        cmp     [RecordMode],1          ; In recording mode?
        jne     @@DOT40
        mov     dh,DMA_VOICE_IN_AI
        jmp     @@DOT40
@@NOTBF:
        mov     dh,DMA_VOICE_OUT
        cmp     [RecordMode],1          ; In recording mode?
        jne     @@DOT40
        mov     dh,DMA_VOICE_IN
@@DOT40:
        mov     dl,[DMA_CURRENT_PAGE]
        mov     ax,[DMA_CURRENT_ADDX]
        mov     cx,[DMA_CURRENT_COUNT]

IF SB16
        cmp     [dmaChannel],4          ; are we using a 16 bit DMA channel?
        jb      @@8BIT1
        shr     dl,1
        rcr     ax,1
        shl     dl,1

        inc     cx                      ; convert to count of words
        shr     cx,1
        dec     cx
@@8BIT1:
ENDIF
        call    PROG_DMA

        dec     [PAGE_TO_DMA]
        inc     [DMA_CURRENT_PAGE]
        mov     [DMA_CURRENT_ADDX],0

        ;; Program DSP
IF SB16                                 ; - SB16 Code -------------------

        cmp     [PlayMode],1
        ja      @@16BIT
        mov     al, DSP16_8BIT          ; 8 bit command
        jmp     @@NOT16
@@16BIT:
        mov     al, DSP16_16BIT         ; 16 bit command
@@NOT16:
        cmp     [BACKF],1               ; Are we in DMA backfill mode?
        jne     @@NOBACKF
        or      al, DSP16_AUTO_INIT     ; set auto-init
@@NOBACKF:
        cmp     [RecordMode],1          ; are we recording?
        jne     @@NOREC
        or      al, DSP16_RECORD        ; set A/D
@@NOREC:
        call    write_dsp               ; write command

        sub     al, al
        test    [PlayMode],1            ; is it stereo?
        jz      @@MONO
        or      al, DSP16_STEREO        ; set stereo
@@MONO:
        mov     dx, [PlayMode]
        cmp     [PlayMode],2            ; is it 16 bit?
        jb      @@8BIT2
        or      al, DSP16_SIGNED        ; set 16 bit format
@@8BIT2:
        call    write_dsp               ; write mode

        mov     ax, [DMA_CURRENT_COUNT] ; get DMA buffer size

        cmp     [PlayMode],2            ; are we playing 16 bit samples?
        jb      @@8BIT3

        inc     ax                      ; convert to count of words
        shr     ax,1
        dec     ax
@@8BIT3:

        cmp     [BACKF],1               ; Are we in DMA backfill mode?
        jne     @@NOBF
        inc     ax                      ; determine 1/2 buffer size
        shr     ax,1
        dec     ax
@@NOBF:
        call    write_dsp               ; LSB of Size
        mov     al, ah
        call    write_dsp               ; MSB of Size

ELSE                                    ; - SB and SBPRO code -----------

        ;; Program Mixer for Stereo (SBPRO only)
IF SBPRO
        mov     ah,0
        cmp     [PlayMode],1
        je      @@OKP
        xor     ah,0
        call    SetStereoState
@@OKP:
ENDIF
        cmp     [RecordMode],1          ; In record mode?
        je      @@REC
        cmp     [BACKF], 1              ; DMA backfill mode?
        je      @@BF1
        test    [PlayMode],1            ; is it stereo?
        jnz     @@STEREO1
        mov     al,DSP_VO8_CMD          ; use playback, single-cycle, mono
        jmp     @@DOIT
@@STEREO1:
        mov     al, DSP_VO8_HS_CMD      ; use playback, single-cycle, high speed
        jmp     @@DOIT
@@BF1:
        test    [PlayMode],1            ; is it stereo?
        jnz     @@STEREO2
        mov     al,DSP_VO8_AI_CMD       ; use playback, auto-init, mono
        jmp     @@DOIT
@@STEREO2:
        mov     al, DSP_VO8_AI_HS_CMD   ; use playback, auto-init, high speed
        jmp     @@DOIT
@@REC:
        cmp     [BACKF], 1              ; DMA backfill mode?
        je      @@BF2
        test    [PlayMode],1            ; is it stereo?
        jnz     @@STEREO3
        mov     al,DSP_VI8_CMD          ; use playback, single-cycle, mono
        jmp     @@DOIT
@@STEREO3:
        mov     al, DSP_VI8_HS_CMD      ; use playback, single-cycle, high speed
        jmp     @@DOIT
@@BF2:
        test    [PlayMode],1            ; is it stereo?
        jnz     @@STEREO4
        mov     al,DSP_VI8_AI_CMD       ; use playback, auto-init, mono
        jmp     @@DOIT
@@STEREO4:
        mov     al, DSP_VI8_AI_HS_CMD   ; use playback, auto-init, high speed
@@DOIT:
        push    ax                      ; save command

        ;; test for order of operations (low speed single cycle is weird)
        cmp     al, DSP_VO8_CMD         ; is it single-cycle low speed?
        je      @@LOSPDNAI
        cmp     al, DSP_VI8_CMD         ; is it single-cycle low speed?
        je      @@LOSPDNAI

        mov     al,dsp_blk_size         ; send DSP block size command
        call    write_dsp

        mov     ax, [DMA_CURRENT_COUNT] ; Get size
        cmp     [BACKF], 1
        jne     @@NOBF
        inc     ax                      ;SES - determine 1/2 buffer size
        shr     ax, 1                   ;SES
        dec     ax                      ;SES
@@NOBF:
        call    write_dsp
        mov     al, ah
        call    write_dsp
        pop     ax                      ; get command
        call    write_dsp
        jmp     @@DOT90

@@LOSPDNAI:
        pop     ax                      ; get command
        call    write_dsp
        mov     ax, [DMA_CURRENT_COUNT] ; Get size
        call    write_dsp
        mov     al,ah
        call    write_dsp
ENDIF

@@DOT90:
        call    START_DMA

        OUTISR                          ; Restore registers for ISR routines.
        ret
        endp

;; --------------------------------------------------------------------

Proc    END_DMA_TRANSFER        near
        INISR

        call    STOP_DMA                ; turn off DMA
IF SB16
;        cmp     [dmaChannel],4          ; are we using a 16 bit DMA channel?
;        jb      @@8BIT
        mov     dx,[_io_addx]           ; clear 16 bit interrupt in DSP
        add     dl,0FH
        in      al,dx
;        jmp     @@16BIT
;@@8BIT:
ENDIF
        mov     dx,[_io_addx]           ; clear 8 bit interrupt in DSP
        add     dl,0EH
        in      al,dx
@@16BIT:
        mov     [_voice_status],0

;; Do Callbacks if ncessary.
        call    DoCallBacks

        OUTISR
        ret
        endp

;; --------------------------------------------------------------------

IF SBPRO
Silence db      80h

Proc    StereoFix       near
        push    cx
        push    dx
        push    [cs:BACKF]

        mov     [cs:BACKF],0
        mov     [cs:_voice_status],1

        ;; Program DMAC
        mov     dx,cs
        mov     ax,OFFSET Silence
        call    CALC_20BIT_ADDX         ; calculate DMA buffer address
        xor     cx,cx
        mov     dh,DMA_VOICE_OUT
        call    PROG_DMA

        ;; Set Mixer to Stereo
        mov     ah, 1
        call    SetStereoState

        ;; Program DSP
        mov     al, DSP_VO8_CMD
        call    write_dsp
        xor     al,al
        call    write_dsp
        call    write_dsp

        call    START_DMA
@@WAIT:
        cmp     [cs:_voice_status],1
        je      @@WAIT

        pop     [cs:BACKF]
        pop     dx
        pop     cx
        ret
        endp

;--------------------------------------------------------------------
; SetStereoState - switches the mixer in/out of stereo state
;
; Input: AH - stereo state requested (OFF=0, ON=1)
;--------------------------------------------------------------------
PROC    SetStereoState near
        push    dx

        mov     dx,[cs:_io_addx]        ; Base I/O address of sound blaster.
        add     dx,4                    ; Point to mixer address port.
        mov     al,0eh                  ;select DNFI/VSTC flag set
        out     dx,al
        jmp     $+2
        inc     dx                      ; Point to mixer data.
        mov     al,0
        cmp     ah,0                    ; Turn off(ah=0) or on(ah=1)?
        je      @@OKP
        mov     al,2
@@OKP:
        out     dx,al                   ;Set stereo/mono mode

        pop     dx
        ret
        endp
ENDIF
;--------------------------------------------------------------------

CPROC	ctv_output
	ARG	DATAL:WORD,DATAH:WORD,SNDLEN:WORD,FREQ:WORD
	PENTER	0
	PushCREGS
        SET_DS
        mov     ax,ds
        mov     es,ax                   ; ES=DS=CS
@@WAIT:
        cmp     [_voice_status],0
        jne     @@WAIT                  ; Wait until last sound has completed.

        mov     [currentBuf], 1         ;SES - reset buffer index
        mov     [_voice_status], 1

        ;; Set Speaker State
        mov     al,1                    ;SES - turn on speaker
        cmp     [RecordMode],1          ;SES - Recording?
        jne     @@SET
        xor     al,al                   ;SES - Speaker OFF while recording.
@@SET:
        call    ON_OFF_SPEAKER

        ;; Set Sampling Rate
IF SB16
        mov     al,DSP16_SET_DA_RATE    ; write sampling rate DSP command.
        call    write_dsp
        mov     ax,[FREQ]               ; get playback frequency
        xchg    al ,ah
        call    write_dsp               ; MSB of frequency
        mov     al, ah
        call    write_dsp               ; LSB of frequency
ELSE
        mov     dx,0FH                  ; calculate sampling rate value for
        mov     ax,4240H                ; DSP
        mov     cx,[FREQ]               ; Get playback frequency.
        div     cx

        mov     cl,al
        neg     cl

        mov     al,DSP_TIME_CMD         ; write sampling rate DSP command.
        call    write_dsp

        mov     al,cl                   ; write sampling rate to DSP
        call    write_dsp
ENDIF
        ;; Prepare for Programming DMAC
        mov     dx,[DATAH]              ; DMA buffer location
        mov     ax,[DATAL]
        mov     cx,[SNDLEN]             ; Length of sound.

        call    CALC_20BIT_ADDX         ; calculate DMA buffer address

        mov     [DMA_CURRENT_PAGE],dl   ; DMA page
        mov     [DMA_CURRENT_ADDX],ax   ; DMA offset

        mov     [LEN_L_TO_DMA],cx
        mov     [LEN_H_TO_DMA],0

        add     ax,cx
        adc     dl,0
        sub     ax,1
        sbb     dl,0

        mov     [LAST_DMA_OFFSET],ax
        sub     dl,[DMA_CURRENT_PAGE]
        mov     [PAGE_TO_DMA],dl

        call    DMA_OUT_TRANSFER

        sub     ax,ax
@@OV90:
        RESTORE_DS
	PopCREGS
	PLEAVE
	ret
	endp

;--------------------------------------------------------------------
CPROC   ctv_halt
	PushCREGS
	push cx
	SET_DS
	mov	ax,ds
	mov	es,ax			; ES=DS=CS

	mov	ax,1			; set error status

	cmp	[_voice_status],0	; is digital voice running?
	jz	@@NOTRUN

	cli
IF SB16
	cmp	[PlayMode],1		; are we doing a 16 bit transfer?
        ja      @@ITS16                 ; yes, it is a 16 bit transfer.
	cmp	[BACKF],1		; are we in backfill mode?
	jne	@@NOTBF1		; no
        mov     al,DSP_HALT8_AI_CMD     ; Turn off 8 bit auto-init after next IRQ
;        mov     al,DSP_HALT8_CMD        ; Slam-Stop 8 bit auto-init
	jmp	@@DOIT
@@NOTBF1:
	mov	al,DSP_HALT8_CMD	; Turn 8 bit single cycle dma off
	jmp	@@DOIT
@@ITS16:
	cmp	[BACKF],1
	jne	@@NOTBF2
        mov     al,DSP16_HALT16_AI_CMD  ; Turn off 16 bit auto-init after next IRQ
;        mov     al,DSP16_HALT16_CMD     ; Slam-Stop 16 bit auto-init
	jmp	@@DOIT
@@NOTBF2:
	mov	al,DSP16_HALT16_CMD	; Turn 16 bit single cycle dma off
@@DOIT:
	call	write_dsp		; Send "halt" command.
ELSE
IF SBPRO
	cmp	[PlayMode],1		; are we in high speed mode (stereo)?
	jne	@@NOHS
   ;; drop volume so click is not heard
	mov	dx,[_io_addx]		; Base I/O address of sound blaster.
	add	dx,4			; Point to mixer address port.
	mov	al,4			; voice volume register
	out	dx,al
	jmp	$+2
	inc	dx			; Point to mixer data.
	in	al,dx			; get old volume value.
	jmp	$+2
	push	ax			; save it
	xor	al, al
	out	dx, al			; turn off voice volume
	jmp	$+2
	call	reset_dsp		; halt high speed mode
	mov	cx, PRO_STOP_TIME	; delay so reset may finish
	loop	$
	mov	dx,[_io_addx]		; Base I/O address of sound blaster.
	add	dx,4			; Point to mixer address port.
	mov	al,4			; voice volume register
	out	dx,al
	jmp	$+2
	inc	dx			; Point to mixer data.
	pop	ax
	out	dx, al			; restore volume
	jmp	@@EXITHS
@@NOHS:
ENDIF
	cmp	[BACKF],1		; are we in backfill mode?
	jne	@@NOTBF 		; no
        mov     al,DSP_HALT8_AI_CMD     ; Turn off 8 bit auto-init after next IRQ
;        mov     al,DSP_HALT8_CMD        ; Slam-Stop 8 bit auto-init
	jmp	@@DOIT
@@NOTBF:
	mov	al,DSP_HALT8_CMD
@@DOIT:
	call	write_dsp
@@EXITHS:
ENDIF
        mov     [_voice_status],0       ; clear voice status flag

        sti
	sub	ax,ax
@@NOTRUN:
	RESTORE_DS
	pop	cx
	PopCREGS
	ret
	endp

;; --------------------------------------------------------------------

CPROC	ctv_uninstall
	PushCREGS
        SET_DS

        sub     al,al                   ; turn off speaker
        call    ON_OFF_SPEAKER


        cmp     [_voice_status],0
        jz      @@UI90

        call    _ctv_halt               ;SES - better call
        call    END_DMA_TRANSFER

@@UI90:

;; Restore interrupt vector
        mov     al,[byte _intr_num]
        lea     bx,[ORG_INT_ADDX]
        call    RESTORE_INTERRUPT

IF SB16
        ;; Restore original DMA settings (TEMP FIX!)
        mov     dx,[cs:_io_addx]
        add     dx,4
        mov     al, 81h
        out     dx, al
        inc     dx
        mov     al, [origDMA]
        out     dx, al
ENDIF

        sub     ax,ax

        RESTORE_DS
        PopCREGS
        ret
        endp

;; -----------------------------------------------------------------------

CPROC   ctv_status
	mov	ax,[cs:_voice_status]
	ret
	endp

;; -----------------------------------------------------------------------
SPEAKERSTATE	db	-1

Proc	ON_OFF_SPEAKER	near

        cmp     al,[SPEAKERSTATE]
	je	@@DONE
	PushAll

	mov	[SPEAKERSTATE],al

        mov     ah,DSP_ONSPK_CMD
        or      al,al
        jnz     @@OOS10

        mov     ah,DSP_OFFSPK_CMD
@@OOS10:
        mov     al,ah
        call    write_dsp

	PopAll
@@DONE:
       sub      ax,ax                    ; inidcate no error
       ret
       endp

;; --------------------------------------------------------------------
;; SoundBlaster PlaySound
Proc	PlaySound	near
;; CX ->number of bytes in sound sample.
;; ES:BX -> far address of sound sample to be played.
;; DX ->rate to play at.

        SET_DS

        call SETUP_DMA                  ; Determine proper DMA registers
IF SBPRO
        cmp     [PlayMode],0            ; Is it stereo?
	je	@@OKF
        shl     dx,1                    ; double frequency
        call    StereoFix
@@OKF:
ENDIF
        push    dx                      ; Save sampling rate.
	push	cx			; Number of bytes.
	push	es			; Segment
	push	bx			; Offset
@@DOIT:
        call    _ctv_output             ; Send it.
	add	sp,8			; Balance stack.

        RESTORE_DS
	ret
	endp

;; --------------------------------------------------------------------
Proc    StopSound       near
	push	ds

	push	cs
	pop	ds
	call	_ctv_halt

	pop	ds
	ret
	endp

;; --------------------------------------------------------------------
Proc	DoCallBacks	near
	cmp	[cs:CallBacks],0
	je	@@GOUT
	PushAll 		; Save all registers
	mov	ds,[cs:CallDS]	; Get DS register.
	call	[cs:CallBack]	; far call to application.
	PopAll			; Restore all registers.
@@GOUT: ret
	endp

LABEL	SUICIDE byte		;; Where to delete ourselves from memory
hard	db	"SoundBlaster not detected.",13,10,'$'
IF	SBPRO
msg0    db      "Creative Labs Sound Blaster Pro"
ENDIF
IF      SB16
msg0    db      "Creative Labs Sound Blaster 16"
ENDIF
IF	SBLASTER
msg0    db      "Creative Labs Sound Blaster "
ENDIF
IF	STFX
msg0	db	"ATI Stereo FX "
ENDIF
IF SBCLONE
msg0	db	"Sound Blaster Clone "
ENDIF
	db	" - Copyright (c) 1994, THE Audio Solution:v3.40",13,10,'$'
msg1	db	"The Sound Driver is already resident.",13,10,'$'
msg1a   db      "The Sound Driver is resident, through MIDPAK.",13,10,'$'
msg1b   db      "A Sound Driver cannot be loaded on top of MIDPAK.  Unload MIDPAK first.",13,10,'$'
msg2	db	"Unable to install Sound Driver interupt vector",13,10,'$'
msg3    db      "Invalid command line",13,10,'$'
msg4	db	"Sound Driver isn't in memory",13,10,'$'
msg5	db	"Sound Driver unloaded",13,10,'$'
msg5a	db	"Sound Driver can't be unloaded, unload MIDPAK first.",13,10,'$'
param   dw      4 dup(?)        ;; Used for parameter passing.
Installed	dw	0
Proc	LoadSound near
	mov	ax,cs			;;
	mov	ds,ax			;; establish data segment
	mov	es,ax			;; point ES to PSP
	call	CheckIn
	mov	[Installed],ax		;; Save in installed flag.
	call	ParseCommandLine	;; Build a command line.
	cmp	[_argc],0
	je	NoArg
	cmp	[_argc],1
	jne	@@BC
	mov	bx,[_argv]
	mov	al,[bx]
	cmp	al,'u'
	je	ULOAD
	cmp	al,'U'
	je	ULOAD
@@BC:
	Message msg3			;; Invalid command line
        DOSTerminate

ULOAD:	mov	ax,[Installed]
	or	ax,ax
	jnz	DOU
	Message msg4			;; wasn't loaded.
	DOSTerminate			;; Terminate with message.
DOU:	cmp	ax,2
	jne	@@OKU
	Message msg5a
	DOSTerminate
@@OKU:
	CALLF	DeInstallInterupt
	Message msg5			;; Display message
	DOSTerminate			;; terminate

NoArg:	or	ax,ax			;; Already loaded?
	jz	@@DOLO			;; no->load it.
	cmp	ax,2
	jne	@@TEMP
	Message msg1a
	DOSTerminate
@@TEMP: cmp	ax,3
	jne	@@TEMPA
        jmp     short @@DOLO
	Message msg1b
	DOSTerminate
@@TEMPA:
	Message msg1			;; message
	DOSTerminate			;;
@@DOLO: CALLF	InstallInterupt
	or	ax,ax			;; Was there an error?
	jz	@@HOP1			;; no->continue
	Message msg2			;; display the error message
        Message hard                    ; Hardware error message if there is one.
	DOSTerminate			;; exit to dos
@@HOP1:
;;; The Kernel is now installed.
;;; Announce the Kernel's presence.
	Message msg0
	DosTSR	SUICIDE 	;; Terminate ourselves bud.
	endp

Proc	InstallInterupt 	far
	IN_TSR

	call	HardwareInit	;; Initialize hardware.
	or	ax,ax		;; Error initializing hardware?
	jnz	@@OUT

	mov	[param],KINT		;; The interupt kernel is going into.
	mov	[param+2],offset SoundInterupt ;; offset of interupt routine
	mov	[param+4],cs		;; Our code segment.
	PushEA	param			;; push the address of the parameter list
	call	InstallInt		;; Install the interupt.
	add	sp,2			;; clean up stack
@@OUT:

	OUT_TSR
	ret
	endp

Proc	DeInstallInterupt	far
	IN_TSR
	mov	[param],KINT		;; Interupt requested to be unloaded.
	PushEA	param			;; pass parameter.
	call	UnLoad			;; Unload it
	add	sp,2			;; clean up stack
	OUT_TSR
	ret
	endp


Proc	CheckIn near
        push    ds                      ; Save ds register.
        push    si

        mov     si,66h*4h               ; get vector number
        xor     ax,ax                   ; zero
        mov     ds,ax                   ; point it there
        lds     si,[ds:si]              ; get address of interupt vector
        or      si,si                   ; zero?
        jz      @@CIOUT                 ; exit if zero
        sub     si,6                    ; point back to identifier

        cmp     [word si],'IM'          ; Midi driver?
	jne	@@NEX
        cmp     [word si+2],'ID'        ; full midi driver identity string?
	jne	@@NEX

;; Ok, a MIDI driver is loaded at this address.
        mov     ax,701h                 ; Digitized Sound capabilities request.
        int     66h                     ; Request.
        or      ax,ax                   ; digitized sound driver available?
        jnz     @@INMID                 ; yes, report that to the caller.
        mov     ax,3                    ; Not available, but mid pak is in!
        jmp     short @@EXT             ; exit with return code.
@@INMID:
        mov     ax,2                    ; Sound driver resident, through MIDPAK.
        jmp     short @@EXT
@@NEX:
        cmp     [word si],454Bh         ; equal?
        jne     @@CIOUT                 ; exit if not equal
        cmp     [word si+2],4E52h       ; equal?
        jne     @@CIOUT
@@OK:	mov	ax,1
@@EXT:
	pop	si
	pop	ds
	ret
@@CIOUT: xor    ax,ax                   ; Zero return code.
        jmp     short @@EXT
	endp



Proc	InstallINT near
	ARG	DATA:WORD
;; Usage: IntallINT(&parms)
;; offset 0: interupt
;;        2: offset of interupt code
;;        4: segment of interupt code
	PENTER	0
	PushCREGS

        mov     bx,[DATA]               ; Get address of parameter table
        mov     ax,[bx]                 ; get the interupt vector.
        mov     di,ax                   ; save interupt vector into DI as well
        mov     si,[bx+2]               ; get offset
        mov     ds,[bx+4]               ; get segment.
        mov     ah,35h                  ; Get interupt vector
        int     21h                     ; Do DOS call to get vector.
        mov     [ds:si-10],bx           ; Save the old offset.
        mov     [ds:si-8],es            ; Save the old segment
        cld
        xor     ax,ax
        mov     es,ax
        ShiftL  di,2                    ;
        mov     ax,si                   ; get offset.
        cli
        stosw
        mov     ax,ds                   ; code segment
        stosw                           ; store it.
        sti
        xor     ax,ax                   ; Success

        PopCREGS
	PLEAVE
	ret
	endp

Proc	UnLoad near
	ARG	DATA:WORD
;; Usage: UnLoad(&vector)
;; Returns: AX = 0 success
;           AX nonzero, couldn't unload interupt vector.
	PENTER	0
	PushCREGS

        mov     ax,68Fh                 ; Stop sound playback!
        int     KINT                    ; Invoke interrupt.
	WaitSound
        mov     ax,692h                 ; Deinstall hardware vectors.
	int	KINT

        mov     bx,[DATA]               ; get address of interupt vector
        mov     bx,[bx]                 ; get the interupt vector.
        mov     dx,bx                   ; put it into DX as well
        ShiftL  bx,2                    ;
        xor     ax,ax
        mov     ds,ax                   ; Segment zero
        lds     si,[ds:bx]              ; get address of interupt vector
        or      si,si                   ; zero?
        jz      @@UOUT                  ; exit if zero
        cmp     [WORD ds:si-2],524Bh    ;'KR' Is this a kernel installed interupt?
        push    ds                      ; save DS
        mov     ax,dx                   ; Get interupt vector.
        mov     ah,25h                  ; Do DOS 25h set interupt vector.
        mov     dx,[ds:si-10]           ; get old offset
        mov     ds,[ds:si-8]            ; get old segment
        int     21h                     ; set interupt vector.
        pop     ax                      ; get back segment of program.
        mov     es,ax
	push	es
        mov     es,[es:2Ch]             ; Environment space.
	mov	ah,49h
        int     21h                     ; Free it up.
	pop	es
        mov     ah,49h                  ; free memory.
        int     21h                     ; free up the memory used by us.

@@EXIT: PopCREGS
	PLEAVE
        ret
@@UOUT: mov     ax,1
        jmp     short @@EXIT
	endp

;; This procedure parses the command line and builds an array of
;; pointers to each argument.  Arguments are seperated by space's.
;; these spaces get replaced by zero bytes.
_argc   dw      0                       ; The argument count
_argv   dw      16 dup(0)               ; Up to 16 arguments.
command db	128 dup(?)

Proc    ParseCommandLine  near
	mov	[_argc],0
	cmp	[byte es:80h],2
	jb	@@END
	xor	cx,cx
        mov     cl,[es:80h]             ; Get length.
	SwapSegs
        dec     cx                      ; Less one
	lea	di,[command]
	mov	si,82h
	rep	movsb
	push	cs
	pop	ds
        lea     di,[_argv]              ; Argument list.
        lea     si,[command]            ; Start address.
@@SET:  inc     [_argc]                 ; Increment argument counter.
        mov     ax,si                   ; Base argument addres.
	stosw
@@NEX:  lodsb                           ; Get characters until we hit space of eol
	cmp	al,32
	jne	@@NEX2
        mov     [byte ds:si-1],0        ; Turn space into a zero byte.
        jmp     short @@SET
@@NEX2:
	cmp	al,13
	je	@@END1
	or	al,al
        jnz     @@NEX                   ; Keep skipping to next arg.
@@END1: mov	[byte ds:si-1],0	; Zero byte terminate last arg
@@END:
	ret
	endp

;;************************************************************************
;; Unique harware init code.
;;************************************************************************
Proc	HardwareInit	near
        xor     ax,ax                   ; success code by default.
        call    _InitBlaster            ; Initialize sound blaster.
	jnc	@@OKS
	mov	ax,1
        jmp     short @@NOKS
@@OKS:	xor	ax,ax
@@NOKS:
	ret
	endp

	ENDS
	end	START

