/*  SFX14436.C / SFX360 (1.44MB TURBO version) self-extracting disk image stub

Compiler: 16 bit: [Open] Watcom C++/Borland C++/Microsoft C[++]/Visual C++ 1.x
		  Zortech/Symantec/Digital Mars C++ (written by Walter Bright)

Syntax: filename.exe d:

Revision History:
		2000.1002 dosius: Started program 360.
		2000.1003 dosius: Created sfx version.
		2000.1013 dosius: Created 72x version, much faster!
		2006.1121 lucho: Added lock, made smaller and more portable.

How to use:
	Build - C:\>cl -W4 -G2 -Gr -O1 sfx14436.c -link /noe /nonulls
	Merge - C:\>copy /b sfx14436.exe+my_stub.144 my_prog.exe
	Then use the my_prog as above to extract the image to disk.
	The image is a 1,474,560-byte overlay which MUST NOT BE COMPRESSED.
	It is alright to compress the stub, but it must be an EXE file
	(DO NOT BUILD TINY!) because of the overlay.
	Brian E. Reifsnyder's RAREAD is a very good tool for creating
	images for use with SFX144.  IIRC, his site is:
	http://www.23cc.com/free-fdisk

See the file "COPYING" for license information.  Note that as far as
the author, STEPHEN VICTOR NICKOLAS DOB01251980, is concerned, using
the program requires attaching another file to it, and this does not
constitute "modification" as long as the stub is not modified.  The
source code need only be distributed with a stub, not a full program;
but the stub and its source must be made available under the GPL if
the stub is based on modified sources.

					       Dosius
					       13 October 2000
*/
#include <io.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <fcntl.h>

#if defined __TURBOC__ || defined __WATCOMC__
#define	_dos_seek	lseek
#endif

#if !defined __TURBOC__ && !defined __SC__
int abswrite(int drive, int nsects, int lsect, void *buffer)
{
    union REGS r;
    r.x.ax = drive;
    r.x.dx = lsect;
    r.x.cx = nsects;
    r.x.bx = (int)buffer;
    int86(0x26, &r, &r);
    return r.x.cflag;
}
#endif

int genblk_ioctl(int drive, int cx, char *par)
{
    union REGS r;
    r.x.ax = 0x440D;
    r.x.cx = cx;
    r.x.dx = (int)par;
    r.x.bx = drive;	/* BH must be 0 for lock! */
    intdos(&r, &r);
    return r.x.cflag;
}

void cdecl main(int argc, char **argv)
{
    static char buffer[36864U];
    /*
     * Used to be 512.  36864 is 72 sectors, 36K, and only 40 reads need
     * to be made to the file.
     */
    int file;
    char drive, letter;
    unsigned cursect, bytes = sizeof(buffer);

    if (argc != 2) {
	cputs("SFX144: Usage: ");
	cputs(argv[0]);
	cputs(" {A: | B:}");
	return;
    }
    if (argv[1][1] != ':' || argv[1][2] != '\0'
	|| (letter = (char)((*(argv[1])) & '\xDF')) != 'A' && letter != 'B')
	/* You don't want to raw-write your hard drive, do you?
	   Report an error for non-drive or drive past B. */
    {
	cputs("SFX144: Invalid drive specification");
	return;
    }
    if (_dos_open(argv[0], O_RDONLY, &file)) {
	cputs("SFX144: Can't open myself!");
	return;
    }
    if ((signed long)_dos_seek(file, 0xFFE98000L, SEEK_END) < 0) {
	cputs("\r\nSFX144: Invalid floppy image file!");
	goto ret;
    }
    cputs("SFX144 (1.44 MB disk image extractor v1.2) by Dosius\r\n"
	  "Extracting to drive ");
    putch(letter);
    cputs(": (72 sectors per block, 80x18x2)\r\n"
	  "........................................\r");
    genblk_ioctl(drive = (char)(letter - '@'), 0x84A, NULL);	/* lock drive */
    for (cursect = 0; bytes == sizeof(buffer) && cursect < 2880; cursect += 72) {
	_dos_read(file, buffer, sizeof(buffer), &bytes);
	if (abswrite(drive - 1, 72, cursect, buffer)) {
	    cputs("\r\nSFX144: Could not write to drive ");
	    putch(letter);
	    putch(':');
	    break;
	}
	putch('o');
    }
    genblk_ioctl(drive, 0x86A, NULL);	/* unlock drive */
ret:_dos_close(file);
}

#if defined _MSC_VER	/* MSC[++]/VC++ stubs to decrease executable size */
#include <stdlib.h>

/* void __cdecl _setargv(void) {} */
void __cdecl _setenvp(void) {}

int __cdecl _nullcheck(void)
{
    return 0;
}

void __cdecl _fptrap(void)
{
    exit(-1);
}

int _acrtmsg = 0x9876;

void __cdecl _FF_MSGBANNER(void) {}
#endif
