#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "mpu.h"


char *usage =
	" usage: mputst [ <irq> ]\n"
	" where <irq> can be 2, 3, 4, 7, or 9 (default is 2)\n";


main(int argc, char *argv[]) {
	int		 i, stat, irq;
	unsigned char	 data;

	if(argc > 1) {
		if(*argv[1] == '/' | *argv[1] == '-' | *argv[1] == '?') {
			printf(usage);
			return 0;
		}
		irq = (int) atol(argv[1]);
		if(irq != 2 && irq != 3 && irq != 4 && irq != 7 && irq != 9) {
			printf("\007 Error: invalid IRQ selection\n");
			printf(usage);
			return 0;
		}
	}
	else
		irq = 2;

	printf("\nRunning MPU-401 Test at IRQ %d\n\n", irq);

	printf("Opening MPU-401 device ... ");
	if(stat = mpu_open(irq)) {
		printf("\n\007 MPU-401 Open Error\n");
		goto exit0;
	}
	printf("OK\n");

	printf("Sending test data ... ");
	for(i=0; i<255; ++i) {
		if(stat = mpu_send((unsigned char) i, CLOCKS_PER_SEC/2)) {
			printf("\n\007 MPU-401 Send Error, byte %d\n", i);
			goto exit1;
		}
	}
	printf("OK\n");

	printf("Reading and Verifying ... ");
	for(i=0; i<255; ++i) {
		if(stat = mpu_recv(&data, CLOCKS_PER_SEC/2)) {
			printf("\n\007 MPU-401 Recv Error, byte %d\n", i);
			goto exit1;
		}
		if((int) data != i) {
			stat = -1;
			printf("\n\007 MPU-401 Verify Error, byte %d: %d\n", i, data);
			goto exit1;
		}
	}
	printf("OK\n");


exit1:	printf("\nClosing MPU-401 device ... ");
	mpu_close();
	printf("OK\n");

exit0:	if(!stat)
		printf("\n!!! MPU-401 Test PASSED !!!\n");
	else
		printf("\n!!! MPU-401 Test FAILED !!!\n");

	return 0;
}

