/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.util.Which;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.FeatureConstructor;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

public final class WebServiceFeatureList
implements WSFeatureList {
    private Map<Class<? extends WebServiceFeature>, WebServiceFeature> wsfeatures = new HashMap<Class<? extends WebServiceFeature>, WebServiceFeature>();
    @Nullable
    private WSDLFeaturedObject parent;
    private static final Logger LOGGER = Logger.getLogger(WebServiceFeatureList.class.getName());

    public WebServiceFeatureList() {
    }

    public WebServiceFeatureList(WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                this.wsfeatures.put(webServiceFeature.getClass(), webServiceFeature);
            }
        }
    }

    public WebServiceFeatureList(@NotNull Class<?> clazz) {
        this.parseAnnotations(clazz);
    }

    public void parseAnnotations(Iterable<Annotation> iterable) {
        for (Annotation annotation : iterable) {
            WebServiceFeature webServiceFeature = WebServiceFeatureList.getFeature(annotation);
            if (webServiceFeature == null) continue;
            this.add(webServiceFeature);
        }
    }

    public static WebServiceFeature getFeature(Annotation annotation) {
        WebServiceFeature webServiceFeature;
        if (!annotation.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) {
            webServiceFeature = null;
        } else if (annotation instanceof Addressing) {
            Addressing addressing = (Addressing)annotation;
            try {
                webServiceFeature = new AddressingFeature(addressing.enabled(), addressing.required(), addressing.responses());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_ADDRESSING_RESPONSES_NOSUCHMETHOD(WebServiceFeatureList.toJar(Which.which(Addressing.class))), new Object[0]);
            }
        } else if (annotation instanceof MTOM) {
            MTOM mTOM = (MTOM)annotation;
            webServiceFeature = new MTOMFeature(mTOM.enabled(), mTOM.threshold());
        } else if (annotation instanceof RespectBinding) {
            RespectBinding respectBinding = (RespectBinding)annotation;
            webServiceFeature = new RespectBindingFeature(respectBinding.enabled());
        } else {
            webServiceFeature = WebServiceFeatureList.getWebServiceFeatureBean(annotation);
        }
        return webServiceFeature;
    }

    public void parseAnnotations(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            BindingID bindingID;
            MTOMFeature mTOMFeature;
            WebServiceFeature webServiceFeature = WebServiceFeatureList.getFeature(annotation);
            if (webServiceFeature == null) continue;
            if (webServiceFeature instanceof MTOMFeature && (mTOMFeature = (bindingID = BindingID.parse(clazz)).createBuiltinFeatureList().get(MTOMFeature.class)) != null && mTOMFeature.isEnabled() ^ webServiceFeature.isEnabled()) {
                throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_MTOM_CONFLICT(bindingID, webServiceFeature.isEnabled()), new Object[0]);
            }
            this.add(webServiceFeature);
        }
    }

    private static String toJar(String string) {
        if (!string.startsWith("jar:")) {
            return string;
        }
        string = string.substring(4);
        return string.substring(0, string.lastIndexOf(33));
    }

    private static WebServiceFeature getWebServiceFeatureBean(Annotation annotation) {
        WebServiceFeature webServiceFeature;
        WebServiceFeatureAnnotation webServiceFeatureAnnotation = annotation.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
        Class<? extends WebServiceFeature> clazz = webServiceFeatureAnnotation.bean();
        Constructor<?> constructor = null;
        String[] stringArray = null;
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            FeatureConstructor featureConstructor = constructor2.getAnnotation(FeatureConstructor.class);
            if (featureConstructor == null) continue;
            if (constructor == null) {
                constructor = constructor2;
                stringArray = featureConstructor.value();
                continue;
            }
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_MORETHANONE_FTRCONSTRUCTOR(annotation, clazz));
        }
        if (constructor == null) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_NO_FTRCONSTRUCTOR(annotation, clazz));
        }
        if (constructor.getParameterTypes().length != stringArray.length) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_ILLEGAL_FTRCONSTRUCTOR(annotation, clazz));
        }
        try {
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Method method = annotation.annotationType().getDeclaredMethod(stringArray[i], new Class[0]);
                objectArray[i] = method.invoke(annotation, new Object[0]);
            }
            webServiceFeature = (WebServiceFeature)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return webServiceFeature;
    }

    @Override
    public Iterator<WebServiceFeature> iterator() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures());
        }
        return this.wsfeatures.values().iterator();
    }

    @Override
    @NotNull
    public WebServiceFeature[] toArray() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures()).toArray();
        }
        return this.wsfeatures.values().toArray(new WebServiceFeature[0]);
    }

    @Override
    public boolean isEnabled(@NotNull Class<? extends WebServiceFeature> clazz) {
        WebServiceFeature webServiceFeature = this.get(clazz);
        return webServiceFeature != null && webServiceFeature.isEnabled();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F get(@NotNull Class<F> clazz) {
        WebServiceFeature webServiceFeature = (WebServiceFeature)clazz.cast(this.wsfeatures.get(clazz));
        if (webServiceFeature == null && this.parent != null) {
            return this.parent.getFeatures().get(clazz);
        }
        return (F)webServiceFeature;
    }

    public void add(@NotNull WebServiceFeature webServiceFeature) {
        if (!this.wsfeatures.containsKey(webServiceFeature.getClass())) {
            this.wsfeatures.put(webServiceFeature.getClass(), webServiceFeature);
        }
    }

    public void addAll(@NotNull WSFeatureList wSFeatureList) {
        for (WebServiceFeature webServiceFeature : wSFeatureList) {
            this.add(webServiceFeature);
        }
    }

    @Override
    public void mergeFeatures(@NotNull Iterable<WebServiceFeature> iterable, boolean bl) {
        for (WebServiceFeature webServiceFeature : iterable) {
            if (this.get(webServiceFeature.getClass()) == null) {
                this.add(webServiceFeature);
                continue;
            }
            if (!bl || this.isEnabled(webServiceFeature.getClass()) == webServiceFeature.isEnabled()) continue;
            LOGGER.warning(ModelerMessages.RUNTIME_MODELER_FEATURE_CONFLICT(this.get(webServiceFeature.getClass()), webServiceFeature));
        }
    }

    @Override
    public void mergeFeatures(WebServiceFeature[] webServiceFeatureArray, boolean bl) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (this.get(webServiceFeature.getClass()) == null) {
                this.add(webServiceFeature);
                continue;
            }
            if (!bl || this.isEnabled(webServiceFeature.getClass()) == webServiceFeature.isEnabled()) continue;
            LOGGER.warning(ModelerMessages.RUNTIME_MODELER_FEATURE_CONFLICT(this.get(webServiceFeature.getClass()), webServiceFeature));
        }
    }

    public void setParentFeaturedObject(@NotNull WSDLFeaturedObject wSDLFeaturedObject) {
        this.parent = wSDLFeaturedObject;
    }

    @Nullable
    public static <F extends WebServiceFeature> F getFeature(@NotNull WebServiceFeature[] webServiceFeatureArray, @NotNull Class<F> clazz) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (webServiceFeature.getClass() != clazz) continue;
            return (F)webServiceFeature;
        }
        return null;
    }

    private final class MergedFeatures
    implements Iterator<WebServiceFeature> {
        private final Stack<WebServiceFeature> features = new Stack();

        public MergedFeatures(WSFeatureList wSFeatureList) {
            for (WebServiceFeature webServiceFeature : WebServiceFeatureList.this.wsfeatures.values()) {
                this.features.push(webServiceFeature);
            }
            for (WebServiceFeature webServiceFeature : wSFeatureList) {
                if (WebServiceFeatureList.this.wsfeatures.containsKey(webServiceFeature.getClass())) continue;
                this.features.push(webServiceFeature);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.features.empty();
        }

        @Override
        public WebServiceFeature next() {
            if (!this.features.empty()) {
                return this.features.pop();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.features.empty()) {
                this.features.pop();
            }
        }

        public WebServiceFeature[] toArray() {
            return this.features.toArray(new WebServiceFeature[0]);
        }
    }
}

