/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.drvredir.DrvRedirSettingsPanel;
import nn.pp.rc.CloseablePanel;
import nn.pp.rc.FocusHandler;
import nn.pp.rc.Logger;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

public class DrvRedirPanel
extends CloseablePanel
implements FocusHandler {
    int msNo = 0;
    DrvRedirSettingsPanel[] settingsPanels;
    Logger[] logpanes;
    PrintStream[] loggers;
    DrvRedirNative[] drvAccess;
    JPanel mainPanel;
    JLabel initLabel;
    URL codeBase;
    RFBProfile profile;
    public boolean codeLoaded = false;
    boolean debug = true;
    JPanel drvPanel;
    JLabel drvTitle;

    public DrvRedirPanel(URL codeBase, RFBProfile profile) {
        this.profile = profile;
        this.codeBase = codeBase;
        this.msNo = profile.driveRedirectionNoDrives;
        this.addLayout();
        this.drvAccess = new DrvRedirNative[this.msNo];
        this.initLabel = new JLabel(T._("Please wait for the Drive Redirection to load."));
        this.add((Component)this.initLabel, "Center");
    }

    public void setNumberOfDrives(int msNo) {
        this.msNo = msNo;
        this.drvAccess = new DrvRedirNative[msNo];
    }

    @Override
    public void open(Frame frame) {
        if (!this.codeLoaded) {
            try {
                frame.pack();
                for (int i = 0; i < this.msNo; ++i) {
                    try {
                        this.drvAccess[i] = this.loadNativeCode(this.codeBase);
                        continue;
                    }
                    catch (Exception e) {
                        this.drvAccess[i] = null;
                    }
                }
                this.remove(this.initLabel);
                this.loadPanels(this.profile);
            }
            catch (Exception e) {
                this.remove(this.initLabel);
                this.add((Component)new Label(T._("Drive Redirection not available") + ": " + e.getMessage()), "Center");
            }
        }
        this.codeLoaded = true;
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        this.drvTitle = new JLabel("Drive Redirection", 0);
        this.drvTitle.setFont(new Font("Helvetica", 3, 14));
        this.mainPanel = new JPanel(new GridLayout(this.msNo, 1));
    }

    public void loadPanels(RFBProfile profile) {
        this.settingsPanels = new DrvRedirSettingsPanel[this.msNo];
        this.logpanes = new Logger[this.msNo];
        this.loggers = new PrintStream[this.msNo];
        for (int i = 0; i < this.msNo; ++i) {
            JPanel panel = new JPanel(new BorderLayout());
            this.logpanes[i] = new Logger("", this, this.debug);
            this.loggers[i] = this.logpanes[i].getPrintStream();
            this.settingsPanels[i] = new DrvRedirSettingsPanel(profile, this.loggers[i], this.msNo, i, this.drvAccess[i]);
            panel.add((Component)this.settingsPanels[i], "North");
            JPanel logpaneContainer = new JPanel();
            logpaneContainer.setLayout(new BorderLayout(3, 1));
            logpaneContainer.add((Component)this.logpanes[i], "Center");
            logpaneContainer.add((Component)new Label(""), "East");
            panel.add((Component)logpaneContainer, "Center");
            this.mainPanel.add(panel);
        }
        this.drvPanel = new JPanel();
        this.drvPanel.setBorder(BorderFactory.createTitledBorder(T._("Drive Redirection")));
        this.drvPanel.add(this.mainPanel);
        this.add((Component)this.drvPanel, "Center");
    }

    private DrvRedirNative loadNativeCode(URL codeBase) throws Exception {
        DrvRedirNative drvAccess = new DrvRedirNative(codeBase);
        if (!drvAccess.isSupportedByOSVersion()) {
            throw new IOException(T._("Windows Version not supported."));
        }
        return drvAccess;
    }

    @Override
    public void close() {
        if (this.settingsPanels != null) {
            for (int i = 0; i < this.settingsPanels.length; ++i) {
                this.settingsPanels[i].close();
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled && this.settingsPanels != null) {
            for (int i = 0; i < this.settingsPanels.length; ++i) {
                this.settingsPanels[i].setEnabled(enabled);
            }
        }
        super.setEnabled(enabled);
    }

    @Override
    public void handleFocus(Component c) {
    }

    @Override
    public void open() {
        if (!this.codeLoaded) {
            try {
                for (int i = 0; i < this.msNo; ++i) {
                    this.drvAccess[i] = this.loadNativeCode(this.codeBase);
                }
                this.remove(this.initLabel);
                this.loadPanels(this.profile);
            }
            catch (Exception e) {
                this.remove(this.initLabel);
                this.add((Component)new JLabel(T._("Drive Redirection not available") + ": " + e.getMessage()), "Center");
            }
        }
        this.codeLoaded = true;
    }

    public void emptyTitledBorder() {
        this.drvPanel.setBorder(BorderFactory.createTitledBorder(""));
    }

    public void setDriveConnectButtonEnabled(int drive, boolean isEnabled) {
        if (this.settingsPanels != null && this.settingsPanels[drive] != null) {
            this.settingsPanels[drive].setConnectButtonEnabled(isEnabled);
        }
    }

    public boolean isDriveConnectButtonEnabled(int drive) {
        if (this.settingsPanels != null && this.settingsPanels[drive] != null) {
            return this.settingsPanels[drive].isConnectButtonEnabled();
        }
        return false;
    }

    public void setDriveDisconnectButtonEnabled(int drive, boolean isEnabled) {
        if (this.settingsPanels != null && this.settingsPanels[drive] != null) {
            this.settingsPanels[drive].setDisconnectButtonEnabled(isEnabled);
        }
    }

    public boolean isDriveDisonnectButtonEnabled(int drive) {
        if (this.settingsPanels != null && this.settingsPanels[drive] != null) {
            return this.settingsPanels[drive].isDisconnectButtonEnabled();
        }
        return false;
    }
}

