/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.FindCommand;
import com.supermicro.ipmi.text.Host;
import com.supermicro.ipmi.text.HostCenter;
import com.supermicro.ipmi.text.HostManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.ShellCommand;
import com.supermicro.ipmi.text.StatusPrompt;

public class HostRunCommand
extends Command {
    StatusPrompt statusPrompt = new StatusPrompt();
    ShellCommand shell = null;

    @Override
    public void execute() throws Exception {
        int i;
        String command = "";
        if (this.getParameters() == null || this.getParameters().length < 1) {
            MOut.G(this).println("host or group name required");
            MOut.G(this).println("'curr' and 'found' are default group");
            this.statusCode = 147;
            return;
        }
        if (this.getParameters().length < 2) {
            MOut.G(this).println("command required");
            this.statusCode = 147;
            return;
        }
        Host host = HostManager.getInstance().findHost(this.getParameters()[0]);
        Host group = HostManager.getInstance().findHostGroup(this.getParameters()[0]);
        if (host == null && group == null && !this.getParameters()[0].equals("found") && !this.getParameters()[0].equals("curr")) {
            MOut.G(this).println("cannot find \"" + this.getParameters()[0] + "\" !");
            this.statusCode = 147;
            return;
        }
        for (i = 1; i < this.getParameters().length; ++i) {
            command = command + this.getParameters()[i] + " ";
        }
        if (this.shell == null) {
            this.shell = new ShellCommand();
            this.shell.newParser();
        }
        if (host != null) {
            this.helpRunCommand(host, this.shell, command);
        }
        if (group != null) {
            for (Host aSubHost : group.subHosts) {
                try {
                    this.helpRunCommand(aSubHost, this.shell, command);
                }
                catch (Exception ex) {
                    MOut.G(this).println(ex.getMessage());
                }
            }
        }
        if (this.getParameters()[0].equals("found")) {
            for (Object item : FindCommand.foundDevice.keySet()) {
                Host tempHost = new Host();
                tempHost.setIp(item.toString());
                tempHost.setHostType(0);
                tempHost.setName(this.config.getUserName());
                tempHost.setPassword(this.config.getPassword());
                try {
                    this.helpRunCommand(tempHost, this.shell, command);
                }
                catch (Exception ex) {
                    MOut.G(this).println(ex.getMessage());
                }
            }
        } else if (this.getParameters()[0].equals("curr")) {
            for (i = 0; i < HostCenter.getInstance().size(); ++i) {
                Object item;
                item = HostCenter.getInstance().getHost(i);
                Host tempHost = new Host();
                tempHost.setIp(((IPMIInterfaceConfig)item).getIp());
                tempHost.setHostType(0);
                tempHost.setName(((IPMIInterfaceConfig)item).getUserName());
                tempHost.setPassword(((IPMIInterfaceConfig)item).getPassword());
                try {
                    this.helpRunCommand(tempHost, this.shell, command);
                    continue;
                }
                catch (Exception ex) {
                    MOut.G(this).println(ex.getMessage());
                }
            }
        }
        this.statusCode = 0;
    }

    public void helpRunCommand(Host host, ShellCommand shell, String command) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(host.getIp());
        if (host.getUsername() == null) {
            config.setUserName(this.config.getUserName());
        } else {
            config.setUserName(host.getUsername());
        }
        if (host.getPassword() == null) {
            config.setPassword(this.config.getPassword());
        } else {
            config.setPassword(host.getPassword());
        }
        config.setTimeout(this.config.getTimeout());
        config.setRetry(this.config.getRetry());
        shell.setConfig(config);
        this.statusPrompt.setIPMIInterfaceConfig(config);
        this.statusPrompt.updateStatus();
        MOut.G(this).println("[" + this.statusPrompt.getPromptString() + "]");
        shell.processCommand(command);
    }
}

