/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.stunnel.BaseStunnel;
import com.supermicro.ipmi.stunnel.StunnelFacotry;
import com.supermicro.ipmi.stunnel.WindowsStunnel;
import com.supermicro.ipmi.text.MOut;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class StunnelUtility {
    private static final String KVMJAR = "iKVM.jar";
    private static final String SCJAR = "sc.jar";
    private static final String KOJAR = "ko.jar";
    private static final String KVM = "iKVM";
    private static final String SC = "sc";
    private static final String KO = "ko";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String configAndStartStunnel(String remoteIP, String localIP, String command, String kvmPort) throws Exception {
        long endTime;
        command = command == null || "".equals(command.trim()) ? "unknow" : command;
        String OS = StunnelUtility.checkOS();
        BaseStunnel stunnel = StunnelFacotry.createStunnel(OS);
        String tempDIR = System.getProperty("java.io.tmpdir");
        tempDIR = tempDIR + File.separator + "BMCSecurity" + File.separator;
        StunnelUtility.CopyStunnelConfigToTemp(tempDIR, stunnel);
        String localStunnelPort = StunnelUtility.getRandomConnectPort() + "";
        if ("49999".equals(localStunnelPort)) {
            return localStunnelPort;
        }
        String lockFilePath = tempDIR + "lockKey.txt";
        FileChannel channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
        FileLock lock = channel.lock();
        try {
            Thread.sleep(500L);
            StunnelUtility.removeClosedHostFromConfig(tempDIR);
            StunnelUtility.addHostTolConfig(remoteIP, localStunnelPort, tempDIR, localIP, command, kvmPort);
            Thread.sleep(500L);
            StunnelUtility.startStunnel(tempDIR, stunnel);
        }
        catch (Exception e) {
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            channel.close();
        }
        long startTime = System.currentTimeMillis();
        while (!StunnelUtility.isPortUsed(Integer.parseInt(localStunnelPort)) && ((endTime = System.currentTimeMillis()) - startTime) / 1000L <= 4L) {
            StunnelUtility.startStunnel(tempDIR, stunnel);
            Thread.sleep(1000L);
        }
        return localStunnelPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopyStunnelConfigToTemp(String path, BaseStunnel stunnel) {
        String OS = StunnelUtility.checkOS();
        File tempFile = new File(path);
        if (!tempFile.exists()) {
            tempFile.mkdir();
        }
        String jarPath = StunnelUtility.getJarPath(StunnelUtility.class) + File.separator;
        FileInputStream inputStream = null;
        String tempLockPath = path + "lockKey.txt";
        File lockFile = new File(tempLockPath);
        if (!lockFile.exists()) {
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "lockKey.txt"));
                StunnelUtility.doCreateTempFile(inputStream, lockFile, tempLockPath);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            String lockFilePath = path + "lockKey.txt";
            channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
            lock = ((FileChannel)channel).lock();
            String tempFilePath = path + "mail.pem";
            tempFile = new File(tempFilePath);
            if (!tempFile.exists()) {
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "mail.pem"));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                }
                catch (Exception e) {
                    MOut.G().println("Can not find mail.pem under SMCIPMITool(IPMIView) directory");
                }
            }
            boolean neeInstall = false;
            String[] stunnelSource = stunnel.getNativeSource();
            for (int i = 0; i < stunnelSource.length; ++i) {
                tempFilePath = path + stunnelSource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i]));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                    if (OS.indexOf("Windows") <= -1 || i != 0) continue;
                    neeInstall = true;
                    continue;
                }
                catch (Exception e) {
                    MOut.G().println("Can not find BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i] + " under SMCIPMITool(IPMIView) directory");
                    MOut.G().println("This might cause ikvm can not start via stunnel");
                }
            }
            if (neeInstall) {
                String absolutePath = path + "stunnel.exe -install -quiet";
                File file = new File(absolutePath);
                String cmd = file.toString();
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("stunnel install failure");
                }
            }
        }
        catch (Exception e) {
            MOut.G().println("stunnel install fail");
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                channel.close();
            }
            catch (IOException e) {
                MOut.G().println("close lock file fail");
            }
        }
    }

    public static void addHostTolConfig(String ip, String port, String path, String localIP, String command, String kvmPort) {
        boolean removeLast = false;
        String str = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String OS = StunnelUtility.checkOS();
            while ((str = bufferedReader.readLine()) != null) {
                if (OS.indexOf("Windows") == -1 && str.indexOf("cert") > -1) {
                    String[] splitCert = str.split("=");
                    str = splitCert[0] + "=" + path + "mail.pem";
                    str.trim();
                }
                stringBuffer.append(str);
                stringBuffer.append("\r\n");
            }
            if (!removeLast) {
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("[HOST_" + command + "]");
            stringBuffer.append("\r\n");
            stringBuffer.append("client = yes");
            stringBuffer.append("\r\n");
            stringBuffer.append("accept = " + localIP + ":" + port);
            stringBuffer.append("\r\n");
            stringBuffer.append("connect = " + ip + ":" + kvmPort);
            stringBuffer.append("\r\n");
            bufferedReader.close();
            PrintWriter writer = new PrintWriter(path + "stunnel.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            MOut.G().println("Read BaseStunnel.CONFIG Failure");
        }
        catch (IOException e) {
            MOut.G().println(" BufferedReader  Failure");
        }
    }

    public static List<String> removeClosedHostFromConfig(String path) {
        ArrayList<String> list = new ArrayList<String>();
        String OS = StunnelUtility.checkOS();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String str = "";
            String lastStr = null;
            StringBuffer tempBuffer = new StringBuffer();
            boolean iskeepInConf = false;
            boolean skipSapce = false;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("HOST_") > -1 || str.indexOf("client") > -1 && str.indexOf("=") > -1 || str.indexOf("accept") > -1 || str.indexOf("connect") > -1) {
                    tempBuffer.append(str);
                    tempBuffer.append("\r\n");
                    if (str.indexOf("accept") > -1) {
                        String[] splitAccept = str.split(":");
                        String stunnelPort = splitAccept[1].trim();
                        if (OS.indexOf("Windows") > -1) {
                            if (StunnelUtility.isHostStillConnectByJPS(stunnelPort)) {
                                iskeepInConf = true;
                            }
                        } else if (StunnelUtility.isHostStillConnectInLinux(path, stunnelPort)) {
                            iskeepInConf = true;
                        }
                        skipSapce = false;
                    }
                    if (str.indexOf("connect") <= -1) continue;
                    if (iskeepInConf) {
                        stringBuffer.append(tempBuffer.toString());
                    } else {
                        skipSapce = true;
                    }
                    iskeepInConf = false;
                    tempBuffer.setLength(0);
                    continue;
                }
                if (!str.equals(lastStr)) {
                    stringBuffer.append(str);
                } else {
                    skipSapce = true;
                }
                if (!skipSapce) {
                    stringBuffer.append("\r\n");
                }
                lastStr = str;
            }
            bufferedReader.close();
            PrintWriter writer = new PrintWriter(path + "stunnel.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
            writer.close();
        }
        catch (Exception e) {
            MOut.G().println("parseStunnelConfig failure ");
        }
        return list;
    }

    public static void startStunnel(String path, BaseStunnel stunnel) {
        String OS = StunnelUtility.checkOS();
        Process process = null;
        String absolutePath = "";
        String executeSource = stunnel.getNativeSource()[0];
        if (OS.indexOf("Windows") > -1) {
            try {
                absolutePath = path + executeSource + " -start -quiet";
                File file = new File(absolutePath);
                String cmd = file.toString();
                process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
                Thread.sleep(500L);
                absolutePath = path + executeSource + " -reload -quiet";
                file = new File(absolutePath);
                cmd = file.toString();
                process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
            }
            catch (Exception e) {
                MOut.G().println("start stunnel Failed");
            }
        } else {
            int pid = StunnelUtility.getPIDinLinux(path, executeSource);
            if (pid == -1) {
                String filePath = "";
                String configPath = path + "stunnel.conf";
                filePath = path + executeSource;
                File file = new File(filePath + " " + configPath);
                String cmd = file.toString();
                try {
                    process = Runtime.getRuntime().exec(cmd);
                    process.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("start stunnel Failed");
                }
            } else {
                try {
                    ProcessBuilder builder = new ProcessBuilder("pkill", "-HUP", executeSource);
                    builder.redirectErrorStream(true);
                    InputStream inputStream = null;
                    BufferedReader bufferedReader = null;
                    process = builder.start();
                    process.waitFor();
                    inputStream = process.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String str = "";
                    while ((str = bufferedReader.readLine()) != null) {
                        if (str.indexOf("Operation not permitted") > -1) {
                            MOut.G().println("Please type sudo before operation.");
                            continue;
                        }
                        MOut.G().println(str);
                    }
                }
                catch (Exception e) {
                    MOut.G().println("reload stunnel Failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCreateTempFile(FileInputStream paramInputStream, File paramFile, String tempFilePath) {
        FileChannel srcChannel = paramInputStream.getChannel();
        RandomAccessFile destFile = null;
        FileChannel destChannel = null;
        FileLock destLock = null;
        if (!paramFile.exists()) {
            try {
                destFile = new RandomAccessFile(paramFile, "rw");
                destChannel = destFile.getChannel();
                destLock = destChannel.lock();
                File isExit = new File(tempFilePath);
                if (isExit.exists() && isExit.length() > 0L) {
                } else {
                    StunnelUtility.copyFileChannels(srcChannel, destChannel);
                }
            }
            catch (IOException e) {
                MOut.G().println("CreateTempFile Failed " + e);
            }
            finally {
                try {
                    if (destLock != null) {
                        destLock.release();
                    }
                    if (destChannel != null) {
                        destChannel.close();
                    }
                    srcChannel.close();
                    paramInputStream.close();
                    String OS = StunnelUtility.checkOS();
                    if (OS.indexOf("Windows") == -1) {
                        String chmodStunnel = "chmod 777 ";
                        Process process = Runtime.getRuntime().exec(chmodStunnel + " " + tempFilePath);
                        process.waitFor();
                    }
                }
                catch (Exception e) {
                    MOut.G().println("close CreateTempFile Failed " + e);
                }
            }
        }
    }

    protected static void copyFileChannels(FileChannel src, FileChannel dest) throws IOException {
        long count;
        long size = src.size();
        int s_byteBuffer = 10240;
        for (long pos = 0L; pos < size; pos += dest.transferFrom(src, pos, count)) {
            count = size - pos > (long)s_byteBuffer ? (long)s_byteBuffer : size - pos;
        }
    }

    public static int getRandomConnectPort() {
        long startTime = System.currentTimeMillis();
        int port = (int)(Math.random() * 15536.0 + 50000.0);
        while (StunnelUtility.isPortUsed(port)) {
            port = (int)(Math.random() * 15536.0 + 50000.0);
            long endTime = System.currentTimeMillis();
            if ((endTime - startTime) / 1000L <= 5L) continue;
            port = 49999;
            break;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isPortUsed(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        boolean result = true;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            result = false;
            return result;
        }
        catch (IOException e) {
            result = true;
            e.getStackTrace();
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            return result;
        }
    }

    public static int getPIDinLinux(String path, String executeSource) {
        int pid = -1;
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", path + executeSource});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            String[] splitOutput = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i).indexOf("grep") >= 0) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = output.split(" ");
                pid = Integer.parseInt(splitOutput[1]);
            }
        }
        catch (Exception e) {
            MOut.G().println("get PID Failed");
        }
        return pid;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = StunnelUtility.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return StunnelUtility.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    static boolean isHostStillConnectByJPS(String stunnelPort) {
        File bundleJRe;
        File jre = new File("jre");
        String jps = "jps.exe";
        if (jre.isDirectory() && (bundleJRe = new File(".\\jre\\bin\\jps.exe")).exists()) {
            jps = ".\\jre\\bin\\jps.exe";
        }
        ProcessBuilder builder = new ProcessBuilder(jps, "-lm");
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            Process process = builder.start();
            process.waitFor();
            inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String str = "";
            while ((str = bufferedReader.readLine()) != null) {
                String[] splitStr;
                if (str.indexOf(KVMJAR) <= -1 && str.indexOf(SCJAR) <= -1 && str.indexOf(KOJAR) <= -1 || !stunnelPort.equals((splitStr = str.split(" "))[6])) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warging: jps not support");
        }
        return false;
    }

    static boolean isHostStillConnectByTaskList(String stunnelPort) {
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"tasklist", "/v"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"findstr", "java"});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            for (int i = 0; i < result.size(); ++i) {
                output = result.get(i);
                if ((output = output.replaceAll("\\s{1,}", " ").trim()).indexOf(KVM) <= -1 && output.indexOf(SC) <= -1 && output.indexOf(KO) <= -1 || output.indexOf(stunnelPort) <= -1) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warging: tasklist not support");
        }
        return false;
    }

    static boolean isHostStillConnectInLinux(String path, String stunnelPort) {
        String port = "";
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", "java"});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            String[] splitOutput = null;
            int index = 0;
            for (int i = 0; i < result.size(); ++i) {
                index = result.get(i).indexOf(KVMJAR);
                if (index <= -1 && (index = result.get(i).indexOf(SCJAR)) <= -1 && (index = result.get(i).indexOf(KOJAR)) <= -1) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = (output = output.substring(index).trim()).split(" ");
                port = splitOutput[4];
                if (!stunnelPort.equals(port)) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("ps -ef | grep java failure");
        }
        return false;
    }

    public static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static String checkOS() {
        return System.getProperty("os.name") + ":" + System.getProperty("os.arch");
    }

    public static boolean isIPv6(String ip) {
        try {
            InetAddress localInetAddress = InetAddress.getByName(ip);
            if (localInetAddress instanceof Inet6Address) {
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("parse ip format fail");
        }
        return false;
    }

    public static String getJarPath(Class myClass) {
        String jarDir = "";
        try {
            CodeSource codeSource = myClass.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            jarDir = jarFile.getParentFile().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jarDir;
    }

    public static void main(String[] args) {
        StunnelUtility utility = new StunnelUtility();
        String OS = utility.checkOS();
        WindowsStunnel stunnel = new WindowsStunnel(OS);
        String tempDIR = System.getProperty("java.io.tmpdir");
        tempDIR = tempDIR + File.separator + "stunnel" + File.separator;
        StunnelUtility.removeClosedHostFromConfig(tempDIR);
        StunnelUtility.addHostTolConfig("10.136.176.9", "65537", tempDIR, "127.0.0.1", KVM, "3520");
    }
}

