/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;

public class SystemMiscInfo
extends AbstractModuleInfo {
    public byte fanMode;
    public byte userFanSpeed;
    public byte curFanSpeed;
    public byte dummmy;
    public byte[] totalPwrWatt;
    public byte[] remainPwrWatt;
    public byte curNumPS;
    public byte fpPwrLed;
    public byte fpErrLed;
    public byte rueset2DefaultCount;
    public byte maxTemp;
    public byte maxSystemTemp;
    public byte maxCPUTemp;
    public byte maxPCHTemp;
    public byte maxGPUTemp;
    public byte maxTempModuleType;
    public byte maxTempModuleSlot;
    public byte upDownFanSpeedstair;
    public byte maxFanSpeedLevel;
    public byte maxSystemFanSpeedLevel;
    public byte maxCPUFanSpeedLevel;
    public byte maxPCHFanSpeedLevel;
    public byte maxGPUFanSpeedLevel;
    public byte[] reserved1;
    public byte overHeatBit;
    public byte overPowerBit;
    public byte fanFailBit;
    public byte presentScanDoneBit;
    public byte debugTempBit;
    public byte debugDisableBladeScan;
    public byte debugDisableSwitchScan;
    public byte debugDisablePSUScan;
    public byte debugTempSetting;
    public byte overHeatModule;
    public byte overHeatModuleSlot;
    public byte[] powerSupplyReq;
    public byte[] switchReq;
    public byte[] bladeReq;
    public byte[] bladeIPMBScanAlive;
    public byte[] bladeLanScanAlive;
    public byte[] switchScanAlive;
    public byte[] pSUScanAlive;
    public byte[] reserved;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.fanMode = raw[index++];
        this.userFanSpeed = raw[index++];
        this.curFanSpeed = raw[index++];
        this.dummmy = raw[index++];
        this.totalPwrWatt = ByteUtility.getBytes(raw, index, 2);
        this.remainPwrWatt = ByteUtility.getBytes(raw, index += 2, 2);
        index += 2;
        this.curNumPS = raw[index++];
        this.fpPwrLed = raw[index++];
        this.rueset2DefaultCount = raw[index++];
        this.maxTemp = raw[index++];
        this.maxSystemTemp = raw[index++];
        this.maxCPUTemp = raw[index++];
        this.maxPCHTemp = raw[index++];
        this.maxGPUTemp = raw[index++];
        this.maxTempModuleType = raw[index++];
        this.maxTempModuleSlot = raw[index++];
        this.upDownFanSpeedstair = raw[index++];
        this.maxFanSpeedLevel = raw[index++];
        this.maxSystemFanSpeedLevel = raw[index++];
        this.maxCPUFanSpeedLevel = raw[index++];
        this.maxPCHFanSpeedLevel = raw[index++];
        this.maxGPUFanSpeedLevel = raw[index++];
        this.reserved1 = ByteUtility.getBytes(raw, index, 3);
        this.overHeatBit = raw[index += 3];
        this.overPowerBit = raw[index];
        this.fanFailBit = raw[index];
        this.presentScanDoneBit = raw[index];
        this.debugTempBit = raw[index];
        this.debugDisableBladeScan = raw[index];
        this.debugDisableSwitchScan = raw[index];
        this.debugDisablePSUScan = raw[index++];
        this.debugTempSetting = raw[index++];
        this.overHeatModule = raw[index++];
        this.overHeatModuleSlot = raw[index++];
        this.powerSupplyReq = ByteUtility.getBytes(raw, index, 4);
        this.switchReq = ByteUtility.getBytes(raw, index += 4, 4);
        this.bladeReq = ByteUtility.getBytes(raw, index += 4, 4);
        this.bladeIPMBScanAlive = ByteUtility.getBytes(raw, index += 4, 4);
        this.bladeLanScanAlive = ByteUtility.getBytes(raw, index += 4, 4);
        this.switchScanAlive = ByteUtility.getBytes(raw, index += 4, 4);
        this.pSUScanAlive = ByteUtility.getBytes(raw, index += 4, 4);
        this.reserved = ByteUtility.getBytes(raw, index += 4, 8);
        index += 8;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("fanMode =" + this.fanMode);
        sb.append("\nuserFanSpeed =" + this.userFanSpeed);
        sb.append("\ncurFanSpeed =" + this.curFanSpeed);
        sb.append("\ndummmy =" + this.dummmy);
        sb.append("\ntotalPwrWatt =" + this.getTotalPwrWatt());
        sb.append("\nremainPwrWatt =" + this.getRemainPwrWatt());
        sb.append("\ncurNumPS =" + this.curNumPS);
        sb.append("\nfpPwrLed =" + this.fpPwrLed);
        sb.append("\nfpErrLed =" + this.fpErrLed);
        sb.append("\nrueset2DefaultCount =" + this.rueset2DefaultCount);
        sb.append("\nmaxTemp =" + this.maxTemp);
        sb.append("\nmaxSystemTemp =" + this.maxSystemTemp);
        sb.append("\nmaxCPUTemp =" + this.maxCPUTemp);
        sb.append("\nmaxPCHTemp =" + this.maxPCHTemp);
        sb.append("\nmaxGPUTemp =" + this.maxGPUTemp);
        sb.append("\nmaxTempModuleType =" + this.maxTempModuleType);
        sb.append("\nmaxTempModuleSlot =" + this.maxTempModuleSlot);
        sb.append("\nupDownFanSpeedstair =" + this.upDownFanSpeedstair);
        sb.append("\nmaxFanSpeedLevel =" + this.maxFanSpeedLevel);
        sb.append("\nmaxSystemFanSpeedLevel =" + this.maxSystemFanSpeedLevel);
        sb.append("\nmaxCPUFanSpeedLevel =" + this.maxCPUFanSpeedLevel);
        sb.append("\nmaxPCHFanSpeedLevel =" + this.maxPCHFanSpeedLevel);
        sb.append("\nmaxGPUFanSpeedLevel =" + this.maxGPUFanSpeedLevel);
        sb.append("\nreserved1 =" + ByteUtility.bytesToHex(this.reserved1));
        sb.append("\noverHeatBit =" + this.overHeatBit);
        sb.append("\noverHeatBit =" + this.isOverHeat());
        sb.append("\noverPowerBit =" + this.isOverPower());
        sb.append("\nfanFailBit =" + this.isFanFail());
        sb.append("\npresentScanDoneBit =" + this.presentScanDone());
        sb.append("\ndebugTempBit =" + this.debugTemp());
        sb.append("\ndebugDisableBladeScan =" + this.debugDisableBladeScan());
        sb.append("\ndebugDisableSwitchScan =" + this.debugDisableSwitchScan());
        sb.append("\ndebugDisablePSUScan =" + this.debugDisablePSUScan());
        sb.append("\ndebugTempSetting =" + this.debugTempSetting);
        sb.append("\noverHeatModule =" + this.overHeatModule);
        sb.append("\noverHeatModuleSlot =" + this.overHeatModuleSlot);
        sb.append("\npowerSupplyReq =" + this.getPowerSupplyReq());
        sb.append("\nswitchReq =" + this.getSwitchReq());
        sb.append("\nbladeReq =" + this.getBladeReq());
        sb.append("\nbladeIPMBScanAlive =" + this.getBladeIPMBScanAlive());
        sb.append("\nbladeLanScanAlive =" + this.getBladeLanScanAlive());
        sb.append("\nswitchScanAlive =" + this.getSwitchScanAlive());
        sb.append("\npSUScanAlive =" + this.getPSUScanAlive());
        sb.append("\nreserved =" + ByteUtility.bytesToHex(this.reserved));
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public int getTotalPwrWatt() {
        return ByteUtility.twoBytesToInt(this.totalPwrWatt);
    }

    public int getRemainPwrWatt() {
        return ByteUtility.twoBytesToInt(this.remainPwrWatt);
    }

    public boolean isOverHeat() {
        return (byte)(this.overHeatBit & 1) == 1;
    }

    public boolean isOverPower() {
        return (byte)(this.overPowerBit & 2) == 2;
    }

    public boolean isFanFail() {
        return (byte)(this.fanFailBit & 4) == 4;
    }

    public boolean presentScanDone() {
        return (byte)(this.presentScanDoneBit & 8) == 8;
    }

    public boolean debugTemp() {
        return (byte)(this.debugTempBit & 0x10) == 16;
    }

    public boolean debugDisableBladeScan() {
        return (byte)(this.debugDisableBladeScan & 0x20) == 32;
    }

    public boolean debugDisableSwitchScan() {
        return (byte)(this.debugDisableSwitchScan & 0x40) == 64;
    }

    public boolean debugDisablePSUScan() {
        return (byte)(this.debugDisablePSUScan & 0x80) == -128;
    }

    public int getPowerSupplyReq() {
        return ByteUtility.fourBytesToInt(this.powerSupplyReq);
    }

    public int getSwitchReq() {
        return ByteUtility.fourBytesToInt(this.switchReq);
    }

    public int getBladeReq() {
        return ByteUtility.fourBytesToInt(this.bladeReq);
    }

    public int getBladeIPMBScanAlive() {
        return ByteUtility.fourBytesToInt(this.bladeIPMBScanAlive);
    }

    public int getBladeLanScanAlive() {
        return ByteUtility.fourBytesToInt(this.bladeLanScanAlive);
    }

    public int getSwitchScanAlive() {
        return ByteUtility.fourBytesToInt(this.switchScanAlive);
    }

    public int getPSUScanAlive() {
        return ByteUtility.fourBytesToInt(this.pSUScanAlive);
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "System Misc", "M/S", "Status"));
        header.append(String.format(formatTemplate, "---", "---", "------"));
        return header.toString();
    }

    public String toFormatedString() {
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "CMM " + this.getIndex();
        formatedString.append(String.format(formatTemplate, index, this.fanMode, this.userFanSpeed));
        return formatedString.toString();
    }
}

