/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;
import com.supermicro.ipmi.microblade.GB;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;

public class SwitchInfo
extends AbstractModuleInfo {
    public byte present;
    public byte switchType;
    public byte initialized;
    public byte powerStatus;
    public byte uid;
    public byte uidbtnReleased;
    public byte bit4_sysok;
    public byte unused2;
    public byte temp;
    public byte[] selReport;
    public byte error;
    public byte[] modelName;
    public byte[] modelVersion;
    public byte ipSrc;
    public byte[] ipAddr;
    public byte[] netMask;
    public byte[] gateway;
    public byte[] userName;
    public byte[] password;
    public byte[] dateTime;
    public GB gb;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.present = raw[index++];
        this.switchType = raw[index++];
        this.initialized = raw[index];
        this.powerStatus = raw[index];
        this.uid = raw[index];
        this.uidbtnReleased = raw[index];
        this.bit4_sysok = raw[index];
        this.unused2 = raw[index++];
        this.temp = raw[index++];
        this.selReport = ByteUtility.getBytes(raw, index, 4);
        index += 4;
        this.error = raw[index++];
        this.modelName = ByteUtility.getBytes(raw, index, 17);
        this.modelVersion = ByteUtility.getBytes(raw, index += 17, 5);
        index += 5;
        this.ipSrc = raw[index++];
        this.ipAddr = ByteUtility.getBytes(raw, index, 4);
        this.netMask = ByteUtility.getBytes(raw, index += 4, 4);
        this.gateway = ByteUtility.getBytes(raw, index += 4, 4);
        this.userName = ByteUtility.getBytes(raw, index += 4, 25);
        this.password = ByteUtility.getBytes(raw, index += 25, 25);
        this.dateTime = ByteUtility.getBytes(raw, index += 25, 8);
        this.gb = new GB();
        byte[] subRaw = ByteUtility.getBytes(raw, index += 8, 7);
        index += 7;
        this.gb.fromRaw(subRaw);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("present =" + this.present);
        sb.append("\npresent =" + this.isPresent());
        sb.append("\nswitchType =" + this.switchType);
        sb.append("\ninitialized =" + this.isInitialized());
        sb.append("\npowerStatus =" + this.getPowerStatus());
        sb.append("\nuid =" + this.getUid());
        sb.append("\nunused2 =" + this.getUnused2());
        sb.append("\ntemp =" + this.temp);
        sb.append("\nselReport =" + this.getSelReport());
        sb.append("\nerror =" + this.error);
        sb.append("\nmodelName =" + this.getModelName());
        sb.append("\nipSrc =" + this.ipSrc);
        sb.append("\nipAddr =" + this.getIPAddr());
        sb.append("\nnetMask =" + this.getNetMask());
        sb.append("\ngateway =" + this.getGateway());
        sb.append("\nuserName =" + this.getDecryptedUsername());
        sb.append("\npassword =" + this.getDecryptedPassword());
        sb.append("\ndateTime =" + this.getDateTime());
        sb.append("\ngb :" + this.gb);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean isPresent() {
        return (byte)(this.present & 1) == 1;
    }

    public boolean isInitialized() {
        return (byte)(this.initialized & 1) == 1;
    }

    public boolean getPowerStatus() {
        return (byte)(this.powerStatus & 2) == 2;
    }

    public boolean getUid() {
        return (byte)(this.uid & 4) == 4;
    }

    public boolean getUidBTNReleased() {
        return (byte)(this.uidbtnReleased & 8) == 8;
    }

    public boolean getBit4_SysOK() {
        return (byte)(this.bit4_sysok & 0x10) == 16;
    }

    public byte getUnused2() {
        return (byte)(this.unused2 & 0xF8);
    }

    public byte getIPSRC() {
        return this.ipSrc;
    }

    public int getSelReport() {
        return ByteUtility.fourBytesToInt(this.selReport);
    }

    public String getModelName() {
        return new String(this.modelName).trim();
    }

    public String getIPAddr() {
        return (this.ipAddr[0] & 0xFF) + "." + (this.ipAddr[1] & 0xFF) + "." + (this.ipAddr[2] & 0xFF) + "." + (this.ipAddr[3] & 0xFF);
    }

    public String getNetMask() {
        return (this.netMask[0] & 0xFF) + "." + (this.netMask[1] & 0xFF) + "." + (this.netMask[2] & 0xFF) + "." + (this.netMask[3] & 0xFF);
    }

    public String getGateway() {
        return (this.gateway[0] & 0xFF) + "." + (this.gateway[1] & 0xFF) + "." + (this.gateway[2] & 0xFF) + "." + (this.gateway[3] & 0xFF);
    }

    public String getDecryptedUsername() {
        String str = "";
        try {
            byte[] b = ByteUtility.getBytes(this.userName, 0, 24);
            boolean empty = true;
            for (byte b1 : this.userName) {
                if (b1 == 0) continue;
                empty = false;
            }
            if (empty) {
                return "";
            }
            str = NodeRemoteInfo.blowFishDecrypt(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public String getDecryptedPassword() {
        String str = "";
        try {
            byte[] b = ByteUtility.getBytes(this.password, 0, 24);
            str = NodeRemoteInfo.blowFishDecrypt(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public String getUserName() {
        return new String(this.userName).trim();
    }

    public String getDateTime() {
        return String.format("%d-%d-%d %d:%d:%d", this.dateTime[5], this.dateTime[4], this.dateTime[7] * 100 + this.dateTime[6], this.dateTime[2], this.dateTime[1], this.dateTime[0]).toString();
    }

    public static final int getIndex(String index) {
        int alternateIndex = -1;
        if (index.equalsIgnoreCase("A1")) {
            alternateIndex = 0;
        } else if (index.equalsIgnoreCase("A2")) {
            alternateIndex = 1;
        } else if (index.equalsIgnoreCase("B1")) {
            alternateIndex = 2;
        } else if (index.equalsIgnoreCase("B2")) {
            alternateIndex = 3;
        }
        return alternateIndex;
    }

    public static final String getIndex(int index) {
        String alternateIndex = null;
        switch (index) {
            case 0: {
                alternateIndex = "A1";
                break;
            }
            case 1: {
                alternateIndex = "A2";
                break;
            }
            case 2: {
                alternateIndex = "B1";
                break;
            }
            case 3: {
                alternateIndex = "B2";
            }
        }
        return alternateIndex;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        if (!this.isPresent()) {
            return "";
        }
        String status = this.getPowerStatus() && !this.getBit4_SysOK() ? "Initializing" : (this.getPowerStatus() ? "On" : "Off");
        String f = " %-30s | %20s \n";
        StringBuffer stringBuffer = new StringBuffer();
        String index = "Switch " + SwitchInfo.getIndex(this.getIndex());
        stringBuffer.append(String.format(f, "Switch", index));
        stringBuffer.append(String.format(f, "Switch Type", this.switchType == 1 ? "Gigabit Switch" : Byte.valueOf(this.switchType)));
        stringBuffer.append(String.format(f, "Model Name", this.getModelName()));
        stringBuffer.append(String.format(f, "Power Status", this.getPowerStatus() ? "On" : "Off"));
        stringBuffer.append(String.format(f, "Temperature", this.temp));
        stringBuffer.append(String.format(f, "UID", this.getUid() ? "Enabled" : "Disabled"));
        stringBuffer.append(String.format(f, "Error", status));
        stringBuffer.append(String.format(f, "Initialized", this.isInitialized() ? "OK" : "N/A"));
        stringBuffer.append(String.format(f, "IP Address", this.getIPAddr()));
        stringBuffer.append(String.format(f, "Subnet Mask", this.getNetMask()));
        stringBuffer.append(String.format(f, "Gateway", this.getGateway()));
        stringBuffer.append(String.format(f, "Date and Time", this.getDateTime()));
        stringBuffer.append(String.format(f, "User Name", this.getUserName()));
        return stringBuffer.toString();
    }
}

