/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

class KIRAConfiguration {
    IPMIInterface ipmiInterface;
    private byte[] configData;
    private byte[] reservationID = new byte[2];
    private byte[] configCRC = new byte[4];
    private int chunkSize = 0;
    private int configSize = 0;
    byte[] xorKey = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3};

    public byte[] getconfigCRC() {
        return this.configCRC;
    }

    public int getConfigSize() {
        return this.configSize;
    }

    KIRAConfiguration(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
    }

    private IPMIMessage startConfigurationBackupCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call start configuration bakcup command failed");
        }
        if (resMessage.completionCode == 0) {
            System.arraycopy(resMessage.data, 0, this.reservationID, 0, 2);
            byte[] configBytes = new byte[4];
            System.arraycopy(resMessage.data, 2, configBytes, 0, 4);
            this.configSize = ByteUtility.fourBytesToIntByLSBFirst(configBytes);
            System.arraycopy(resMessage.data, 6, this.configCRC, 0, 4);
            byte[] chunkBytes = new byte[4];
            System.arraycopy(resMessage.data, 10, chunkBytes, 0, 4);
            this.chunkSize = ByteUtility.fourBytesToIntByLSBFirst(chunkBytes);
            if (this.chunkSize > 950) {
                this.chunkSize = 950;
            }
            assert (this.configSize > 0);
            assert (this.chunkSize > 0);
        } else {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    private IPMIMessage backupConfigurationCommand(int offset, int size) throws IPMIException {
        byte[] data = new byte[10];
        System.arraycopy(this.reservationID, 0, data, 0, 2);
        ByteUtility.intTo4Bytes(data, 2, offset);
        ByteUtility.intTo4Bytes(data, 6, size);
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)97, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call backup configuration command failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    private IPMIMessage finishConfigurationBackupCommand(byte[] reservationID) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)98, reservationID);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call finish configuration backup command failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    public byte[] backupConfiguration() throws IPMIException {
        byte[] configuration = null;
        IPMIMessage resMessage = this.startConfigurationBackupCommand();
        configuration = new byte[this.configSize];
        int chunk = 0;
        for (int offset = 0; offset < this.configSize; offset += chunk) {
            chunk = this.chunkSize;
            if (chunk > this.configSize - offset) {
                chunk = this.configSize - offset;
            }
            resMessage = this.backupConfigurationCommand(offset, chunk);
            System.arraycopy(resMessage.data, 0, configuration, offset, chunk);
        }
        this.finishConfigurationBackupCommand(this.reservationID);
        return configuration;
    }

    private IPMIMessage startConfigurationRestoreCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[8];
        ByteUtility.intTo4Bytes(data, 0, this.configSize);
        System.arraycopy(this.configCRC, 0, data, 4, 4);
        ipmiMessage.setCommandAndData((byte)-64, (byte)99, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call start configuration restore failed");
        }
        if (resMessage.completionCode == 0) {
            System.arraycopy(resMessage.data, 0, this.reservationID, 0, 2);
            byte[] chunkBytes = new byte[4];
            System.arraycopy(resMessage.data, 2, chunkBytes, 0, 4);
            this.chunkSize = ByteUtility.fourBytesToIntByLSBFirst(chunkBytes);
            if (this.chunkSize > 950) {
                this.chunkSize = 950;
            }
            assert (this.chunkSize > 0);
        } else {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    private IPMIMessage restoreConfigurationCommand(int offset, int size) throws IPMIException {
        byte[] data = new byte[6 + size];
        System.arraycopy(this.reservationID, 0, data, 0, 2);
        ByteUtility.intTo4Bytes(data, 2, offset);
        System.arraycopy(this.configData, offset, data, 6, size);
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)100, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call restore configuration command failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    private IPMIMessage finishConfigurationRestoreCommand(byte[] reservationID, boolean crcCheck, byte restoreOption) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(reservationID, 0, data, 0, 2);
        data[2] = 0;
        if (crcCheck) {
            data[2] = 1;
        }
        data[3] = restoreOption;
        ipmiMessage.setCommandAndData((byte)-64, (byte)101, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call finish configuration restore command failed");
        }
        if (resMessage.completionCode == -126) {
            throw new IPMIException("CRC error");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    public boolean restoreConfiguration(byte[] configData, byte[] configCRC, boolean crcCheck, byte restoreOption) throws IPMIException {
        this.configData = configData;
        this.configCRC = configCRC;
        this.configSize = configData.length;
        IPMIMessage resMessage = this.startConfigurationRestoreCommand();
        int chunk = 0;
        for (int offset = 0; offset < this.configSize; offset += chunk) {
            chunk = this.chunkSize;
            if (chunk > this.configSize - offset) {
                chunk = this.configSize - offset;
            }
            resMessage = this.restoreConfigurationCommand(offset, chunk);
        }
        resMessage = this.finishConfigurationRestoreCommand(this.reservationID, crcCheck, restoreOption);
        return resMessage.completionCode == 0;
    }

    private IPMIMessage syncConfigurationCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{22};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call sync Configuration command failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    private IPMIMessage isSyncConfigurationFinishCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{23};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        if (resMessage == null) {
            throw new IPMIException("Call isSyncConfigurationFinishCommand failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return resMessage;
    }

    public boolean syncCMMConfiguration() throws IPMIException {
        IPMIMessage resMessage = this.syncConfigurationCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isSyncCMMConfigurationFinish();
        }
        return false;
    }

    public boolean isSyncCMMConfigurationFinish() throws IPMIException {
        IPMIMessage resMessage = this.isSyncConfigurationFinishCommand();
        if (resMessage != null) {
            switch (resMessage.completionCode) {
                case 0: {
                    return true;
                }
                case 1: {
                    throw new IPMIException("slave check crc error");
                }
                case 2: {
                    throw new IPMIException("slave write file error");
                }
                case 3: {
                    throw new IPMIException("slave create file error");
                }
                case 4: {
                    throw new IPMIException("slave reserv check error");
                }
                case 16: {
                    return false;
                }
            }
        }
        return false;
    }

    public byte[] encrypt(byte[] data) {
        byte[] encData = new byte[data.length];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            encData[i] = (byte)(data[i] ^ this.xorKey[j]);
            if (j == 63) {
                j = 0;
            }
            if (i >= data.length - 4) {
                encData[i] = data[i];
            }
            ++i;
            ++j;
        }
        return encData;
    }

    public byte[] decrypt(byte[] data) {
        byte[] decData = new byte[data.length];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            decData[i] = (byte)(data[i] ^ this.xorKey[j]);
            if (j == 63) {
                j = 0;
            }
            if (i >= data.length - 4) {
                decData[i] = data[i];
            }
            ++i;
            ++j;
        }
        return decData;
    }
}

