/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.JFCParser;

@Deprecated
public final class PresetFile {
    private static final String JRE_RELATIVE_PRESET_DIRECTORY = "lib/jfr";
    private static final String PROPERTY_JAVA_HOME = "java.home";
    private static final int MAXIMUM_FILE_SIZE = 0x100000;
    public static final String DEFAULT_PRESET_NAME = "default";
    private static volatile List<PresetProxy> knownPresets;
    private final String name;
    private final String description;
    private final EventDefaultSet eventDefaultSet;
    private final String content;
    private final String provider;

    PresetFile(String string, String string2, String string3, EventDefaultSet eventDefaultSet, String string4) {
        this.name = string;
        this.description = string2;
        this.eventDefaultSet = eventDefaultSet;
        this.content = string4;
        this.provider = string3;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EventDefaultSet getSettings() {
        return this.eventDefaultSet;
    }

    public String getContent() {
        return this.content;
    }

    public static void loadKnownPresets() throws IOException, ParseException, URISyntaxException {
        if (knownPresets == null) {
            File[] fileArray;
            ArrayList<PresetProxy> arrayList = new ArrayList<PresetProxy>();
            File file = PresetFile.getPresetFileRoot();
            if (file.exists() && (fileArray = file.listFiles(new PresetFileFilter())) != null) {
                for (File file2 : fileArray) {
                    arrayList.add(new PresetProxy(file2));
                }
            }
            knownPresets = arrayList;
        }
    }

    public static List<String> getKnownPresetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PresetProxy presetProxy : knownPresets) {
            arrayList.add(presetProxy.getName());
        }
        return arrayList;
    }

    public static PresetFile createFromName(String string) throws IOException, ParseException, URISyntaxException {
        for (PresetProxy presetProxy : knownPresets) {
            if (!presetProxy.isNamed(string)) continue;
            return presetProxy.getPresetFile();
        }
        PresetFile presetFile = PresetFile.createFromPresetLocation(string);
        if (presetFile != null) {
            return presetFile;
        }
        return PresetFile.create(new File(string));
    }

    private static PresetFile createFromPresetLocation(String string) throws IOException, ParseException, URISyntaxException {
        File file = PresetFile.getPresetFileRoot();
        if (file.exists()) {
            return PresetFile.create(file, string);
        }
        return null;
    }

    private static PresetFile create(File file, String string) throws IOException, ParseException, URISyntaxException {
        for (String string2 : Arrays.asList("", ".jfc")) {
            File file2 = new File(file, string + string2);
            if (!file2.exists() || file2.isDirectory()) continue;
            return PresetFile.create(file2);
        }
        return null;
    }

    static String readContent(File file) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = PresetFile.readContent(bufferedReader);
            return string;
        }
    }

    static String readContent(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter(1024);
        int n2 = 0;
        while ((n = reader.read()) != -1) {
            charArrayWriter.write(n);
            if (++n2 < 0x100000) continue;
            throw new IOException("Presets with more than 1048576 characters can't be read.");
        }
        return new String(charArrayWriter.toCharArray());
    }

    public static PresetFile create(File file) throws IOException, ParseException, URISyntaxException {
        return JFCParser.createPresetFile(file);
    }

    private static File getPresetFileRoot() {
        return new File(System.getProperty(PROPERTY_JAVA_HOME), JRE_RELATIVE_PRESET_DIRECTORY);
    }

    private static class PresetFileFilter
    implements FileFilter {
        private PresetFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return JFCParser.hasValidFileExtension(file);
        }
    }

    private static final class PresetProxy {
        private final String content;
        private final String filename;
        private final String name;
        private PresetFile presetFile;

        public PresetProxy(File file) throws IOException {
            this.content = PresetFile.readContent(file);
            this.filename = file.getName();
            this.name = this.filename.substring(0, this.filename.length() - ".jfc".length());
        }

        public boolean isNamed(String string) {
            return this.filename.equals(string) || this.filename.equals(string + ".jfc");
        }

        public PresetFile getPresetFile() throws IOException, ParseException {
            if (this.presetFile == null) {
                this.presetFile = JFCParser.createPresetFile(this.content);
            }
            return this.presetFile;
        }

        public String getName() {
            return this.name;
        }
    }
}

