/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserDeleteCommand
extends SuperBladeCommand {
    byte userID;

    @Override
    public boolean preValidate() {
        String usage = "Usage: user delete <user id> \n";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte privilege = ipmiMessagingCommand.getUserPrivilegeByID(this.userID);
        boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, "");
        if (!b2) {
            MOut.G(this).println("Set user password failed");
            this.statusCode = 149;
            return;
        }
        boolean b3 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, (byte)15);
        if (!b3) {
            MOut.G(this).println("clear user privilege failed");
            this.statusCode = 149;
            return;
        }
        boolean b4 = ipmiMessagingCommand.setDisableUserByID(this.userID);
        if (!b4) {
            MOut.G(this).println("disable user failed");
            this.statusCode = 149;
            return;
        }
        boolean b5 = ipmiMessagingCommand.setDisableUserPlusByID(this.userID, (byte)15);
        if (!b5) {
            MOut.G(this).println("disable user(+) failed");
            this.statusCode = 149;
            return;
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        boolean b1 = IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) ? ipmiMessagingCommand.clearUserNameByFill0XFF(this.userID) : ipmiMessagingCommand.setUserNameByID(this.userID, "");
        if (!b1) {
            MOut.G(this).println("clear user name failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

