/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperBladeTool {
    public static String version = "2.16.0";
    public static String buildNo = "160816";
    public static String softwareName = "SMC IPMI Tool V" + version + "(Build " + buildNo + ") - Super Micro Computer, Inc.";
    public static final boolean DEBUG = false;

    public static void main(String[] args) {
        SuperBladeTool smcIPMITool = new SuperBladeTool();
        smcIPMITool.execute(args);
    }

    public void execute(String[] args) {
        SuperBladeTool.setMiscOption();
        try {
            SuperBladeTool.addDir(".");
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        if (args.length < 3) {
            SuperBladeTool.usage();
            System.exit(182);
        }
        Parser parser = new Parser();
        String ip = args[0];
        String username = args[1];
        String password = args[2];
        if (!SuperBladeTool.validateIP(ip) && !SuperBladeTool.validateIPv6(ip)) {
            try {
                InetAddress giriAddress = InetAddress.getByName(args[0]);
                ip = giriAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                MOut.G().println("IP or Domain name error !");
                System.exit(181);
            }
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        String[] subArgs = new String[args.length - 3];
        System.arraycopy(args, 3, subArgs, 0, subArgs.length);
        Command command = null;
        try {
            command = parser.parse(parser.argumentRoot, subArgs);
        }
        catch (CommandIncompleteException e) {
            System.exit(0);
        }
        if (command == null) {
            System.exit(180);
        }
        command.setConfig(config);
        command.setOriginalParser(parser);
        try {
            command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(command.getStatusCode());
    }

    public static void usage() {
        MOut.G().println("");
        MOut.G().println(softwareName);
        MOut.G().println("Usage:");
        MOut.G().println("      SMCIPMITool <IP> <username> <password> [commands ... ]");
    }

    public static void ver() {
        MOut.G().println(softwareName);
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }

    public static boolean validateIPv6(String inet6Address) {
        boolean containsCompressedZeroes;
        boolean bl = containsCompressedZeroes = inet6Address.indexOf("::") > -1;
        if (containsCompressedZeroes && inet6Address.indexOf("::") != inet6Address.lastIndexOf("::")) {
            return false;
        }
        if (inet6Address.startsWith(":") && !inet6Address.startsWith("::") || inet6Address.endsWith(":") && !inet6Address.endsWith("::")) {
            return false;
        }
        Object[] octets = inet6Address.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (inet6Address.endsWith("::")) {
                octetList.add("");
            } else if (inet6Address.startsWith("::") && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray();
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (octet.length() == 0) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (octet.indexOf(".") > -1) {
                    if (!inet6Address.endsWith(octet)) {
                        return false;
                    }
                    if (index > octets.length - 1 || index > 6) {
                        return false;
                    }
                    if (!SuperBladeTool.validateIP(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.valueOf(octet, 16);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets >= 8 || containsCompressedZeroes;
    }

    public static void addDir(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i = 0; i < paths.length; ++i) {
                if (!s.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static void setMiscOption() {
        String oemRAKP;
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        int debug_level = 0;
        try {
            debug_level = Integer.parseInt(ca.getProperty("debug_level"));
        }
        catch (NumberFormatException ex) {
            debug_level = 0;
        }
        GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = debug_level;
        String debug = ca.getProperty("debug_trace");
        if ("on".equals(debug)) {
            GlobalDefine.DEBUG_TRACE = true;
        }
        if ("on".equals(oemRAKP = ca.getProperty("oem_rakp"))) {
            GlobalDefine.OEM_RAKP_FLAG = true;
        }
    }
}

