/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MicroBladeBiosCommand
extends MicroBladeCommand {
    @Override
    public void execute() throws Exception {
        byte bIndex;
        String bladeIndex;
        BladeRemoteInfo[] bladeRemoteInfos;
        String biosFile;
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        if (this.getParameters() == null || this.getParameters().length < 1) {
            MOut.G(this).println("[<blade index> [node index]] <BIOSFilename> is required");
            MOut.G(this).println("");
            MOut.G(this).println("Ex: Update the bios of b1 node 3.");
            MOut.G(this).println("IPMI>microblade bios b1 3 C:\\bios100.bin");
            MOut.G(this).println("Ex: Update the bios of all nodes of b12.");
            MOut.G(this).println("IPMI>microblade bios b12 C:\\bios100.bin");
            MOut.G(this).println("Ex: Update the bios of all nodes.");
            MOut.G(this).println("IPMI>microblade bios C:\\bios100.bin");
            MOut.G(this).println("");
            MOut.G(this).println("Please use \"task\" command to manage the BIOS update tasks.");
            this.statusCode = 0;
            return;
        }
        int nodeIndex = 0;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            return;
        }
        if (this.getParameters().length == 1) {
            biosFile = this.getParameters()[0];
            bladeRemoteInfos = ipmiMicroBladeOEMCommand.getAllBladeRemoteInfo(28);
        } else if (this.getParameters().length == 2) {
            bladeIndex = this.getParameters()[0];
            biosFile = this.getParameters()[1];
            bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            bladeRemoteInfos = new BladeRemoteInfo[]{ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex)};
            if (!bladeRemoteInfos[0].isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
        } else {
            bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            biosFile = this.getParameters()[2];
            bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            bladeRemoteInfos = new BladeRemoteInfo[]{ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex)};
            if (!bladeRemoteInfos[0].isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
        }
        sessionController.closeSession();
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(ipmiMicroBladeOEMCommand.getIPMIInterface());
        IPMIX9BIOSOEMCommand.BIOSInfo biosFileInfo = ipmiX9BIOSOEMCommand.checkBIOSImage(biosFile);
        if (biosFileInfo == null) {
            throw new Exception("BIOS File invalid");
        }
        MOut.G(this).println(biosFileInfo.toStringFromBIOSImage());
        for (int i = 0; i < bladeRemoteInfos.length; ++i) {
            BladeRemoteInfo bladeRemoteInfo = bladeRemoteInfos[i];
            if (nodeIndex > 0) {
                NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(nodeIndex - 1);
                String args = "task run " + nodeRemoteInfo.getBMCPIP() + " " + nodeRemoteInfo.getDecryptedUsername() + " " + nodeRemoteInfo.getDecryptedPassword() + " bios update " + biosFile;
                MOut.G(this).println(args);
                Command command = this.getOriginalParser().parse(this.getOriginalParser().argumentRoot, MicroBladeBiosCommand.getCommandArray(args));
                if (command == null) {
                    this.statusCode = 180;
                    return;
                }
                if (!command.isSupportBackgroundModeForTaskRunCommand) {
                    this.statusCode = 154;
                    return;
                }
                command.setConfig(this.config);
                command.setOriginalParser(this.getOriginalParser());
                command.execute();
                break;
            }
            for (int j = 0; j < bladeRemoteInfo.nodeCount; ++j) {
                NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(j);
                String args = "task run " + nodeRemoteInfo.getBMCPIP() + " " + nodeRemoteInfo.getDecryptedUsername() + " " + nodeRemoteInfo.getDecryptedPassword() + " bios update " + biosFile;
                MOut.G(this).println(args);
                Command command = this.getOriginalParser().parse(this.getOriginalParser().argumentRoot, MicroBladeBiosCommand.getCommandArray(args));
                if (command == null) {
                    this.statusCode = 180;
                    return;
                }
                if (!command.isSupportBackgroundModeForTaskRunCommand) {
                    this.statusCode = 154;
                    return;
                }
                command.setConfig(this.config);
                command.setOriginalParser(this.getOriginalParser());
                command.execute();
            }
        }
        this.statusCode = 0;
    }

    public static final String[] getCommandArray(String commandLine) {
        ArrayList<String> string = new ArrayList<String>();
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            string.add(token);
        }
        String[] args = new String[string.size()];
        return string.toArray(args);
    }
}

