/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class FRU_Product {
    public byte formatVersion = 1;
    public byte length;
    public byte languageCode = 0;
    public byte productManufacturerNameLength;
    public byte[] productManufacturerName = new byte[0];
    public byte productNameLength;
    public byte[] productName = new byte[0];
    public byte productPartModelNumberLength;
    public byte[] productPartModelNumber = new byte[0];
    public byte productVersionLength;
    public byte[] productVersion = new byte[0];
    public byte productSerialNumberLength;
    public byte[] productSerialNumber = new byte[0];
    public byte assetTagLength;
    public byte[] assetTag = new byte[0];
    public byte fruFileIDLength;
    public byte[] fruFileID = new byte[0];
    public byte[] customProductInfo = new byte[0];
    public byte endOfInfoField = (byte)-63;
    public byte checkSum;

    public byte[] toRaw() {
        int i;
        this.checkSum = 0;
        int size = 12 + this.productManufacturerName.length + this.productName.length + this.productPartModelNumber.length + this.productVersion.length + this.productSerialNumber.length + this.assetTag.length + this.fruFileID.length + this.customProductInfo.length;
        int padSize = 8 - size % 8;
        if (padSize == 8) {
            padSize = 0;
        }
        byte[] raw = new byte[size + padSize];
        int index = 0;
        raw[index] = this.formatVersion;
        raw[++index] = (byte)(raw.length / 8);
        raw[++index] = this.languageCode;
        raw[++index] = this.productManufacturerNameLength = (byte)(192 + this.productManufacturerName.length);
        System.arraycopy(this.productManufacturerName, 0, raw, ++index, this.productManufacturerName.length);
        raw[index += this.productManufacturerName.length] = this.productNameLength = (byte)(192 + this.productName.length);
        System.arraycopy(this.productName, 0, raw, ++index, this.productName.length);
        raw[index += this.productName.length] = this.productPartModelNumberLength = (byte)(192 + this.productPartModelNumber.length);
        System.arraycopy(this.productPartModelNumber, 0, raw, ++index, this.productPartModelNumber.length);
        raw[index += this.productPartModelNumber.length] = this.productVersionLength = (byte)(192 + this.productVersion.length);
        System.arraycopy(this.productVersion, 0, raw, ++index, this.productVersion.length);
        raw[index += this.productVersion.length] = this.productSerialNumberLength = (byte)(192 + this.productSerialNumber.length);
        System.arraycopy(this.productSerialNumber, 0, raw, ++index, this.productSerialNumber.length);
        raw[index += this.productSerialNumber.length] = this.assetTagLength = (byte)(192 + this.assetTag.length);
        System.arraycopy(this.assetTag, 0, raw, ++index, this.assetTag.length);
        raw[index += this.assetTag.length] = this.fruFileIDLength = (byte)(192 + this.fruFileID.length);
        System.arraycopy(this.fruFileID, 0, raw, ++index, this.fruFileID.length);
        System.arraycopy(this.customProductInfo, 0, raw, index += this.fruFileID.length, this.customProductInfo.length);
        raw[index += this.customProductInfo.length] = this.endOfInfoField;
        ++index;
        for (i = 0; i < padSize; ++i) {
            raw[index] = 0;
            ++index;
        }
        for (i = 0; i < raw.length - 1; ++i) {
            this.checkSum = (byte)(this.checkSum + raw[i]);
        }
        byte tt = this.checkSum;
        raw[index] = this.checkSum = (byte)(-this.checkSum);
        return raw;
    }

    public void testData() {
        this.customProductInfo = new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11};
        this.fruFileID = "P_FRUID123".getBytes();
    }
}

