;$Author:   DCODY  $
;$Date:   27 Jul 1992 11:39:40  $
;$Header:   W:/sccs/mixers/cmixers.asv   1.2   27 Jul 1992 11:39:40   DCODY  $
;$Log:   W:/sccs/mixers/cmixers.asv  $
;  
;     Rev 1.2   27 Jul 1992 11:39:40   DCODY
;  moved 32 bit vector pointers into the data segment
;  
;     Rev 1.1   23 Jun 1992 16:45:50   DCODY
;  PAS2 update
;  
;     Rev 1.0   15 Jun 1992 09:41:14   BCRANE
;  Initial revision.
;$Logfile:   W:/sccs/mixers/cmixers.asv  $
;$Modtimes$
;$Revision:   1.2  $

	Title	cMIXERS -- Games Authors 'C' interface to MIXER/VOLUME/CROSS/FILTER
	page	64,131

;   /*\
;---|*|----====< cMIXERS >====----
;---|*|
;---|*|  This module contains the code for supporting the mixers,filter,
;---|*|  volume control, and PCM I/O with access from 'C'.
;---|*|
;   |*|  Media Vision, Inc. Copyright (c) 1991, All Rights Reserved
;---|*|
;   \*/

;   /*\
;---|*|
;---|*|----------===========================================------------------
;---|*|----------====< cMIXERS.ASM function defintions >====------------------
;---|*|----------===========================================------------------
;---|*|
;---|*| This function returns a segment:offset to the table of 10 functions
;---|*| The table is made up of 32 bit pointers to the ten far routines.
;---|*| Each routine has different register requirements:
;---|*|
;---|*|  Function #1 Set a Mixer.
;---|*|
;---|*|      void cMVSetMixerFunction(int1,int2,int3);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      int1 is the setting      (0% - 100%)
;---|*| 	      int2 is the mixer select (BI_OUTPUTMIXER | BI_INPUTMIXER)
;---|*| 	      int3 is the channel      (ex: BI_L_FM, BI_R_FM, etc.)
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		None
;---|*|
;---|*|
;---|*|  Function #2 Set the Volume/Equalizer device.
;---|*|
;---|*|      void cMVSetVolumeFunction(int1,int2);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      int1 is the setting      (0% - 100%)
;---|*| 	      int2 is the volume channel select:
;---|*|
;---|*| 		    BI_VOLLOUD
;---|*| 		    BI_VOLENHANCE
;---|*| 		    BI_VOLBASS
;---|*| 		    BI_VOLTREBLE
;---|*| 		    BI_VOLLEFT
;---|*| 		    BI_VOLRIGHT
;---|*|                     BI_VOLMODE
;---|*|
;---|*| 		Since some of the devices are swithes, a 0% turns it
;---|*| 		off, and a 100% turns it on. The switches are:
;---|*|
;---|*| 		    BI_bVOLLOUD  --  ENHANCED STEREO switch
;---|*| 		    BI_bVOLENH	 --  LOUDNESS switch
;---|*|
;---|*| 	    Exit Condition:
;---|*|                 None
;---|*|
;---|*|
;---|*|  Function #3 Set the Filter.
;---|*|
;---|*|      void cMVSetFilterFunction(int);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	       int is a new setting    (0% - 100%)
;---|*|
;---|*| 		0% filters out anything higher than 0k hz (is mute)
;---|*| 	      100% filters out anything higher than 20 khz
;---|*|
;---|*| 	    Exit Condition:
;---|*|                 None
;---|*|
;---|*|
;---|*|  Function #4 Set the Cross Channel.
;---|*|
;---|*|      void cMVSetCrossChannel(int);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	       int holds the new cross channel mask bits:
;---|*|
;---|*| 		   00000001b Right to Right
;---|*| 		   00000010b Left  to Right
;---|*| 		   00000100b Right to Left
;---|*| 		   00001000b Left  to Left
;---|*|
;---|*| 		   A set bit turns ON the connection.
;---|*| 		   A clear bit turns OFF the connection.
;---|*|
;---|*| 	    Exit Condition:
;---|*|                 None
;---|*|
;---|*|
;---|*|  Function #5 Get a Mixer setting.
;---|*|
;---|*|      int cMVGetMixerFunction(int1,int2);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      int1 is the mixer select (BI_OUTPUTMIXER | BI_INPUTMIXER)
;---|*| 	      int2 is the channel      (ex: BI_L_FM, BI_R_FM, etc.)
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		AX is the setting      (0% - 100%)
;---|*|
;---|*|
;---|*|  Function #6 Get the Volume/Equalizer setting.
;---|*|
;---|*|      int cMVGetVolumeFunction(int);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	       int is the volume channel select:
;---|*|
;---|*| 		    BI_VOLLOUD
;---|*| 		    BI_VOLENHANCE
;---|*| 		    BI_VOLBASS
;---|*| 		    BI_VOLTREBLE
;---|*| 		    BI_VOLLEFT
;---|*| 		    BI_VOLRIGHT
;---|*|                     BI_VOLMODE
;---|*|
;---|*| 		Since some of the devices are swithes, a 0% turns it
;---|*| 		off, and a 100% turns it on. The switches are:
;---|*|
;---|*| 		    BI_bVOLLOUD  --  ENHANCED STEREO switch
;---|*| 		    BI_bVOLENH	 --  LOUDNESS switch
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		AX is the setting      (0% - 100%)
;---|*|
;---|*|
;---|*|  Function #7 Get the Filter setting.
;---|*|
;---|*|      int cMVGetFilterFunction();
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      None
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		AX is a new setting    (0% - 100%)
;---|*| 		0% filters out anything higher than 0k hz (is mute)
;---|*| 	      100% filters out anything higher than 20 khz
;---|*|
;---|*|
;---|*|  Function #8 Get the Cross Channel setting
;---|*|
;---|*|      int cMVGetCrossChannel();
;---|*|
;---|*| 	    Entry Condition:
;---|*| 		None
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		AX holds the new cross channel mask bits:
;---|*|
;---|*| 		   00000001b Right to Right
;---|*| 		   00000010b Left  to Right
;---|*| 		   00000100b Right to Left
;---|*| 		   00001000b Left  to Left
;---|*|
;---|*| 		   A set bit turns ON the connection.
;---|*| 		   A clear bit turns OFF the connection.
;---|*|
;---|*|
;---|*|  Function #9 Get/Set the Real Sound bit.
;---|*|
;---|*|      int cMVRealSoundSwitch(int1,int2);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      int1 may hold 0 to clear the bit, 100 to set the bit
;---|*| 	      int2 determines if the bit is read or written. If cx
;---|*| 		   is 0, the bit is read. If cx is not zero, the
;---|*| 		   bit is written.
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		if the bit is read, AX holds 0 for off, 100 for on.
;---|*|
;---|*|  Function #10 Get/Set the Split FM chips bit.
;---|*|
;---|*|      int cMVFMSplitSwitch(int1,int2);
;---|*|
;---|*| 	    Entry Condition:
;---|*| 	      int1 may hold 0 to clear the bit, 100 to set the bit
;---|*| 	      int2 determines if the bit is read or written. If cx
;---|*| 		   is 0, the bit is read. If cx is not zero, the
;---|*| 		   bit is written.
;---|*|
;---|*| 	    Exit Condition:
;---|*| 		if the bit is read, AX holds 0 for off, 100 for on.
;---|*|
;   \*/

;   /*\
;---|*|--------------------====< Code Section >====--------------------
;   \*/

	.xlist
	include model.inc
        include masm.inc
	.list

	.data
;
; external data
;
	extrn	MVSetMixerFunction:dword	; set the mixers
	extrn	MVSetVolumeFunction:dword	; set the volume
	extrn	MVSetFilterFunction:dword	; set the filter
	extrn	MVSetCrossChannel:dword 	; set the cross channel
	extrn	MVGetMixerFunction:dword	; get the mixers
	extrn	MVGetVolumeFunction:dword	; get the volume
	extrn	MVGetFilterFunction:dword	; get the filter
	extrn	MVGetCrossChannel:dword 	; get the cross channel
	extrn	MVRealSoundSwitch:dword 	; get/set the realsound bit
	extrn	MVFMSplitSwitch:dword		; get/set the FM split bit

	.code

;
;   /*\
;---|*|-----------------------=======================--------------------------
;---|*|-------------------====< cMVSetMixerFunction >====----------------------
;---|*|-----------------------=======================--------------------------
;---|*|
;---|*|  Function #1 Set a Mixer.
;---|*|
;---|*|    void cMVSetMixerFunction(int1,int2,int3);
;---|*|
;---|*|      Entry Condition:
;---|*|        int1 is the setting	(0% - 100%)
;---|*|        int2 is the mixer select (BI_OUTPUTMIXER | BI_INPUTMIXER)
;---|*|        int3 is the channel	(ex: BI_L_FM, BI_R_FM, etc.)
;---|*|
;---|*|      Exit Condition:
;---|*| 	 none
;---|*|
;   \*/

	public	cMVSetMixerFunction
cMVSetMixerFunction proc
	push	bp
	mov	bp,sp

	mov	bx,wParm1
	mov	cx,wParm2
	mov	dx,wParm3

	call	[MVSetMixerFunction]

	pop	bp
	ret

cMVSetMixerFunction endp

;
;   /*\
;---|*|----------------------========================-----------------------
;---|*|------------------====< cMVSetVolumeFunction >====-------------------
;---|*|----------------------========================-----------------------
;---|*|
;---|*|  Function #2 Set the Volume/Equalizer device.
;---|*|
;---|*|    void cMVSetVolumeFunction(int1,int2);
;---|*|
;---|*|      Entry Condition:
;---|*|        int1 is the setting	(0% - 100%)
;---|*|        int2 is the volume channel select:
;---|*|
;---|*| 	     BI_VOLLOUD
;---|*| 	     BI_VOLENHANCE
;---|*| 	     BI_VOLBASS
;---|*| 	     BI_VOLTREBLE
;---|*| 	     BI_VOLLEFT
;---|*| 	     BI_VOLRIGHT
;---|*| 	     BI_VOLMODE
;---|*|
;---|*| 	 Since some of the devices are swithes, a 0% turns it
;---|*| 	 off, and a 100% turns it on. The switches are:
;---|*|
;---|*| 	     BI_bVOLLOUD  --  ENHANCED STEREO switch
;---|*| 	     BI_bVOLENH   --  LOUDNESS switch
;---|*|
;---|*|      Exit Condition:
;---|*| 	 none
;---|*|
;   \*/

	public	cMVSetVolumeFunction
cMVSetVolumeFunction proc
	push	bp
	mov	bp,sp

	mov	bx,wParm1
	mov	cx,wParm2
	call	[MVSetVolumeFunction]

	pop	bp
	ret

cMVSetVolumeFunction endp


;   /*\
;---|*|----------------------========================--------------------------
;---|*|------------------====< cMVSetFilterFunction >====----------------------
;---|*|----------------------========================--------------------------
;---|*|
;---|*|  Function #3 Set the Filter.
;---|*|
;---|*|    void cMVSetFilterFunction(int);
;---|*|
;---|*|      Entry Condition:
;---|*| 	int is a new setting	(0% - 100%)
;---|*|
;---|*| 	 0% filters out anything higher than 0k hz (is mute)
;---|*|        100% filters out anything higher than 20 khz
;---|*|
;---|*|      Exit Condition:
;---|*| 	 none
;---|*|
;   \*/
	public	cMVSetFilterFunction
cMVSetFilterFunction proc
	push	bp
	mov	bp,sp

	mov	bx,wParm1
	call	[MVSetFilterFunction]

	pop	bp
	ret

cMVSetFilterFunction endp


;   /*\
;---|*|-----------------------======================---------------------------
;---|*|-------------------====< cMVSetCrossChannel >====-----------------------
;---|*|-----------------------======================---------------------------
;---|*|
;---|*|  Function #4 Set the Cross Channel.
;---|*|
;---|*|    void cMVSetCrossChannel(int);
;---|*|
;---|*|      Entry Condition:
;---|*| 	int holds the new cross channel mask bits:
;---|*|
;---|*| 	    00000001b Right to Right
;---|*| 	    00000010b Left  to Right
;---|*| 	    00000100b Right to Left
;---|*| 	    00001000b Left  to Left
;---|*|
;---|*| 	    A set bit turns ON the connection.
;---|*| 	    A clear bit turns OFF the connection.
;---|*|
;---|*|      Exit Condition:
;---|*| 	 none
;---|*|
;   \*/

	public	cMVSetCrossChannel
cMVSetCrossChannel proc
	push	bp
	mov	bp,sp

	mov	bx,wParm1
	call	[MVSetCrossChannel]

	pop	bp
	ret

cMVSetCrossChannel endp

;
;   /*\
;---|*|----------------------=======================--------------------------
;---|*|------------------====< cMVGetMixerFunction >====----------------------
;---|*|----------------------=======================--------------------------
;---|*|
;---|*|  Function #5 Get a Mixer setting.
;---|*|
;---|*|    int cMVGetMixerFunction(int1,int2);
;---|*|
;---|*|      Entry Condition:
;---|*|        int1 is the mixer select (BI_OUTPUTMIXER | BI_INPUTMIXER)
;---|*|        int2 is the channel	(ex: BI_L_FM, BI_R_FM, etc.)
;---|*|
;---|*|      Exit Condition:
;---|*| 	 AX holds the setting	(0% - 100%)
;---|*|
;   \*/

	public	cMVGetMixerFunction
cMVGetMixerFunction proc
	push	bp
	mov	bp,sp

	mov	cx,wParm1
	mov	dx,wParm2
	call	[MVGetMixerFunction]

	mov	ax,bx
        pop     bp
	ret

cMVGetMixerFunction endp

;
;   /*\
;---|*|---------------------========================----------------------
;---|*|-----------------====< cMVGetVolumeFunction >====------------------------
;---|*|---------------------========================----------------------
;---|*|
;---|*|  Function #6 Get the Volume/Equalizer setting.
;---|*|
;---|*|      int cMVGetVolumeFunction(int);
;---|*|
;---|*|      Entry Condition:
;---|*| 	 CX is the volume channel select:
;---|*|
;---|*| 	     BI_VOLLOUD
;---|*| 	     BI_VOLENHANCE
;---|*| 	     BI_VOLBASS
;---|*| 	     BI_VOLTREBLE
;---|*| 	     BI_VOLLEFT
;---|*| 	     BI_VOLRIGHT
;---|*| 	     BI_VOLMODE
;---|*|
;---|*| 	 Since some of the devices are swithes, a 0% turns it
;---|*| 	 off, and a 100% turns it on. The switches are:
;---|*|
;---|*| 	     BI_bVOLLOUD  --  ENHANCED STEREO switch
;---|*| 	     BI_bVOLENH   --  LOUDNESS switch
;---|*|
;---|*|      Exit Condition:
;---|*| 	 AX holds the setting (0% - 100%)
;---|*|
;   \*/

	public	cMVGetVolumeFunction
cMVGetVolumeFunction proc
	push	bp
	mov	bp,sp

	mov	cx,wParm1
	call	[MVGetVolumeFunction]

	mov	ax,bx
        pop     bp
	ret

cMVGetVolumeFunction endp

;
;   /*\
;---|*|----------------------========================--------------------------
;---|*|------------------====< cMVGetFilterFunction >====----------------------
;---|*|----------------------========================--------------------------
;---|*|
;---|*|  Function #7 Get the Filter setting.
;---|*|
;---|*|    int cMVGetFilterFunction();
;---|*|
;---|*|      Entry Condition:
;---|*|        None
;---|*|
;---|*|      Exit Condition:
;---|*| 	 AX is a new setting	(0% - 100%)
;---|*| 	 0% filters out anything higher than 0k hz (is mute)
;---|*|        100% filters out anything higher than 20 khz
;---|*|
;   \*/

	public	cMVGetFilterFunction
cMVGetFilterFunction proc
	call	[MVGetFilterFunction]
	mov	ax,bx
	ret

cMVGetFilterFunction endp

;
;   /*\
;---|*|-----------------------======================---------------------------
;---|*|-------------------====< cMVGetCrossChannel >====-----------------------
;---|*|-----------------------======================---------------------------
;---|*|
;---|*|  Function #8 Get the Cross Channel setting
;---|*|
;---|*|    int cMVGetCrossChannel();
;---|*|
;---|*|      Entry Condition:
;---|*| 	 None
;---|*|
;---|*|      Exit Condition:
;---|*| 	 AX holds the new cross channel mask bits:
;---|*|
;---|*| 	    00000001b Right to Right
;---|*| 	    00000010b Left  to Right
;---|*| 	    00000100b Right to Left
;---|*| 	    00001000b Left  to Left
;---|*|
;---|*| 	    A set bit turns ON the connection.
;---|*| 	    A clear bit turns OFF the connection.
;---|*|
;   \*/
;

	public	cMVGetCrossChannel
cMVGetCrossChannel   proc
	call	[MVGetCrossChannel]
	mov	ax,bx
	ret

cMVGetCrossChannel   endp

;
;   /*\
;---|*|--------------------======================------------------------------
;---|*|----------------====< cMVRealSoundSwitch >====--------------------------
;---|*|--------------------======================------------------------------
;---|*|
;---|*|  Function #9 Get/Set the Real Sound bit.
;---|*|
;---|*|    int cMVRealSoundSwitch (int1,int2);
;---|*|
;---|*|      Entry Condition:
;---|*|        int1 may hold 0 to clear the bit, 100 to set the bit
;---|*|        int2 determines if the bit is read or written. If cx
;---|*| 	    is 0, the bit is read. If cx is not zero, the
;---|*| 	    bit is written.
;---|*|
;---|*|      Exit Condition:
;---|*| 	 if the bit is read, AX holds 0 for off, 100 for on.
;---|*|
;   \*/
;
	public	cMVRealSoundSwitch
cMVRealSoundSwitch proc
        push    bp
	mov	bp,sp

	mov	bx,wParm1
	mov	cx,wParm2
	call	[MVRealSoundSwitch]

	mov	ax,bx
        pop     bp
	ret

cMVRealSoundSwitch endp

;
;   /*\
;---|*|--------------------======================------------------------------
;---|*|----------------====<  cMVFMSplitSwitch	>====--------------------------
;---|*|--------------------======================------------------------------
;---|*|
;---|*|  Function #10 Get/Set the FM split bit.
;---|*|
;---|*|    int cMVFMSplitSwitch   (int1,int2);
;---|*|
;---|*|      Entry Condition:
;---|*|        int1 may hold 0 to clear the bit, 100 to set the bit
;---|*|        int2 determines if the bit is read or written. If cx
;---|*| 	    is 0, the bit is read. If cx is not zero, the
;---|*| 	    bit is written.
;---|*|
;---|*|      Exit Condition:
;---|*| 	 if the bit is read, AX holds 0 for off, 100 for on.
;---|*|
;   \*/
;
	public	cMVFMSplitSwitch
cMVFMSplitSwitch   proc
        push    bp
	mov	bp,sp

	mov	bx,wParm1
	mov	cx,wParm2
	call	[MVFMSplitSwitch]

	mov	ax,bx
        pop     bp
	ret

cMVFMSplitSwitch   endp


;   /*\
;---|*|----====< end of cMIXERS.ASM >====----
;   \*/

	end


